/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.https.CertConstraintsInterceptor;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class ChainInitiationObserver
implements MessageObserver {
    protected Endpoint endpoint;
    protected Bus bus;
    protected ClassLoader loader;
    private final PhaseChainCache chainCache;
    private static final Logger LOG = LogUtils.getL7dLogger(ChainInitiationObserver.class);
    static final long serialVersionUID = -999921314724271397L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ChainInitiationObserver(Endpoint endpoint, Bus bus) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.ChainInitiationObserver", "<init>", new Object[]{endpoint, bus});
        }
        this.chainCache = new PhaseChainCache();
        this.endpoint = endpoint;
        this.bus = bus;
        if (bus != null) {
            this.loader = bus.getExtension(ClassLoader.class);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.ChainInitiationObserver", "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={RuntimeException.class})
    public void onMessage(Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.ChainInitiationObserver", "onMessage", new Object[]{m});
        }
        Bus origBus = BusFactory.getAndSetThreadDefaultBus(this.bus);
        try {
            Message message;
            Exchange exchange;
            InterceptorChain phaseChain;
            if (m.getInterceptorChain() != null) {
                InterceptorChain interceptorChain = phaseChain = m.getInterceptorChain();
                synchronized (interceptorChain) {
                    if (phaseChain.getState() == InterceptorChain.State.PAUSED || phaseChain.getState() == InterceptorChain.State.SUSPENDED) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("onMessage: Phase Chain was paused/suspended, resuming");
                        }
                        phaseChain.resume();
                        // MONITOREXIT @DISABLED, blocks:[16, 0, 5, 15] lbl13 : MonitorExitStatement: MONITOREXIT : var4_4
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.exiting("org.apache.cxf.transport.ChainInitiationObserver", "onMessage");
                        }
                        return;
                    }
                }
            }
            if ((exchange = (message = this.getBinding().createMessage(m)).getExchange()) == null) {
                exchange = new ExchangeImpl();
                m.setExchange(exchange);
            }
            exchange.setInMessage(message);
            this.setExchangeProperties(exchange, message);
            InterceptorProvider dbp = null;
            if (this.endpoint.getService().getDataBinding() instanceof InterceptorProvider) {
                dbp = (InterceptorProvider)((Object)this.endpoint.getService().getDataBinding());
            }
            phaseChain = dbp == null ? this.chainCache.get(this.bus.getExtension(PhaseManager.class).getInPhases(), this.bus.getInInterceptors(), this.endpoint.getService().getInInterceptors(), this.endpoint.getInInterceptors(), this.getBinding().getInInterceptors()) : this.chainCache.get(this.bus.getExtension(PhaseManager.class).getInPhases(), this.bus.getInInterceptors(), this.endpoint.getService().getInInterceptors(), this.endpoint.getInInterceptors(), this.getBinding().getInInterceptors(), dbp.getInInterceptors());
            message.setInterceptorChain(phaseChain);
            phaseChain.setFaultObserver(this.endpoint.getOutFaultObserver());
            this.addToChain(phaseChain, message);
            phaseChain.doIntercept(message);
        }
        finally {
            if (origBus != this.bus) {
                BusFactory.setThreadDefaultBus(origBus);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.ChainInitiationObserver", "onMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addToChain(InterceptorChain chain, Message m) {
        Collection<Interceptor> is;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.ChainInitiationObserver", "addToChain", new Object[]{chain, m});
        }
        Collection<InterceptorProvider> providers = CastUtils.cast((Collection)m.get(Message.INTERCEPTOR_PROVIDERS));
        if (providers != null) {
            for (InterceptorProvider p : providers) {
                chain.add(p.getInInterceptors());
            }
        }
        if ((is = CastUtils.cast((Collection)m.get(Message.IN_INTERCEPTORS))) != null) {
            String rqURL = (String)m.get("org.apache.cxf.request.url");
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("addToChain: Request URL: " + rqURL);
            }
            boolean isHttps = rqURL != null && rqURL.indexOf("https:") > -1;
            for (Interceptor i : is) {
                if (i instanceof CertConstraintsInterceptor && !isHttps) continue;
                chain.add(i);
            }
        }
        if (m.getDestination() instanceof InterceptorProvider) {
            chain.add(((InterceptorProvider)((Object)m.getDestination())).getInInterceptors());
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.ChainInitiationObserver", "addToChain");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Binding getBinding() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.ChainInitiationObserver", "getBinding", new Object[0]);
        }
        Binding binding = this.endpoint.getBinding();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            binding = binding;
            LOG.exiting("org.apache.cxf.transport.ChainInitiationObserver", "getBinding", binding);
        }
        return binding;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setExchangeProperties(Exchange exchange, Message m) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.ChainInitiationObserver", "setExchangeProperties", new Object[]{exchange, m});
        }
        boolean isFineEnabled = LOG.isLoggable(Level.FINE);
        exchange.put(Endpoint.class, this.endpoint);
        exchange.put(Binding.class, this.getBinding());
        exchange.put(Bus.class, this.bus);
        if (exchange.getDestination() == null) {
            exchange.setDestination(m.getDestination());
        }
        if (this.endpoint != null && this.endpoint.getService() != null) {
            exchange.put(Service.class, this.endpoint.getService());
            EndpointInfo endpointInfo = this.endpoint.getEndpointInfo();
            if (endpointInfo.getService() != null) {
                QName serviceQName = endpointInfo.getService().getName();
                if (isFineEnabled) {
                    LOG.fine("setExchangeProperties: WSDL service Qname: " + serviceQName);
                }
                exchange.put("javax.xml.ws.wsdl.service", serviceQName);
                QName interfaceQName = endpointInfo.getService().getInterface().getName();
                exchange.put("javax.xml.ws.wsdl.interface", interfaceQName);
                QName portQName = endpointInfo.getName();
                if (isFineEnabled) {
                    LOG.fine("setExchangeProperties: WSDL Port Qname: " + portQName);
                }
                exchange.put("javax.xml.ws.wsdl.port", portQName);
                URI wsdlDescription = endpointInfo.getProperty("URI", URI.class);
                if (wsdlDescription == null && !endpointInfo.hasProperty("URI")) {
                    block13: {
                        String address = endpointInfo.getAddress();
                        if (isFineEnabled) {
                            LOG.fine("setExchangeProperties: Endpoint address: " + address);
                        }
                        try {
                            wsdlDescription = new URI(address + "?wsdl");
                        }
                        catch (URISyntaxException e) {
                            if (!isFineEnabled) break block13;
                            LOG.fine("setExchangeProperties: Ignoring URISyntaxException: " + e);
                        }
                    }
                    endpointInfo.setProperty("URI", wsdlDescription);
                }
                exchange.put("javax.xml.ws.wsdl.description", wsdlDescription);
            }
        } else {
            if (isFineEnabled) {
                LOG.fine("setExchangeProperties: Setting Service.class to null");
            }
            exchange.put(Service.class, null);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.transport.ChainInitiationObserver", "setExchangeProperties");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Endpoint getEndpoint() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.transport.ChainInitiationObserver", "getEndpoint", new Object[0]);
        }
        Endpoint endpoint = this.endpoint;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpoint = endpoint;
            LOG.exiting("org.apache.cxf.transport.ChainInitiationObserver", "getEndpoint", endpoint);
        }
        return endpoint;
    }
}

