/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.impl.AbstractPropertiesImpl;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public abstract class AbstractRequestContextImpl
extends AbstractPropertiesImpl {
    protected HttpHeaders h;
    private boolean responseContext;

    public AbstractRequestContextImpl(Message message, boolean responseContext) {
        super(message);
        this.h = new HttpHeadersImpl(message);
        this.responseContext = responseContext;
    }

    public void abortWith(Response response) {
        this.checkContext();
        this.m.getExchange().put(Response.class, JAXRSUtils.copyResponseIfNeeded(response));
    }

    public List<Locale> getAcceptableLanguages() {
        return this.getHttpHeaders().getAcceptableLanguages();
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.getHttpHeaders().getAcceptableMediaTypes();
    }

    public Map<String, Cookie> getCookies() {
        return this.getHttpHeaders().getCookies();
    }

    public Date getDate() {
        return this.getHttpHeaders().getDate();
    }

    public String getHeaderString(String name) {
        return this.getHttpHeaders().getHeaderString(name);
    }

    public Locale getLanguage() {
        return this.getHttpHeaders().getLanguage();
    }

    public int getLength() {
        return this.getHttpHeaders().getLength();
    }

    public MediaType getMediaType() {
        return this.getHttpHeaders().getMediaType();
    }

    public String getMethod() {
        return HttpUtils.getProtocolHeader(this.m, "org.apache.cxf.request.method", null);
    }

    public void setMethod(String method) throws IllegalStateException {
        this.checkContext();
        this.m.put("org.apache.cxf.request.method", method);
    }

    protected HttpHeaders getHttpHeaders() {
        return this.h != null ? this.h : new HttpHeadersImpl(this.m);
    }

    protected void checkContext() {
        if (this.responseContext) {
            throw new IllegalStateException();
        }
    }
}

