/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class CumulativeLogger {
    private Timer timer = null;
    private static long lbLoggingThreadInterval = 10000L;
    private Map<String, LookupFailure> lookupFailureTable = new HashMap<String, LookupFailure>();
    private boolean timerStarted = false;
    static final TraceComponent tc = Tr.register(CumulativeLogger.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    private static CumulativeLogger loggerInstance = null;

    private CumulativeLogger() {
        this.timer = new Timer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CumulativeLogger getLoggerInstance() {
        if (loggerInstance != null) return loggerInstance;
        Class<CumulativeLogger> clazz = CumulativeLogger.class;
        synchronized (CumulativeLogger.class) {
            if (null != loggerInstance) return loggerInstance;
            loggerInstance = new CumulativeLogger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return loggerInstance;
        }
    }

    private void startTimer() {
        if (!this.timerStarted) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Starting LoggingTimer.", (Object[])new Object[0]);
            }
            this.timer.schedule((TimerTask)new LoggingTimerTask(), 30000L, lbLoggingThreadInterval);
            this.timerStarted = true;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"LoggingTimer already started.", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _logLookupFailure(String hostname) {
        Map<String, LookupFailure> map = this.lookupFailureTable;
        synchronized (map) {
            if (this.lookupFailureTable.size() < 5) {
                LookupFailure clusterObject;
                if (!this.timerStarted) {
                    this.startTimer();
                }
                if ((clusterObject = this.lookupFailureTable.get(hostname)) == null) {
                    clusterObject = new LookupFailure(hostname);
                    this.lookupFailureTable.put(hostname, clusterObject);
                }
                clusterObject.incrementCount();
            }
        }
    }

    public static void logLookupFailure(String hostnameName) {
        CumulativeLogger.getLoggerInstance()._logLookupFailure(hostnameName);
    }

    class LoggingTimerTask
    extends TimerTask {
        LoggingTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            Map map = CumulativeLogger.this.lookupFailureTable;
            synchronized (map) {
                if (!CumulativeLogger.this.lookupFailureTable.isEmpty()) {
                    for (Map.Entry entry : CumulativeLogger.this.lookupFailureTable.entrySet()) {
                        if (!tc.isWarningEnabled()) continue;
                        Tr.warning((TraceComponent)tc, (String)"CWUDP0006I", (Object[])new Object[]{new Object[]{((LookupFailure)entry.getValue()).getServerName(), Integer.toString(((LookupFailure)entry.getValue()).getCount())}});
                    }
                    CumulativeLogger.this.lookupFailureTable.clear();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Stopping LoggingTimer.", (Object[])new Object[0]);
                    }
                    CumulativeLogger.this.timer.cancel();
                    CumulativeLogger.this.timerStarted = false;
                }
            }
        }
    }

    private static class LookupFailure {
        private String serverName = null;
        private int count = 0;

        LookupFailure(String serverName) {
            this.serverName = serverName;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void incrementCount() {
            ++this.count;
        }

        public String getServerName() {
            return this.serverName;
        }
    }
}

