/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import jakarta.data.Sort;
import jakarta.data.exceptions.DataException;
import jakarta.data.page.CursoredPage;
import jakarta.data.page.PageRequest;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CursoredPageImpl<T>
implements CursoredPage<T> {
    private static final TraceComponent tc = Tr.register(CursoredPageImpl.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final Object[] args;
    private final boolean isForward;
    private final PageRequest pageRequest;
    private final QueryInfo queryInfo;
    private final List<T> results;
    private long totalElements = -1L;
    static final long serialVersionUID = 3258932666424991653L;

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={Exception.class})
    CursoredPageImpl(QueryInfo queryInfo, PageRequest pageRequest, Object[] args) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{queryInfo, pageRequest, queryInfo.loggable(args)});
        }
        if (pageRequest == null) {
            queryInfo.missingPageRequest();
        }
        this.args = args;
        this.queryInfo = queryInfo;
        this.pageRequest = pageRequest;
        this.isForward = this.pageRequest.mode() != PageRequest.Mode.CURSOR_PREVIOUS;
        Optional cursor = this.pageRequest.cursor();
        int maxPageSize = this.pageRequest.size();
        int firstResult = this.pageRequest.mode() == PageRequest.Mode.OFFSET ? queryInfo.computeOffset(this.pageRequest) : 0;
        try (EntityManager em = queryInfo.entityInfo.builder.createEntityManager();){
            List resultList;
            String jpql = cursor.isEmpty() ? queryInfo.jpql : (this.isForward ? queryInfo.jpqlAfterCursor : queryInfo.jpqlBeforeCursor);
            Query query = em.createQuery(jpql);
            queryInfo.setParameters(query, args);
            if (cursor.isPresent()) {
                queryInfo.setParametersFromCursor(query, (PageRequest.Cursor)cursor.get());
            }
            query.setHint("jakarta.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.BYPASS);
            query.setFirstResult(firstResult);
            query.setMaxResults(maxPageSize + (maxPageSize == Integer.MAX_VALUE ? 0 : 1));
            this.results = resultList = query.getResultList();
            if (!this.isForward) {
                int size = this.results.size();
                int i = 0;
                for (int j = size - (size > maxPageSize ? 2 : 1); i < j; ++i, --j) {
                    Collections.swap(this.results, i, j);
                }
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @FFDCIgnore(value={Exception.class})
    private long countTotalElements() {
        if (!this.pageRequest.requestTotal()) {
            throw DataExtension.exc(IllegalStateException.class, "CWWKD1042.no.totals", this.queryInfo.method.getName(), this.queryInfo.repositoryInterface.getName(), this.pageRequest);
        }
        if (this.queryInfo.jpqlCount.length() < 15) {
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1119.keyword.prevents.count", this.queryInfo.method.getName(), this.queryInfo.repositoryInterface.getName(), this.queryInfo.jpqlCount, this.queryInfo.jpql);
        }
        try (EntityManager em = this.queryInfo.entityInfo.builder.createEntityManager();){
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("query for count: " + this.queryInfo.jpqlCount), (Object[])new Object[0]);
            }
            TypedQuery query = em.createQuery(this.queryInfo.jpqlCount, Long.class);
            this.queryInfo.setParameters((Query)query, this.args);
            query.setHint("jakarta.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.BYPASS);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    @Trivial
    public List<T> content() {
        int max;
        List content;
        int size = this.results.size();
        List list = content = size > (max = this.pageRequest.size()) ? new ResultList(max) : this.results;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"content", (Object[])new Object[]{this.queryInfo.loggable(content)});
        }
        return content;
    }

    /*
     * WARNING - void declaration
     */
    public PageRequest.Cursor cursor(int index) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (index < 0 || index >= this.pageRequest.size()) {
            throw new IllegalArgumentException("index: " + index);
        }
        T entity = this.results.get(index);
        Object[] keyElements = new Object[this.queryInfo.sorts.size()];
        int k = 0;
        for (Sort<Object> keyInfo : this.queryInfo.sorts) {
            try {
                List<Member> accessors = this.queryInfo.entityInfo.attributeAccessors.get(keyInfo.property());
                Object value = entity;
                for (Member accessor : accessors) {
                    if (accessor instanceof Method) {
                        value = ((Method)accessor).invoke(value, new Object[0]);
                        continue;
                    }
                    value = ((Field)accessor).get(value);
                }
                keyElements[k++] = value;
                if (!trace || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)this, (TraceComponent)tc, (String)("key element " + k + ": " + String.valueOf(this.queryInfo.loggable(value))), (Object[])new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException accessors) {
                void x;
                FFDCFilter.processException((Throwable)accessors, (String)"io.openliberty.data.internal.persistence.CursoredPageImpl", (String)"235", (Object)this, (Object[])new Object[]{index});
                throw new DataException(x.getCause());
            }
        }
        return PageRequest.Cursor.forKey((Object[])keyElements);
    }

    public boolean hasNext() {
        int minToHaveNextPage = this.isForward ? this.pageRequest.size() + (this.pageRequest.size() == Integer.MAX_VALUE ? 0 : 1) : 1;
        return this.results.size() >= minToHaveNextPage;
    }

    public boolean hasPrevious() {
        int minToHavePreviousPage = this.isForward ? 1 : this.pageRequest.size() + (this.pageRequest.size() == Integer.MAX_VALUE ? 0 : 1);
        return this.results.size() >= minToHavePreviousPage;
    }

    public boolean hasTotals() {
        return this.queryInfo.jpqlCount.length() >= 15 && this.pageRequest.requestTotal();
    }

    public int numberOfElements() {
        int max;
        int size = this.results.size();
        return size > (max = this.pageRequest.size()) ? max : size;
    }

    public PageRequest pageRequest() {
        return this.pageRequest;
    }

    @Trivial
    public String toString() {
        int maxPageSize = this.pageRequest.size();
        int size = Math.min(this.results.size(), maxPageSize);
        StringBuilder s = new StringBuilder(200).append("CursoredPage ").append(this.pageRequest.page());
        if (this.totalElements >= 0L) {
            s.append('/');
            s.append(this.totalElements / (long)maxPageSize + (long)(this.totalElements % (long)maxPageSize > 0L ? 1 : 0));
        }
        if (!this.results.isEmpty()) {
            s.append(" of ").append(this.results.get(0).getClass().getSimpleName());
        }
        s.append(", size ").append(size);
        s.append('/').append(maxPageSize);
        s.append(this.isForward ? ", CURSOR_NEXT(" : " CURSOR_PREVIOUS(");
        boolean firstSort = true;
        if (this.queryInfo.sorts != null) {
            for (Sort<Object> sort : this.queryInfo.sorts) {
                if (firstSort) {
                    firstSort = false;
                } else {
                    s.append(", ");
                }
                s.append(sort.property());
                s.append(sort.isAscending() ? (sort.ignoreCase() ? " ASC IgnoreCase" : " ASC") : (sort.ignoreCase() ? " DESC IgnoreCase" : " DESC"));
            }
        }
        s.append(") @").append(Integer.toHexString(this.hashCode()));
        return s.toString();
    }

    public long totalElements() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements;
    }

    public long totalPages() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements / (long)this.pageRequest.size() + (long)(this.totalElements % (long)this.pageRequest.size() > 0L ? 1 : 0);
    }

    public boolean hasContent() {
        return !this.results.isEmpty();
    }

    public Iterator<T> iterator() {
        int max;
        int size = this.results.size();
        return size > (max = this.pageRequest.size()) ? new ResultIterator(max) : this.results.iterator();
    }

    public PageRequest nextPageRequest() {
        if (!this.hasNext()) {
            throw DataExtension.exc(NoSuchElementException.class, "CWWKD1040.no.next.page", this.queryInfo.method.getName(), this.queryInfo.repositoryInterface.getName(), "CursoredPage.hasNext");
        }
        int maxPageSize = this.pageRequest.size();
        int endingResultIndex = Math.min(maxPageSize, this.results.size()) - 1;
        return PageRequest.afterCursor((PageRequest.Cursor)PageRequest.Cursor.forKey((Object[])this.queryInfo.getCursorValues(this.results.get(endingResultIndex))), (long)(this.pageRequest.page() == Long.MAX_VALUE ? Long.MAX_VALUE : this.pageRequest.page() + 1L), (int)maxPageSize, (boolean)this.pageRequest.requestTotal());
    }

    public PageRequest previousPageRequest() {
        if (!this.hasPrevious()) {
            throw DataExtension.exc(NoSuchElementException.class, "CWWKD1039.no.prev.cursor.page", this.queryInfo.method.getName(), this.queryInfo.repositoryInterface.getName());
        }
        return PageRequest.beforeCursor((PageRequest.Cursor)PageRequest.Cursor.forKey((Object[])this.queryInfo.getCursorValues(this.results.get(0))), (long)(this.pageRequest.page() == 1L ? 1L : this.pageRequest.page() - 1L), (int)this.pageRequest.size(), (boolean)this.pageRequest.requestTotal());
    }

    public Stream<T> stream() {
        return this.content().stream();
    }

    @Trivial
    private class ResultList
    extends AbstractList<T>
    implements RandomAccess {
        private final int size;

        private ResultList(int size) {
            this.size = size;
        }

        @Override
        public T get(int index) {
            if (index < this.size) {
                return CursoredPageImpl.this.results.get(index);
            }
            throw new IndexOutOfBoundsException(index);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    @Trivial
    private class ResultIterator
    implements Iterator<T> {
        private int index;
        private final Iterator<T> iterator;
        private final int size;

        private ResultIterator(int size) {
            this.size = size;
            this.iterator = CursoredPageImpl.this.results.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size && this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.index >= this.size) {
                throw new NoSuchElementException("Element at index " + this.index);
            }
            Object result = this.iterator.next();
            ++this.index;
            return result;
        }
    }
}

