/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.io.StringReader;
import java.util.regex.Pattern;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.ContentLocationField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.field.structured.parser.ParseException;
import org.apache.james.mime4j.field.structured.parser.StructuredFieldParser;
import org.apache.james.mime4j.stream.Field;

public class ContentLocationFieldImpl
extends AbstractField
implements ContentLocationField {
    private static final Pattern PATTERN = Pattern.compile("\\s");
    private boolean parsed = false;
    private String location;
    private ParseException parseException;
    public static final FieldParser<ContentLocationField> PARSER = new FieldParser<ContentLocationField>(){

        @Override
        public ContentLocationField parse(Field rawField, DecodeMonitor monitor) {
            return new ContentLocationFieldImpl(rawField, monitor);
        }
    };

    ContentLocationFieldImpl(Field rawField, DecodeMonitor monitor) {
        super(rawField, monitor);
    }

    private void parse() {
        this.parsed = true;
        String body = this.getBody();
        this.location = null;
        if (body != null) {
            StringReader stringReader = new StringReader(body);
            StructuredFieldParser parser = new StructuredFieldParser(stringReader);
            try {
                this.location = PATTERN.matcher(parser.parse()).replaceAll("");
            }
            catch (ParseException ex) {
                this.parseException = ex;
            }
        }
    }

    @Override
    public String getLocation() {
        if (!this.parsed) {
            this.parse();
        }
        return this.location;
    }

    @Override
    public org.apache.james.mime4j.dom.field.ParseException getParseException() {
        return this.parseException;
    }
}

