/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.message;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.HttpServiceContextImpl;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.http.netty.message.NettyBaseMessage;
import com.ibm.ws.http.netty.message.NettyTrailers;
import com.ibm.ws.http.netty.pipeline.inbound.HttpDispatcherHandler;
import com.ibm.ws.http2.GrpcServletServices;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.exception.UnsupportedMethodException;
import com.ibm.wsspi.genericbnf.exception.UnsupportedSchemeException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpTrailers;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.MethodValues;
import com.ibm.wsspi.http.channel.values.SchemeValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import com.ibm.wsspi.http.ee8.Http2PushBuilder;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.VoidChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NettyRequestMessage
extends NettyBaseMessage
implements HttpRequestMessage {
    private static final TraceComponent tc = Tr.register(NettyRequestMessage.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private FullHttpRequest request;
    private HttpHeaders headers;
    private HttpInboundServiceContext context;
    private String url;
    private Boolean isGrpc = null;
    private MethodValues method;
    private SchemeValues scheme;
    private QueryStringDecoder query;
    private Map<String, String[]> parameters;
    private ChannelHandlerContext nettyContext;
    private static final int NOT_PRESENT = -1;
    private static final int NOT_TESTED = -2;
    private transient int iUrlPort = -1;
    private transient int iHdrPort = -2;
    private static final byte[] SLASH = new byte[]{47};
    private static final byte LEFT_BRACKET = 91;
    private static final byte RIGHT_BRACKET = 93;
    private byte[] myURIBytes = SLASH;
    private transient String myURIString = null;
    private transient String sUrlHost = null;
    private transient String sHdrHost = null;
    static final long serialVersionUID = -6825499753414250860L;

    public NettyRequestMessage(FullHttpRequest request, HttpInboundServiceContext isc, ChannelHandlerContext nettyContext) {
        this.init(request, isc, nettyContext);
    }

    public void init(FullHttpRequest request, HttpInboundServiceContext isc, ChannelHandlerContext nettyContext) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(isc);
        this.context = isc;
        if (isc instanceof HttpInboundServiceContextImpl) {
            this.incoming(((HttpInboundServiceContextImpl)isc).isInboundConnection());
        }
        this.request = request;
        this.headers = request.headers();
        this.nettyContext = nettyContext;
        this.parameters = new HashMap<String, String[]>();
        this.scheme = isc.isSecure() ? SchemeValues.HTTPS : SchemeValues.HTTP;
        this.processQuery();
        HttpChannelConfig config = isc instanceof HttpInboundServiceContextImpl ? ((HttpInboundServiceContextImpl)isc).getHttpConfig() : null;
        super.init((HttpMessage)request, isc, config);
        this.setAndGetIsGrpc();
        this.setMessageType(NettyBaseMessage.MessageType.REQUEST);
    }

    public void verifyRequest() {
        if (!this.getMethod().equalsIgnoreCase(HttpMethod.CONNECT.toString())) {
            String host = this.request.uri();
            if (null == host || host.isEmpty()) {
                throw new IllegalArgumentException("setRequestURL: null URL");
            }
            int start = 0;
            if (NettyRequestMessage.isAlpha(host.charAt(0))) {
                int colonIndex = host.indexOf(58);
                if (colonIndex == -1 || SchemeValues.match(host, 0, colonIndex) == null) {
                    throw new IllegalArgumentException("Invalid scheme in URL: " + host);
                }
                if (colonIndex + 2 >= host.length() || '/' != host.charAt(colonIndex + 1) || '/' != host.charAt(colonIndex + 2)) {
                    throw new IllegalArgumentException("Invalid net_path: " + host);
                }
                start = colonIndex + 3;
            } else if (host.length() > 1 && '/' == host.charAt(0) && '/' == host.charAt(1) && this.getServiceContext().getHttpConfig().isStrictURLFormat()) {
                start = 2;
            } else {
                this.parseURI(host.getBytes(), 0);
                return;
            }
            if (start >= host.length()) {
                throw new IllegalArgumentException("Invalid authority: " + host);
            }
            int host_start = start;
            int slash_start = host.length();
            for (int i = start; i < host.length(); ++i) {
                if ('@' == host.charAt(i)) {
                    host_start = i + 1;
                    continue;
                }
                if ('/' != host.charAt(i)) continue;
                slash_start = i;
                break;
            }
            this.parseURLHost(host, start, slash_start);
            this.parseURI(host.getBytes(), slash_start);
        }
    }

    private void parseURI(byte[] data, int start) {
        if (start >= data.length) {
            this.myURIBytes = SLASH;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Defaulting to slash since no URI data found", (Object[])new Object[0]);
            }
            return;
        }
        int uri_end = data.length;
        for (int i = start; i < data.length; ++i) {
            if (63 != data[i]) continue;
            uri_end = i;
            break;
        }
        if (start == uri_end) {
            throw new IllegalArgumentException("Missing URI: " + GenericUtils.getEnglishString(data));
        }
        if (0 == start && uri_end == data.length) {
            this.myURIBytes = data;
        } else {
            this.myURIBytes = new byte[uri_end - start];
            System.arraycopy(data, start, this.myURIBytes, 0, this.myURIBytes.length);
        }
    }

    @ManualTrace
    public boolean setAndGetIsGrpc() {
        if (this.isGrpc == null) {
            Map<String, GrpcServletServices.ServiceInformation> servicePaths;
            this.isGrpc = GrpcServletServices.getServletGrpcServices() != null ? ((servicePaths = GrpcServletServices.getServletGrpcServices()) != null && !servicePaths.isEmpty() ? Boolean.valueOf(this.routeGrpcServletRequest(servicePaths)) : Boolean.valueOf(false)) : Boolean.valueOf(false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String currentURL = this.request.uri();
            Tr.exit((TraceComponent)tc, (String)("setAndGetIsGrpc returning " + this.isGrpc + " for request path " + currentURL));
        }
        return this.isGrpc;
    }

    private boolean routeGrpcServletRequest(Map<String, GrpcServletServices.ServiceInformation> servicePaths) {
        String requestContentType;
        String string = requestContentType = Objects.isNull(HttpUtil.getMimeType((HttpMessage)this.request)) ? null : HttpUtil.getMimeType((HttpMessage)this.request).toString();
        if (requestContentType != null && servicePaths != null && "application/grpc".equalsIgnoreCase(requestContentType = requestContentType.toLowerCase())) {
            String currentURL;
            String searchURL = currentURL = this.request.uri();
            searchURL = searchURL.substring(1);
            int index = searchURL.lastIndexOf(47);
            GrpcServletServices.ServiceInformation info = servicePaths.get(searchURL = searchURL.substring(0, index));
            if (info != null) {
                String contextRoot = info.getContextRoot();
                if (contextRoot != null && !"/".equals(contextRoot)) {
                    String newPath = contextRoot + currentURL;
                    this.request.setUri(newPath);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Inbound gRPC request translated from " + currentURL + " to " + newPath), (Object[])new Object[0]);
                    }
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Inbound gRPC request URL did not match any registered services: " + currentURL), (Object[])new Object[0]);
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.request = null;
        this.headers = null;
        this.context = null;
        this.url = null;
        this.method = null;
        this.scheme = null;
        this.query = null;
        this.parameters.clear();
        super.clear();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public boolean isBodyExpected() {
        if (super.isBodyExpected()) {
            return !this.request.method().equals((Object)HttpMethod.TRACE);
        }
        return false;
    }

    @Override
    public VersionValues getVersionValue() {
        return VersionValues.find(this.request.protocolVersion().text());
    }

    @Override
    public String getMethod() {
        if (Objects.isNull(this.method)) {
            this.method = MethodValues.find(this.request.method().name());
        }
        return this.method.getName();
    }

    @Override
    public MethodValues getMethodValue() {
        if (Objects.isNull(this.method)) {
            this.method = MethodValues.find(this.request.method().name());
        }
        return this.method;
    }

    @Override
    public void setMethod(String method) throws UnsupportedMethodException {
        this.method = MethodValues.find(method);
        this.request.setMethod(HttpMethod.valueOf((String)method));
    }

    @Override
    public void setMethod(byte[] method) throws UnsupportedMethodException {
        this.setMethod(new String(method, StandardCharsets.UTF_8));
    }

    @Override
    public void setMethod(MethodValues method) {
        this.method = method;
        this.request.setMethod(HttpMethod.valueOf((String)method.getName()));
    }

    @Override
    public String getRequestURI() {
        if (this.getMethod().equalsIgnoreCase(HttpMethod.CONNECT.toString())) {
            return GenericUtils.getEnglishString(SLASH);
        }
        if (null == this.myURIString) {
            this.myURIString = GenericUtils.getEnglishString(this.myURIBytes);
        }
        return this.myURIString;
    }

    @Override
    public byte[] getRequestURIAsByteArray() {
        return GenericUtils.getBytes(this.getRequestURI());
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer(this.getScheme() + "://");
        sb.append(this.getTargetHost());
        sb.append(':');
        sb.append(this.getTargetPort());
        sb.append(this.getRequestURI());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRequestURL() returning [" + sb.toString() + "]"), (Object[])new Object[0]);
        }
        return sb;
    }

    @Override
    public String getRequestURLAsString() {
        if (Objects.isNull(this.url)) {
            this.url = this.getRequestURL().toString();
        }
        return this.url;
    }

    @Override
    public byte[] getRequestURLAsByteArray() {
        return GenericUtils.getBytes(this.getRequestURLAsString());
    }

    @Override
    public String getQueryString() {
        return Objects.isNull(this.parameters) || this.parameters.isEmpty() ? null : this.query.rawQuery();
    }

    @Override
    public byte[] getQueryStringAsByteArray() {
        return Objects.isNull(this.parameters) || this.parameters.isEmpty() ? null : GenericUtils.getBytes(this.getQueryString());
    }

    @Override
    public String getParameter(String name) {
        return this.parameters.containsKey(name) ? this.parameters.get(name)[0] : null;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.parameters.containsKey(name) ? this.parameters.get(name) : null;
    }

    @Override
    public void setRequestURL(String url) {
        this.setRequestURL(GenericUtils.getEnglishBytes(url));
    }

    @Override
    public void setRequestURL(byte[] url) {
        this.setRequestURL(new String(url, StandardCharsets.UTF_8));
    }

    @Override
    public void setRequestURI(String uri) {
        this.setRequestURI(GenericUtils.getEnglishBytes(uri));
    }

    @Override
    public void setRequestURI(byte[] uri) {
        if (null == uri || 0 == uri.length) {
            throw new IllegalArgumentException("setRequestURI: null input");
        }
        if (42 == uri[0]) {
            if (1 != uri.length && 63 != uri[1]) {
                String value = GenericUtils.getEnglishString(uri);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setRequestURI: invalid uri [" + value + "]"), (Object[])new Object[0]);
                }
                throw new IllegalArgumentException("Invalid uri: " + value);
            }
        } else if (47 != uri[0]) {
            String value = GenericUtils.getEnglishString(uri);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setRequestURI: invalid uri [" + value + "]"), (Object[])new Object[0]);
            }
            throw new IllegalArgumentException("Invalid uri: " + value);
        }
        this.parseURI(uri, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setRequestURI: finished parsing " + this.getRequestURI()), (Object[])new Object[0]);
        }
    }

    private void parseURLHost(String url, int start, int end) {
        int length = end - start;
        if (0 >= length) {
            throw new IllegalArgumentException("Missing host/port");
        }
        int name_start = start;
        int name_end = end;
        int port_start = -1;
        int port_end = -1;
        if ('[' != url.charAt(name_start)) {
            int colon_index = url.indexOf(58, name_start);
            if (-1 != colon_index && colon_index <= end) {
                name_end = colon_index;
                port_start = colon_index + 1;
                port_end = end;
            }
        } else {
            int index;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"IPV6 host in the URL", (Object[])new Object[0]);
            }
            if (-1 != (index = url.indexOf(93, name_start)) && index <= end) {
                name_end = ++index;
                if (index < end && ':' == url.charAt(index)) {
                    port_start = index + 1;
                    port_end = end;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"No end to the IPV6 IP", (Object[])new Object[0]);
                }
                throw new IllegalArgumentException("Invalid IPV6 IP");
            }
        }
        length = name_end - name_start;
        if (0 >= length) {
            throw new IllegalArgumentException("Hostname not present");
        }
        this.sUrlHost = url.substring(name_start, name_end);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Found URL host: " + this.sUrlHost), (Object[])new Object[0]);
        }
        if (-1 != port_start && port_end > port_start) {
            length = port_end - port_start;
            this.iUrlPort = GenericUtils.asIntValue(url.getBytes(), port_start, length);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Defaulting URL port to match scheme: " + this.getScheme()), (Object[])new Object[0]);
            }
            this.iUrlPort = SchemeValues.HTTPS.equals(this.getSchemeValue()) ? 443 : 80;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Found URL port of " + this.iUrlPort), (Object[])new Object[0]);
        }
    }

    @Override
    public String getURLHost() {
        return this.context.getLocalAddr().getHostName();
    }

    @Override
    public int getURLPort() {
        return this.context.getLocalPort();
    }

    @Override
    public String getVirtualHost() {
        if (Objects.nonNull(this.sUrlHost)) {
            return this.sUrlHost;
        }
        String host = this.headers.get(HttpHeaderKeys.HDR_HOST.getName());
        if (Objects.isNull(host) || host.length() <= 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getVirtualHost: No host header: [" + host + "]"), (Object[])new Object[0]);
            }
            return null;
        }
        int index = -1;
        if ('[' == host.charAt(0)) {
            index = host.indexOf(93);
            if (-1 == index) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getVirtualHost: Invalid IPv6 IP, missing right bracket", (Object[])new Object[0]);
                }
                return null;
            }
            ++index;
        } else {
            index = host.indexOf(58);
        }
        if (-1 != index) {
            host = host.substring(0, index);
        }
        this.sHdrHost = host;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getVirtualHost: " + host), (Object[])new Object[0]);
        }
        return Objects.isNull(host) ? this.getURLHost() : host;
    }

    private static boolean isAlpha(char b) {
        if ('a' <= b && 'z' >= b) {
            return true;
        }
        return 'A' <= b && 'Z' >= b;
    }

    @Override
    public int getVirtualPort() {
        if (-1 != this.iUrlPort) {
            return this.iUrlPort;
        }
        if (-1 <= this.iHdrPort) {
            return this.iHdrPort;
        }
        String host = this.headers.get(HttpHeaderKeys.HDR_HOST.getName());
        if (Objects.isNull(host) || host.length() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getVirtualPort: No/empty host header", (Object[])new Object[0]);
            }
            return -1;
        }
        this.iHdrPort = -1;
        int start = -1;
        int end = host.length();
        if ('[' == host.charAt(0)) {
            start = host.indexOf(93);
            if (-1 == start) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getVirtualPort: Invalid IPV6 ip in host header", (Object[])new Object[0]);
                }
                return -1;
            }
            ++start;
        } else {
            start = host.indexOf(58);
        }
        if (-1 == start || host.length() <= start || ':' != host.charAt(start)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getVirtualPort: No port in host header", (Object[])new Object[0]);
            }
            return -1;
        }
        if (0 >= end - ++start) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getVirtualPort: No port after colon", (Object[])new Object[0]);
            }
            return -1;
        }
        try {
            this.iHdrPort = Integer.parseInt(host.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.http.netty.message.NettyRequestMessage", (String)"723", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getVirtualPort: Invalid port value: " + host), (Object[])new Object[0]);
            }
            return -1;
        }
        return this.iHdrPort;
    }

    @Override
    public void setQueryString(String query) {
        throw new UnsupportedOperationException("Set query delegated to http codec");
    }

    @Override
    public void setQueryString(byte[] query) {
        this.setQueryString(GenericUtils.getEnglishString(query));
    }

    @Override
    public SchemeValues getSchemeValue() {
        return this.scheme;
    }

    @Override
    public String getScheme() {
        return Objects.isNull(this.scheme) ? null : this.scheme.getName();
    }

    @Override
    public void setScheme(SchemeValues scheme) {
        this.scheme = scheme;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setScheme(v): " + scheme.getName()), (Object[])new Object[0]);
        }
    }

    @Override
    public void setScheme(String scheme) throws UnsupportedSchemeException {
        SchemeValues value = SchemeValues.match(scheme, 0, scheme.length());
        if (Objects.isNull(value)) {
            throw new UnsupportedSchemeException("Illegal scheme " + scheme);
        }
        this.setScheme(value);
    }

    @Override
    public void setScheme(byte[] scheme) throws UnsupportedSchemeException {
        Objects.requireNonNull(scheme);
        SchemeValues value = SchemeValues.match(scheme, 0, scheme.length);
        if (Objects.isNull(value)) {
            throw new UnsupportedSchemeException("Illegal scheme " + GenericUtils.getEnglishString(scheme));
        }
        this.setScheme(value);
    }

    @Override
    public HttpTrailers getTrailers() {
        return new NettyTrailers(this.request.trailingHeaders());
    }

    @Override
    public HttpRequestMessage duplicate() {
        throw new UnsupportedOperationException("The duplicate method is not supported.");
    }

    @Override
    public boolean isPushSupported() {
        HttpToHttp2ConnectionHandler handler = (HttpToHttp2ConnectionHandler)this.nettyContext.channel().pipeline().get(HttpToHttp2ConnectionHandler.class);
        if (Objects.isNull(handler)) {
            return false;
        }
        boolean canPush = handler.connection().remote().allowPushTo();
        return canPush;
    }

    @Override
    @ManualTrace
    public void pushNewRequest(Http2PushBuilder pushBuilder) {
        Set<HeaderField> pushBuilderHeaders;
        String pbPath = null;
        pbPath = pushBuilder.getPathQueryString() != null ? pushBuilder.getURI() + pushBuilder.getPathQueryString() : pushBuilder.getURI();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pushNewRequest() pbPath = " + pbPath), (Object[])new Object[0]);
        }
        final HttpToHttp2ConnectionHandler handler = (HttpToHttp2ConnectionHandler)this.nettyContext.channel().pipeline().get(HttpToHttp2ConnectionHandler.class);
        Http2Connection connection = handler.connection();
        final int nextPromisedStreamId = connection.local().incrementAndGetNextStreamId();
        final int currentStreamId = this.request.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), 0);
        final Http2Headers headers = new DefaultHttp2Headers().clear();
        String scheme = "https";
        if (!this.context.isSecure()) {
            scheme = "http";
        }
        headers.method((CharSequence)pushBuilder.getMethod()).scheme((CharSequence)scheme).path((CharSequence)pbPath);
        String auth = this.getTargetHost();
        if (null != auth) {
            if (0 <= this.getTargetPort()) {
                auth = auth + ":" + Integer.toString(this.getTargetPort());
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"pushNewRequest(): Cannot find hostname for required :authority pseudo header");
            }
            return;
        }
        headers.authority((CharSequence)auth);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pushNewRequest(): Method is GET, authority is " + auth + ", scheme is " + scheme), (Object[])new Object[0]);
        }
        if ((pushBuilderHeaders = pushBuilder.getHeaders()) != null) {
            Iterator<HeaderField> iterator = pushBuilderHeaders.iterator();
            HeaderField hf = null;
            while (iterator.hasNext()) {
                hf = iterator.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("pushNewRequest() PushBuilder header: " + hf.getName() + " " + hf.asString()), (Object[])new Object[0]);
                }
                headers.add((Object)hf.getName().toLowerCase(), (Object)hf.asString());
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"pushNewRequest() no PushBuilder headers", (Object[])new Object[0]);
        }
        this.nettyContext.channel().eventLoop().execute(new Runnable(){
            static final long serialVersionUID = 8391732808311419013L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                ChannelFuture promise = handler.encoder().writePushPromise(NettyRequestMessage.this.nettyContext, currentStreamId, nextPromisedStreamId, headers, 0, (ChannelPromise)new VoidChannelPromise(NettyRequestMessage.this.nettyContext.channel(), true));
                promise.addListener(future -> {
                    if (future.isSuccess()) {
                        // empty if block
                    }
                });
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.message.NettyRequestMessage$1", 1.class, null, null);
            }
        });
        final DefaultFullHttpRequest newRequest = new DefaultFullHttpRequest(this.request.protocolVersion(), HttpMethod.GET, pbPath);
        newRequest.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)nextPromisedStreamId);
        newRequest.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)scheme);
        HttpUtil.setContentLength((HttpMessage)newRequest, (long)0L);
        HttpDispatcher.getExecutorService().execute(new Runnable(){
            static final long serialVersionUID = -1603686654883752828L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                block2: {
                    try {
                        ((HttpDispatcherHandler)NettyRequestMessage.this.nettyContext.channel().pipeline().get("HTTP_DISPATCHER")).channelRead(NettyRequestMessage.this.nettyContext, newRequest);
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.http.netty.message.NettyRequestMessage$2", (String)"906", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                        Tr.debug((TraceComponent)tc, (String)("pushNewRequest() Unable to dispatch push request: " + e.getMessage()), (Object[])new Object[]{e});
                    }
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.message.NettyRequestMessage$2", 2.class, null, null);
            }
        });
    }

    private String getTargetHost() {
        String host = this.getVirtualHost();
        if (null == host) {
            InetSocketAddress local = (InetSocketAddress)this.nettyContext.channel().localAddress();
            InetSocketAddress remote = (InetSocketAddress)this.nettyContext.channel().remoteAddress();
            host = this.isIncoming() ? local.getAddress().getCanonicalHostName() : remote.getAddress().getCanonicalHostName();
        }
        return host;
    }

    private int getTargetPort() {
        int port = this.getVirtualPort();
        if (-1 == port) {
            InetSocketAddress local = (InetSocketAddress)this.nettyContext.channel().localAddress();
            InetSocketAddress remote = (InetSocketAddress)this.nettyContext.channel().remoteAddress();
            port = this.isIncoming() ? local.getPort() : remote.getPort();
        }
        return port;
    }

    @Override
    public long getStartTime() {
        if (this.nettyContext.channel().hasAttr(NettyHttpConstants.REQUEST_START_TIME)) {
            return (Long)this.nettyContext.channel().attr(NettyHttpConstants.REQUEST_START_TIME).get();
        }
        return 0L;
    }

    @Override
    public String getRemoteUser() {
        String remoteUser = null;
        if (this.context instanceof HttpInboundServiceContextImpl) {
            remoteUser = ((HttpInboundServiceContextImpl)this.context).getRemoteUser();
        }
        return Objects.nonNull(remoteUser) ? remoteUser : "";
    }

    @Override
    public HttpServiceContextImpl getServiceContext() {
        return this.context instanceof HttpServiceContextImpl ? (HttpServiceContextImpl)((Object)this.context) : null;
    }

    @Override
    public long getEndTime() {
        return System.nanoTime();
    }

    private void processQuery() {
        if (Objects.isNull(this.query)) {
            this.query = new QueryStringDecoder(this.request.uri());
            for (Map.Entry entry : this.query.parameters().entrySet()) {
                List value = (List)entry.getValue();
                this.parameters.put((String)entry.getKey(), value.toArray(new String[value.size()]));
            }
        }
    }
}

