/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.monitor;

import com.ibm.websphere.monitor.meters.Counter;
import com.ibm.websphere.monitor.meters.Meter;
import com.ibm.websphere.monitor.meters.StatisticsMeter;
import com.ibm.ws.webcontainer.monitor.ServletStatsMXBean;

public class ServletStats
extends Meter
implements ServletStatsMXBean {
    private String appName;
    private String servletName;
    private Counter requestCount;
    private final StatisticsMeter responseTime;

    public ServletStats(String aName, String sName) {
        this.setAppName(aName);
        this.setServletName(sName);
        this.requestCount = new Counter();
        this.requestCount.setDescription("This shows number of requests to a servlet");
        this.requestCount.setUnit("ns");
        this.responseTime = new StatisticsMeter();
        this.responseTime.setDescription("Average Response Time for servlet");
        this.responseTime.setUnit("ns");
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public String getDescription() {
        return "Report Servlet Stats for specified Servlet and application.";
    }

    @Override
    public long getRequestCount() {
        return this.requestCount.getCurrentValue();
    }

    @Override
    public double getResponseTime() {
        return this.responseTime.getMean();
    }

    @Override
    public String getServletName() {
        return this.servletName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public void setRequestCount(Counter requestCount) {
        this.requestCount = requestCount;
    }

    public void incrementCountBy(int i) {
        this.requestCount.incrementBy((long)i);
    }

    public void updateRT(long elapsed) {
        this.responseTime.addDataPoint(elapsed);
    }

    @Override
    public Counter getRequestCountDetails() {
        return this.requestCount;
    }

    @Override
    public StatisticsMeter getResponseTimeDetails() {
        return this.responseTime;
    }
}

