/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import org.apache.yoko.orb.OB.ConnectTimeoutPolicy;
import org.apache.yoko.orb.OB.InterceptorPolicy;
import org.apache.yoko.orb.OB.LocateRequestPolicy;
import org.apache.yoko.orb.OB.LocationTransparencyPolicy;
import org.apache.yoko.orb.OB.ReplyTimeoutPolicy;
import org.apache.yoko.orb.OB.RequestTimeoutPolicy;
import org.apache.yoko.orb.OB.RetryAttributes;
import org.apache.yoko.orb.OB.RetryPolicy;
import org.apache.yoko.orb.OB.TimeHelper;
import org.apache.yoko.orb.OB.TimeoutPolicy;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.CORBA.Policy;
import org.omg.Messaging.MaxHopsPolicy;
import org.omg.Messaging.PriorityRange;
import org.omg.Messaging.QueueOrderPolicy;
import org.omg.Messaging.RebindPolicy;
import org.omg.Messaging.RelativeRequestTimeoutPolicy;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.Messaging.ReplyEndTimePolicy;
import org.omg.Messaging.ReplyPriorityPolicy;
import org.omg.Messaging.ReplyStartTimePolicy;
import org.omg.Messaging.RequestEndTimePolicy;
import org.omg.Messaging.RequestPriorityPolicy;
import org.omg.Messaging.RequestStartTimePolicy;
import org.omg.Messaging.RoutingPolicy;
import org.omg.Messaging.RoutingTypeRange;
import org.omg.Messaging.SyncScopePolicy;
import org.omg.TimeBase.UtcT;

public final class RefCountPolicyList {
    public Policy[] value;
    public RetryAttributes retry;
    public int connectTimeout;
    public int requestTimeout;
    public int replyTimeout;
    public UtcT requestStartTime;
    public UtcT requestEndTime;
    public UtcT replyStartTime;
    public UtcT replyEndTime;
    public long relativeRequestTimeout;
    public long relativeRoundTripTimeout;
    public short rebindMode;
    public short syncScope;
    public short locationTransparency;
    public short biDirMode;
    public boolean interceptor;
    public boolean locateRequest;
    public PriorityRange requestPriority;
    public PriorityRange replyPriority;
    public RoutingTypeRange routingRange;
    public short maxHops;
    public short queueOrder;

    private static RetryAttributes getRetry(Policy[] policies) {
        RetryAttributes attributes = new RetryAttributes();
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 0x4F4F0004) continue;
            RetryPolicy policy = (RetryPolicy)policies[i];
            attributes.mode = policy.retry_mode();
            attributes.interval = policy.retry_interval();
            attributes.max = policy.retry_max();
            attributes.remote = policy.retry_remote();
            return attributes;
        }
        attributes.mode = 1;
        attributes.interval = 0;
        attributes.max = 1;
        attributes.remote = false;
        return attributes;
    }

    private static int getConnectTimeout(Policy[] policies) {
        int i;
        for (i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 1330577416) continue;
            ConnectTimeoutPolicy policy = (ConnectTimeoutPolicy)policies[i];
            return policy.value();
        }
        for (i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 1330577413) continue;
            TimeoutPolicy policy = (TimeoutPolicy)policies[i];
            return policy.value();
        }
        return -1;
    }

    private static int getRequestTimeout(Policy[] policies) {
        int i;
        for (i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 1330577417) continue;
            RequestTimeoutPolicy policy = (RequestTimeoutPolicy)policies[i];
            return policy.value();
        }
        for (i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 1330577413) continue;
            TimeoutPolicy policy = (TimeoutPolicy)policies[i];
            return policy.value();
        }
        return -1;
    }

    private static int getReplyTimeout(Policy[] policies) {
        int i;
        for (i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 1330577420) continue;
            ReplyTimeoutPolicy policy = (ReplyTimeoutPolicy)policies[i];
            return policy.value();
        }
        for (i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 1330577413) continue;
            TimeoutPolicy policy = (TimeoutPolicy)policies[i];
            return policy.value();
        }
        return -1;
    }

    private UtcT getRequestStartTime(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 27) continue;
            RequestStartTimePolicy policy = (RequestStartTimePolicy)policies[i];
            return policy.start_time();
        }
        return TimeHelper.utcMin();
    }

    private UtcT getRequestEndTime(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 28) continue;
            RequestEndTimePolicy policy = (RequestEndTimePolicy)policies[i];
            return policy.end_time();
        }
        return TimeHelper.utcMin();
    }

    private UtcT getReplyStartTime(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 29) continue;
            ReplyStartTimePolicy policy = (ReplyStartTimePolicy)policies[i];
            return policy.start_time();
        }
        return TimeHelper.utcMin();
    }

    private UtcT getReplyEndTime(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 30) continue;
            ReplyEndTimePolicy policy = (ReplyEndTimePolicy)policies[i];
            return policy.end_time();
        }
        return TimeHelper.utcMin();
    }

    private long getRelativeRequestTimeout(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 31) continue;
            RelativeRequestTimeoutPolicy policy = (RelativeRequestTimeoutPolicy)policies[i];
            return policy.relative_expiry();
        }
        return 0L;
    }

    private long getRelativeRoundTripTimeout(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 32) continue;
            RelativeRoundtripTimeoutPolicy policy = (RelativeRoundtripTimeoutPolicy)policies[i];
            return policy.relative_expiry();
        }
        return 0L;
    }

    private static short getRebindMode(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 23) continue;
            RebindPolicy policy = (RebindPolicy)policies[i];
            return policy.rebind_mode();
        }
        return 0;
    }

    private static short getSyncScope(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 24) continue;
            SyncScopePolicy policy = (SyncScopePolicy)policies[i];
            return policy.synchronization();
        }
        return 0;
    }

    private static short getLocationTransparency(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 1330577414) continue;
            LocationTransparencyPolicy policy = (LocationTransparencyPolicy)policies[i];
            return policy.value();
        }
        return 1;
    }

    private static short getBiDirMode(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 37) continue;
            BidirectionalPolicy policy = (BidirectionalPolicy)policies[i];
            return policy.value();
        }
        return 0;
    }

    private static boolean getInterceptor(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 1330577415) continue;
            InterceptorPolicy policy = (InterceptorPolicy)policies[i];
            return policy.value();
        }
        return true;
    }

    private static boolean getLocateRequest(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 1330577418) continue;
            LocateRequestPolicy policy = (LocateRequestPolicy)policies[i];
            return policy.value();
        }
        return false;
    }

    public static PriorityRange getRequestPriority(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 25) continue;
            RequestPriorityPolicy policy = (RequestPriorityPolicy)policies[i];
            return policy.priority_range();
        }
        PriorityRange range = new PriorityRange();
        range.min = 0;
        range.max = 0;
        return range;
    }

    public static PriorityRange getReplyPriority(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 26) continue;
            ReplyPriorityPolicy policy = (ReplyPriorityPolicy)policies[i];
            return policy.priority_range();
        }
        PriorityRange range = new PriorityRange();
        range.min = 0;
        range.max = 0;
        return range;
    }

    public static RoutingTypeRange getRoutingRange(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 33) continue;
            RoutingPolicy policy = (RoutingPolicy)policies[i];
            return policy.routing_range();
        }
        RoutingTypeRange range = new RoutingTypeRange();
        range.min = 0;
        range.max = 0;
        return range;
    }

    public static short getMaxHops(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 34) continue;
            MaxHopsPolicy policy = (MaxHopsPolicy)policies[i];
            return policy.max_hops();
        }
        return Short.MAX_VALUE;
    }

    public static short getQueueOrder(Policy[] policies) {
        for (int i = 0; i < policies.length; ++i) {
            if (policies[i].policy_type() != 35) continue;
            QueueOrderPolicy policy = (QueueOrderPolicy)policies[i];
            return policy.allowed_orders();
        }
        return 2;
    }

    public RefCountPolicyList(Policy[] v) {
        this.value = v;
        this.retry = RefCountPolicyList.getRetry(v);
        this.connectTimeout = RefCountPolicyList.getConnectTimeout(v);
        this.requestTimeout = RefCountPolicyList.getRequestTimeout(v);
        this.requestStartTime = this.getRequestStartTime(v);
        this.requestEndTime = this.getRequestEndTime(v);
        this.replyTimeout = RefCountPolicyList.getReplyTimeout(v);
        this.replyStartTime = this.getReplyStartTime(v);
        this.replyEndTime = this.getReplyEndTime(v);
        this.relativeRequestTimeout = this.getRelativeRequestTimeout(v);
        this.relativeRoundTripTimeout = this.getRelativeRoundTripTimeout(v);
        this.rebindMode = RefCountPolicyList.getRebindMode(v);
        this.syncScope = RefCountPolicyList.getSyncScope(v);
        this.locationTransparency = RefCountPolicyList.getLocationTransparency(v);
        this.biDirMode = RefCountPolicyList.getBiDirMode(v);
        this.interceptor = RefCountPolicyList.getInterceptor(v);
        this.locateRequest = RefCountPolicyList.getLocateRequest(v);
        this.requestPriority = RefCountPolicyList.getRequestPriority(v);
        this.replyPriority = RefCountPolicyList.getReplyPriority(v);
        this.routingRange = RefCountPolicyList.getRoutingRange(v);
        this.maxHops = RefCountPolicyList.getMaxHops(v);
        this.queueOrder = RefCountPolicyList.getQueueOrder(v);
    }
}

