/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.html.HtmlCommandScript;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchExpressionHandler;
import jakarta.faces.context.FacesContext;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import org.apache.myfaces.component.search.MyFacesSearchExpressionHints;
import org.apache.myfaces.shared.renderkit.html.util.SharedStringBuilder;
import org.apache.myfaces.shared.util.StringUtils;

public class AjaxScriptBuilder {
    private static final String AJAX_PARAM_SB = "oam.renderkit.AJAX_PARAM_SB";
    private static final String QUOTE = "'";
    private static final String BLANK = " ";
    private static final String AJAX_KEY_ONERROR = "onerror";
    private static final String AJAX_KEY_ONEVENT = "onevent";
    private static final String AJAX_KEY_EXECUTE = "execute";
    private static final String AJAX_KEY_RENDER = "render";
    private static final String AJAX_KEY_DELAY = "delay";
    private static final String AJAX_KEY_RESETVALUES = "resetValues";
    private static final String AJAX_VAL_THIS = "this";
    private static final String AJAX_VAL_EVENT = "event";
    private static final String JS_AJAX_REQUEST = "jsf.ajax.request";
    private static final String COLON = ":";
    private static final String EMPTY = "";
    private static final String COMMA = ",";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private static final String L_C_BRACE = "{";
    private static final String R_C_BRACE = "}";
    public static final String AJAX_KEY_PARAMS = "params";
    public static final String AJAX_VAL_NULL = "null";

    public static void build(FacesContext context, StringBuilder sb, UIComponent component, String sourceId, String eventName, String execute, String render, Boolean resetValues, String onerror, String onevent, List<UIParameter> uiParams) {
        AjaxScriptBuilder.build(context, sb, component, sourceId, eventName, execute, render, null, Boolean.TRUE.equals(resetValues) ? Boolean.TRUE.toString() : null, onerror, onevent, null, uiParams);
    }

    public static void build(FacesContext context, StringBuilder sb, UIComponent component, String sourceId, String eventName, Collection<String> executeList, Collection<String> renderList, String delay, boolean resetValues, String onerror, String onevent, Collection<ClientBehaviorContext.Parameter> params) {
        String execute = null;
        if (executeList != null && !executeList.isEmpty()) {
            execute = String.join((CharSequence)BLANK, executeList);
        }
        String render = null;
        if (renderList != null && !renderList.isEmpty()) {
            render = String.join((CharSequence)BLANK, renderList);
        }
        AjaxScriptBuilder.build(context, sb, component, sourceId, eventName, execute, render, delay, resetValues ? Boolean.TRUE.toString() : null, onerror, onevent, params, null);
    }

    public static void build(FacesContext context, StringBuilder sb, UIComponent component, String sourceId, String eventName, String execute, String render, String delay, String resetValues, String onerror, String onevent, Collection<ClientBehaviorContext.Parameter> params, List<UIParameter> uiParams) {
        HtmlCommandScript commandScript = component instanceof HtmlCommandScript ? (HtmlCommandScript)component : null;
        sb.append("jsf.ajax.request(");
        if (sourceId == null) {
            sb.append(AJAX_VAL_THIS);
        } else {
            sb.append(QUOTE);
            sb.append(sourceId);
            sb.append(QUOTE);
            if (!sourceId.trim().equals(component.getClientId(context))) {
                UIComponent ref = component.getParent() == null ? component : component.getParent();
                UIComponent instance = null;
                try {
                    instance = ref.findComponent(sourceId);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (instance == null && execute == null) {
                    execute = component.getClientId(context);
                }
            }
        }
        sb.append(COMMA);
        sb.append(AJAX_VAL_EVENT);
        sb.append(COMMA);
        sb.append(L_C_BRACE);
        SearchExpressionHandler seHandler = null;
        SearchExpressionContext seContext = null;
        if (StringUtils.isNotBlank(execute) || StringUtils.isNotBlank(render)) {
            seHandler = context.getApplication().getSearchExpressionHandler();
            seContext = SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)component, MyFacesSearchExpressionHints.SET_RESOLVE_CLIENT_SIDE_RESOLVE_SINGLE_COMPONENT, null);
        }
        if (!StringUtils.isBlank(execute)) {
            AjaxScriptBuilder.appendIds(sb, AJAX_KEY_EXECUTE, execute, seHandler, seContext);
            sb.append(COMMA);
        }
        if (!StringUtils.isBlank(render)) {
            AjaxScriptBuilder.appendIds(sb, AJAX_KEY_RENDER, render, seHandler, seContext);
            sb.append(COMMA);
        }
        if (onevent != null || onerror != null || delay != null || resetValues != null || AjaxScriptBuilder.hasParams(eventName, params, uiParams)) {
            if (onevent != null) {
                AjaxScriptBuilder.appendProperty(sb, AJAX_KEY_ONEVENT, onevent, false);
            }
            if (onerror != null) {
                AjaxScriptBuilder.appendProperty(sb, AJAX_KEY_ONERROR, onerror, false);
            }
            if (delay != null) {
                AjaxScriptBuilder.appendProperty(sb, AJAX_KEY_DELAY, delay, true);
            }
            if (resetValues != null) {
                AjaxScriptBuilder.appendProperty(sb, AJAX_KEY_RESETVALUES, resetValues, false);
            }
            if (!StringUtils.isBlank(eventName) || AjaxScriptBuilder.hasParams(eventName, params, uiParams)) {
                StringBuilder paramsBuilder = SharedStringBuilder.get((FacesContext)context, (String)AJAX_PARAM_SB, (int)60);
                paramsBuilder.append(L_C_BRACE);
                if (!StringUtils.isBlank(eventName)) {
                    AjaxScriptBuilder.appendProperty(paramsBuilder, "jakarta.faces.behavior.event", eventName, true);
                }
                if (params != null && !params.isEmpty()) {
                    if (params instanceof RandomAccess) {
                        List list = (List)params;
                        int size = list.size();
                        for (int i = 0; i < size; ++i) {
                            ClientBehaviorContext.Parameter param = (ClientBehaviorContext.Parameter)list.get(i);
                            AjaxScriptBuilder.appendProperty(paramsBuilder, param.getName(), param.getValue(), true);
                        }
                    } else {
                        for (ClientBehaviorContext.Parameter param : params) {
                            AjaxScriptBuilder.appendProperty(paramsBuilder, param.getName(), param.getValue(), true);
                        }
                    }
                }
                if (uiParams != null && uiParams.size() > 0) {
                    int size = uiParams.size();
                    for (int i = 0; i < size; ++i) {
                        UIParameter param = uiParams.get(i);
                        AjaxScriptBuilder.appendProperty(paramsBuilder, param.getName(), param.getValue(), true);
                    }
                }
                paramsBuilder.append(R_C_BRACE);
                AjaxScriptBuilder.appendProperty(sb, AJAX_KEY_PARAMS, paramsBuilder, false);
            }
        }
        sb.append('}');
        sb.append(R_PAREN);
    }

    private static void appendIds(StringBuilder sb, String key, String expressions, SearchExpressionHandler handler, SearchExpressionContext searchExpressionContext) {
        List clientIds;
        if (StringUtils.isBlank(expressions)) {
            return;
        }
        sb.append(key + COLON);
        sb.append(QUOTE);
        if (StringUtils.isNotBlank(expressions) && (clientIds = handler.resolveClientIds(searchExpressionContext, expressions)) != null && !clientIds.isEmpty()) {
            for (int i = 0; i < clientIds.size(); ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append((String)clientIds.get(i));
            }
        }
        sb.append(QUOTE);
    }

    public static void appendProperty(StringBuilder builder, String name, Object value, boolean quoteValue) {
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException();
        }
        char lastChar = builder.charAt(builder.length() - 1);
        if (!COMMA.equals(String.valueOf(lastChar)) && !L_C_BRACE.equals(String.valueOf(lastChar))) {
            builder.append(COMMA);
        }
        builder.append(QUOTE);
        builder.append(name);
        builder.append(QUOTE);
        builder.append(COLON);
        if (value == null) {
            builder.append("''");
        } else if (quoteValue) {
            builder.append(QUOTE);
            builder.append(value);
            builder.append(QUOTE);
        } else {
            builder.append(value);
        }
    }

    private static boolean hasParams(String eventName, Collection<ClientBehaviorContext.Parameter> params, List<UIParameter> uiParams) {
        return !StringUtils.isBlank(eventName) || params != null && !params.isEmpty() || uiParams != null && !uiParams.isEmpty();
    }
}

