/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Predicate;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.security.credential.Credential;

public interface KeyTransportAlgorithmPredicate
extends Predicate<SelectionInput> {

    public static final class SelectionInput {
        private String keyTransportAlgorithm;
        private String dataEncryptionAlgorithm;
        private Credential keyTransportCredential;

        public SelectionInput(@Nonnull String keyTransportAlgorithmCandidate, @Nullable String dataEncryptionAlgorithmCandidate, @Nullable Credential keyTransportCredentialCandidate) {
            this.keyTransportAlgorithm = (String)Constraint.isNotNull((Object)keyTransportAlgorithmCandidate, (String)"Key transport algorithm candidate was not supplied");
            this.dataEncryptionAlgorithm = dataEncryptionAlgorithmCandidate;
            this.keyTransportCredential = keyTransportCredentialCandidate;
        }

        @Nonnull
        public String getKeyTransportAlgorithm() {
            return this.keyTransportAlgorithm;
        }

        @Nullable
        public String getDataEncryptionAlgorithm() {
            return this.dataEncryptionAlgorithm;
        }

        @Nullable
        public Credential getKeyTransportCredential() {
            return this.keyTransportCredential;
        }
    }
}

