/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.messaging.impl;

import jakarta.annotation.Nonnull;
import java.util.List;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.wsaddressing.MessageID;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractMessageIDHandler
extends AbstractMessageHandler {
    private Logger log = LoggerFactory.getLogger(ExtractMessageIDHandler.class);

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        MessageID header = this.getMessageID(messageContext);
        String headerValue = header != null ? StringSupport.trimOrNull((String)header.getURI()) : null;
        this.log.debug("Extracted inbound WS-Addressing MessageID value: {}", (Object)headerValue);
        if (header != null && headerValue != null) {
            ((WSAddressingContext)messageContext.getSubcontext(WSAddressingContext.class, true)).setMessageIDURI(headerValue);
            SOAPMessagingSupport.registerUnderstoodHeader(messageContext, header);
        }
    }

    protected MessageID getMessageID(@Nonnull MessageContext messageContext) {
        List<XMLObject> messageIDs = SOAPMessagingSupport.getInboundHeaderBlock(messageContext, MessageID.ELEMENT_NAME);
        if (messageIDs != null && !messageIDs.isEmpty()) {
            return (MessageID)messageIDs.get(0);
        }
        return null;
    }
}

