/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditAuthenticationResult;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.source.utils.AuditUtils;
import com.ibm.ws.security.audit.source.utils.ParameterUtils;
import com.ibm.ws.webcontainer.security.WebRequest;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EJBAuthorizationEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(EJBAuthorizationEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = -4986415271765706119L;

    public EJBAuthorizationEvent() {
        this.set("eventName", "SECURITY_AUTHZ");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public EJBAuthorizationEvent(AuditAuthenticationResult authResult, HashMap request, Object hreq, Object hwebReq, String realm, Subject subject, Collection<String> roles, Integer statusCode) {
        block24: {
            this();
            try {
                HttpServletRequest req = (HttpServletRequest)hreq;
                WebRequest webreq = (WebRequest)hwebReq;
                if (req != null) {
                    String queryString;
                    String requestURI;
                    String agent;
                    String remoteAddr = req.getRemoteAddr();
                    if (remoteAddr != null) {
                        this.set("initiator.host.address", remoteAddr);
                    }
                    if ((agent = req.getHeader("User-Agent")) != null) {
                        this.set("initiator.host.agent", agent);
                    }
                    if ((requestURI = req.getRequestURI()) != null) {
                        this.set("target.name", URLDecoder.decode(requestURI, "UTF-8"));
                    }
                    String localAddr = req.getLocalAddr();
                    int localPort = req.getLocalPort();
                    if (localAddr != null && localPort >= 0) {
                        this.set("target.host.address", localAddr + ":" + localPort);
                    }
                    if ((queryString = req.getQueryString()) != null) {
                        String str = URLDecoder.decode(queryString, "UTF-8");
                        str = AuditUtils.hidePassword(str);
                        this.set("target.params", str);
                    }
                    this.set("target.method", AuditUtils.getRequestMethod(req));
                    String sessionID = AuditUtils.getSessionID(req);
                    if (sessionID != null) {
                        this.set("target.session", sessionID);
                    }
                }
                this.set("target.appname", AuditUtils.getJ2EEComponentName());
                if (subject != null) {
                    this.set("target.credential.token", subject.getPrincipals().iterator().next().getName());
                } else if (req != null && req.getUserPrincipal() != null && req.getUserPrincipal().getName() != null) {
                    this.set("target.credential.token", req.getUserPrincipal().getName());
                }
                this.set("target.credential.type", authResult.getAuditCredType());
                if (roles != null && !roles.isEmpty()) {
                    this.set("target.role.names", roles.toString());
                }
                if (request.get("applicationName") != null) {
                    this.set("target.appname", request.get("applicationName"));
                }
                if (request.get("moduleName") != null) {
                    this.set("target.ejb.module.name", request.get("moduleName"));
                }
                if (request.get("methodName") != null) {
                    this.set("target.method", request.get("methodName"));
                }
                if (request.get("methodInterface") != null) {
                    this.set("target.ejb.method.interface", request.get("methodInterface"));
                }
                if (request.get("methodSignature") != null) {
                    this.set("target.ejb.method.signature", request.get("methodSignature"));
                }
                if (request.get("beanName") != null) {
                    this.set("target.ejb.beanname", request.get("beanName"));
                }
                if (request.get("methodParameters") != null) {
                    this.set("target.ejb.method.parameters", ParameterUtils.format(request.get("methodParameters")).toString());
                }
                if (request.get("reason.reasonType") != null) {
                    this.set("reason.reasonType", request.get("reason.reasonType"));
                } else {
                    this.set("reason.reasonType", "EBJ");
                }
                this.set("target.realm", AuditUtils.getRealmName());
                if (statusCode == 200) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", statusCode);
                } else {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", statusCode);
                }
            }
            catch (Exception req) {
                void e;
                FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.security.audit.event.EJBAuthorizationEvent", (String)"148", (Object)((Object)this), (Object[])new Object[]{authResult, request, hreq, hwebReq, realm, subject, roles, statusCode});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block24;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating EJBAuthorizationEvent", (Object[])new Object[]{e});
            }
        }
    }
}

