/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.container.application;

import com.ibm.ws.jsf.container.cdi.IBMViewHandlerProxy;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.application.Application;
import jakarta.faces.application.ApplicationWrapper;
import jakarta.faces.application.ViewHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JSFContainerApplication
extends ApplicationWrapper {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf.container.application");
    private Application delegate;
    private String appname;

    public JSFContainerApplication(Application delegate, String appname) {
        this.delegate = delegate;
        this.appname = appname;
    }

    public void setViewHandler(ViewHandler handler) {
        block6: {
            try {
                BeanManager beanManager = (BeanManager)InitialContext.doLookup("java:comp/BeanManager");
                if (beanManager != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.logp(Level.FINEST, JSFContainerApplication.class.getName(), "setViewHandler", "Setting IBM View Handler");
                    }
                    this.delegate.setViewHandler((ViewHandler)new IBMViewHandlerProxy(handler, this.appname));
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.logp(Level.FINEST, JSFContainerApplication.class.getName(), "setViewHandler", "Setting default View Handler", this.appname);
                    }
                    this.delegate.setViewHandler(handler);
                }
            }
            catch (NamingException e) {
                this.delegate.setViewHandler(handler);
                if (!log.isLoggable(Level.FINEST)) break block6;
                log.log(Level.FINEST, e.getMessage(), e);
            }
        }
    }

    public ViewHandler getViewHandler() {
        return this.delegate.getViewHandler();
    }

    public Application getWrapped() {
        return this.delegate;
    }
}

