/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.expression;

import jakarta.data.constraint.Constraint;
import jakarta.data.constraint.EqualTo;
import jakarta.data.constraint.In;
import jakarta.data.constraint.NotEqualTo;
import jakarta.data.constraint.NotIn;
import jakarta.data.constraint.NotNull;
import jakarta.data.constraint.Null;
import jakarta.data.restrict.BasicRestriction;
import jakarta.data.restrict.Restriction;
import java.util.Collection;

public interface Expression<T, V> {
    default public Restriction<T> equalTo(Expression<? super T, V> expression) {
        EqualTo<V> constraint = EqualTo.expression(expression);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> equalTo(V value) {
        EqualTo<V> constraint = EqualTo.value(value);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> in(Collection<V> values) {
        In<V> constraint = In.values(values);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> in(Expression<? super T, V> ... expressions) {
        In<V> constraint = In.expressions(expressions);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> in(V ... values) {
        In<V> constraint = In.values(values);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> isNull() {
        Null constraint = Null.instance();
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notEqualTo(Expression<? super T, V> expression) {
        NotEqualTo<V> constraint = NotEqualTo.expression(expression);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notEqualTo(V value) {
        NotEqualTo<V> constraint = NotEqualTo.value(value);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notIn(Collection<V> values) {
        NotIn<V> constraint = NotIn.values(values);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notIn(Expression<? super T, V> ... expressions) {
        NotIn<V> constraint = NotIn.expressions(expressions);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notIn(V ... values) {
        NotIn<V> constraint = NotIn.values(values);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notNull() {
        NotNull constraint = NotNull.instance();
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> satisfies(Constraint<V> constraint) {
        return BasicRestriction.of(this, constraint);
    }
}

