/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.common.cl;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BuildResponseTypeUtil {
    private static final TraceComponent tc = Tr.register(BuildResponseTypeUtil.class, null, null);
    private static final String CLASS = BuildResponseTypeUtil.class.getName();
    private static Logger log = Logger.getLogger(CLASS);
    static final long serialVersionUID = -2243962117335223331L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public static void buildResponseGrantType(AttributeList attributeList, List<OAuth20Token> tokens) {
        String methodName = "buildResponseGrantType";
        log.entering(CLASS, methodName);
        try {
            for (OAuth20Token token : tokens) {
                String strTokenType = token.getType();
                if ("access_token".equals(strTokenType)) {
                    BuildResponseTypeUtil.handleAccessToken(attributeList, token);
                    continue;
                }
                if ("authorization_grant".equals(strTokenType)) {
                    BuildResponseTypeUtil.handleRefreshToken(attributeList, token);
                    continue;
                }
                if ("id_token".equals(strTokenType)) {
                    BuildResponseTypeUtil.handleIDToken(attributeList, token);
                    continue;
                }
                log.logp(Level.FINEST, CLASS, methodName, "Unknown token type:'" + strTokenType + "'");
            }
        }
        finally {
            log.exiting(CLASS, methodName);
        }
    }

    public static final void handleAccessToken(AttributeList attributeList, OAuth20Token token) {
        String accessToken = token.getTokenString();
        attributeList.setAttribute("access_token", "urn:ibm:names:oauth:response:attribute", new String[]{accessToken});
        String accessTokenId = token.getId();
        attributeList.setAttribute("access_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{accessTokenId});
        String type = token.getSubType();
        attributeList.setAttribute("token_type", "urn:ibm:names:oauth:response:attribute", new String[]{type});
        String expires = OAuth20TokenHelper.expiresInSeconds((OAuth20Token)token);
        attributeList.setAttribute("expires_in", "urn:ibm:names:oauth:response:attribute", new String[]{expires});
        String stateId = token.getStateId();
        attributeList.setAttribute("state_id", "urn:ibm:names:oauth:state", new String[]{stateId});
        String[] scope = token.getScope();
        attributeList.setAttribute("scope", "urn:ibm:names:oauth:response:attribute", scope);
    }

    public static final void handleRefreshToken(AttributeList attributeList, OAuth20Token refresh) {
        String refreshToken = refresh.getTokenString();
        attributeList.setAttribute("refresh_token", "urn:ibm:names:oauth:response:attribute", new String[]{refreshToken});
        String refreshTokenId = refresh.getId();
        attributeList.setAttribute("refresh_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{refreshTokenId});
    }

    public static final void handleIDToken(AttributeList attributeList, OAuth20Token idtoken) {
        String strIdToken = idtoken.getTokenString();
        attributeList.setAttribute("id_token", "urn:ibm:names:oauth:response:attribute", new String[]{strIdToken});
    }

    public static void putAccessTokenInMap(Map<String, String[]> idTokenMap, List<OAuth20Token> tokenList) {
        for (OAuth20Token token : tokenList) {
            String strTokenType = token.getType();
            if (!"access_token".equals(strTokenType)) continue;
            String accessTokenString = token.getTokenString();
            idTokenMap.put("access_token", new String[]{accessTokenString});
            break;
        }
    }

    public static void putIssuerIdentifierInMap(Map<String, String[]> idTokenMap, AttributeList attributeList) {
        String issuerIdentifier = attributeList.getAttributeValueByName("issuerIdentifier");
        idTokenMap.put("issuerIdentifier", new String[]{issuerIdentifier});
    }
}

