/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.requests;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCErrorCode;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCException;
import io.openliberty.mcp.internal.requests.McpRequestId;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Type;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpRequestIdDeserializer
implements JsonbDeserializer<McpRequestId> {
    static final long serialVersionUID = 7957113209423047319L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public McpRequestId deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        JsonValue jsonVal = parser.getValue();
        switch (jsonVal.getValueType()) {
            case STRING: {
                String strVal = ((JsonString)jsonVal).getString();
                if (strVal.isBlank()) {
                    throw new JSONRPCException(JSONRPCErrorCode.PARSE_ERROR, "MCP Request Id must not be blank");
                }
                return new McpRequestId(strVal);
            }
            case NUMBER: {
                return new McpRequestId(((JsonNumber)jsonVal).bigDecimalValue());
            }
        }
        throw new JSONRPCException(JSONRPCErrorCode.PARSE_ERROR, "MCP Request Id must be a string or number");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.requests.McpRequestIdDeserializer", McpRequestIdDeserializer.class, (String)"MCP", null);
    }
}

