/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.VirtualHost;
import io.openliberty.mcp.internal.McpForwardFilter;
import io.openliberty.mcp.internal.McpServlet;
import io.openliberty.mcp.internal.ToolRegistry;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class McpServletInitializer
implements ServletContainerInitializer {
    private static final TraceComponent tc = Tr.register(McpServletInitializer.class, (String)"MCP", null);
    @Reference
    private volatile VirtualHost virtualHost;
    private String mcpEndpoint = "/mcp";
    static final long serialVersionUID = -70964976592552523L;

    public void onStartup(Set<Class<?>> c, ServletContext context) throws ServletException {
        if (ToolRegistry.get().hasTools()) {
            ServletRegistration.Dynamic reg = context.addServlet("io.openliberty.mcp.servlet", McpServlet.class);
            reg.addMapping(new String[]{this.mcpEndpoint});
            FilterRegistration.Dynamic filterReg = context.addFilter("io.openliberty.mcp.servlet.filter", McpForwardFilter.class);
            filterReg.addMappingForUrlPatterns(null, false, new String[]{"/mcp/"});
            String fullMcpUrl = this.virtualHost.getUrlString(context.getContextPath() + this.mcpEndpoint, false);
            Tr.info((TraceComponent)tc, (String)("MCP server endpoint: " + fullMcpUrl), (Object[])new Object[0]);
        }
    }
}

