/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.McpSession;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCErrorCode;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCException;
import io.openliberty.mcp.internal.requests.CancellationImpl;
import io.openliberty.mcp.internal.requests.ExecutionRequestId;
import io.openliberty.mcp.messaging.Cancellation;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ApplicationScoped
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpConnectionTracker {
    private final ConcurrentMap<String, Cancellation> ongoingRequests = new ConcurrentHashMap<String, Cancellation>();
    static final long serialVersionUID = 893007428405627888L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void deregisterOngoingRequest(ExecutionRequestId id) {
        this.ongoingRequests.remove(id.toString());
    }

    public void registerOngoingRequest(ExecutionRequestId id, Cancellation cancellation) {
        Cancellation previous = this.ongoingRequests.putIfAbsent(id.toString(), cancellation);
        if (previous != null) {
            throw new JSONRPCException(JSONRPCErrorCode.INVALID_PARAMS, "A request with id " + id.toString() + " is already in progress");
        }
    }

    public boolean isOngoingRequest(ExecutionRequestId id) {
        return this.ongoingRequests.containsKey(id.toString());
    }

    public Cancellation getOngoingRequestCancellation(ExecutionRequestId id) {
        return (Cancellation)this.ongoingRequests.get(id.toString());
    }

    public void cancelSessionRequests(McpSession session) {
        for (ExecutionRequestId id : session.getActiveRequests()) {
            Cancellation cancellation = (Cancellation)this.ongoingRequests.remove(id.toString());
            if (!(cancellation instanceof CancellationImpl)) continue;
            ((CancellationImpl)cancellation).cancel(Optional.of("Session cancelled"));
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.McpConnectionTracker", McpConnectionTracker.class, (String)"MCP", null);
    }
}

