/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.impl;

import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderMessages;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class ConnectorConfig
implements Config {
    public static final String CHANNEL_ENABLED_PROPERTY = "enabled";
    public static final String BROADCAST_PROPERTY = "broadcast";
    public static final String MERGE_PROPERTY = "merge";
    protected final String prefix;
    protected final Config overall;
    protected final String name;
    protected final String connector;
    protected final String channelPrefix;
    private static final Pattern NON_ALPHA = Pattern.compile("\\W");

    protected ConnectorConfig(String prefix, Config overall, String channel) {
        this.prefix = Objects.requireNonNull(prefix, ProviderMessages.msg.prefixMustNotBeSet());
        this.overall = Objects.requireNonNull(overall, ProviderMessages.msg.configMustNotBeSet());
        this.name = Objects.requireNonNull(channel, ProviderMessages.msg.channelMustNotBeSet());
        this.channelPrefix = ConnectorConfig.channelPrefix(prefix, this.name);
        Optional value = overall.getOptionalValue(this.channelKey("connector"), String.class);
        this.connector = value.orElseGet(() -> (String)overall.getOptionalValue(this.channelKey("type"), String.class).orElseThrow(() -> ProviderExceptions.ex.illegalArgumentChannelConnectorConfiguration(this.name)));
        for (String key : overall.getPropertyNames()) {
            if (!this.channelKey("channel-name").equalsIgnoreCase(key)) continue;
            throw ProviderExceptions.ex.illegalArgumentInvalidChannelConfiguration(this.name);
        }
    }

    public static String channelPrefix(String prefix, String name) {
        return name.contains(".") ? prefix + "\"" + name + "\"." : prefix + name + ".";
    }

    protected String channelKey(String keyName) {
        return this.channelPrefix + keyName;
    }

    protected String connectorKey(String keyName) {
        return "mp.messaging.connector." + this.connector + "." + keyName;
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return this.convert(this.name, propertyType);
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return this.convert(this.connector, propertyType);
        }
        Optional maybeResult = this.overall.getOptionalValue(this.channelKey(propertyName), propertyType);
        if (maybeResult.isPresent()) {
            return maybeResult.get();
        }
        maybeResult = this.overall.getOptionalValue(this.connectorKey(propertyName), propertyType);
        if (maybeResult.isPresent()) {
            return maybeResult.get();
        }
        throw ProviderExceptions.ex.noSuchElementForAttribute(propertyName, this.name, this.channelKey(propertyName), this.connectorKey(propertyName));
    }

    public ConfigValue getConfigValue(String propertyName) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return new ConfigValueImpl("channel-name", this.name);
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return new ConfigValueImpl("connector", this.connector);
        }
        ConfigValue value = this.overall.getConfigValue(this.channelKey(propertyName));
        if (value.getRawValue() == null) {
            return this.overall.getConfigValue(this.connectorKey(propertyName));
        }
        return value;
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return this.convertOptional(this.name, propertyType);
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return this.convertOptional(this.connector, propertyType);
        }
        Optional maybe = this.overall.getOptionalValue(this.channelKey(propertyName), propertyType);
        return maybe.isPresent() ? maybe : this.overall.getOptionalValue(this.connectorKey(propertyName), propertyType);
    }

    protected <T> T convert(String rawValue, Class<T> propertyType) {
        Optional converter = this.overall.getConverter(propertyType);
        if (!converter.isPresent()) {
            if (propertyType.isAssignableFrom(String.class)) {
                return propertyType.cast(rawValue);
            }
            throw ProviderExceptions.ex.noConverterForType(propertyType);
        }
        Object result = ((Converter)converter.get()).convert(rawValue);
        if (result == null) {
            throw ProviderExceptions.ex.converterReturnedNull((Converter)converter.get(), rawValue);
        }
        return (T)result;
    }

    protected <T> Optional<T> convertOptional(String rawValue, Class<T> propertyType) {
        Optional converter = this.overall.getConverter(propertyType);
        if (!converter.isPresent() && propertyType.isAssignableFrom(String.class)) {
            return Optional.of(propertyType.cast(rawValue));
        }
        return converter.map(c -> c.convert(rawValue));
    }

    public Iterable<String> getPropertyNames() {
        String prefix = this.channelPrefix;
        String prefixAlpha = this.toAlpha(prefix);
        String prefixAlphaUpper = prefixAlpha.toUpperCase();
        String connectorPrefix = "mp.messaging.connector." + this.connector + ".";
        String connectorPrefixAlpha = this.toAlpha(connectorPrefix);
        String connectorPrefixAlphaUpper = connectorPrefixAlpha.toUpperCase();
        HashSet<String> names = new HashSet<String>();
        for (String name : this.overall.getPropertyNames()) {
            String computed;
            if (name.startsWith(connectorPrefix)) {
                computed = name.substring(connectorPrefix.length());
                names.add(computed);
                continue;
            }
            if (name.startsWith(connectorPrefixAlpha)) {
                computed = name.substring(connectorPrefixAlpha.length());
                if (!this.nameExists(connectorPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(connectorPrefixAlphaUpper)) {
                computed = name.substring(connectorPrefixAlphaUpper.length());
                if (!this.nameExists(connectorPrefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (name.startsWith(prefix)) {
                computed = name.substring(prefix.length());
                names.add(computed);
                continue;
            }
            if (name.startsWith(prefixAlpha)) {
                computed = name.substring(prefixAlpha.length());
                if (!this.nameExists(prefix + computed)) continue;
                names.add(computed);
                continue;
            }
            if (!name.startsWith(prefixAlphaUpper) || !this.nameExists(prefix + (computed = name.substring(prefixAlphaUpper.length())))) continue;
            names.add(computed);
        }
        names.add("channel-name");
        return names;
    }

    protected String toAlpha(String key) {
        return NON_ALPHA.matcher(key).replaceAll("_");
    }

    protected boolean nameExists(String name) {
        return this.overall.getConfigValue(name).getRawValue() != null;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.overall.getConfigSources();
    }

    public <T> Optional<Converter<T>> getConverter(Class<T> forType) {
        return this.overall.getConverter(forType);
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        throw ProviderExceptions.ex.configNotOfType(type);
    }

    protected static class ConfigValueImpl
    implements ConfigValue {
        private final String name;
        private final String value;

        public ConfigValueImpl(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getRawValue() {
            return this.value;
        }

        public String getSourceName() {
            return "ConnectorConfig internal";
        }

        public int getSourceOrdinal() {
            return 0;
        }
    }
}

