/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.metadata.Company;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.ContactPersonTypeEnumeration;
import org.opensaml.saml.saml2.metadata.EmailAddress;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.GivenName;
import org.opensaml.saml.saml2.metadata.SurName;
import org.opensaml.saml.saml2.metadata.TelephoneNumber;
import org.w3c.dom.Attr;

public class ContactPersonUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Override
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        ContactPerson person = (ContactPerson)parentSAMLObject;
        if (childSAMLObject instanceof Extensions) {
            person.setExtensions((Extensions)childSAMLObject);
        } else if (childSAMLObject instanceof Company) {
            person.setCompany((Company)childSAMLObject);
        } else if (childSAMLObject instanceof GivenName) {
            person.setGivenName((GivenName)childSAMLObject);
        } else if (childSAMLObject instanceof SurName) {
            person.setSurName((SurName)childSAMLObject);
        } else if (childSAMLObject instanceof EmailAddress) {
            person.getEmailAddresses().add((EmailAddress)childSAMLObject);
        } else if (childSAMLObject instanceof TelephoneNumber) {
            person.getTelephoneNumbers().add((TelephoneNumber)childSAMLObject);
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }

    @Override
    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        ContactPerson person = (ContactPerson)samlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("contactType")) {
                try {
                    if (attribute.getValue() == null) {
                        throw new UnmarshallingException("Saw an empty value for contactType attribute");
                    }
                    person.setType(ContactPersonTypeEnumeration.valueOf(attribute.getValue().toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new UnmarshallingException("Saw an invalid value for contactType attribute: " + attribute.getValue());
                }
            } else {
                super.processAttribute(samlObject, attribute);
            }
        } else {
            this.processUnknownAttribute(person, attribute);
        }
    }
}

