/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.servlet.filter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;

public class SessionFilter
implements Filter {
    private FilterConfig filterConfig;
    private static final TraceComponent tc = Tr.register(SessionFilter.class);
    private static final String LOGIN_ERROR_PAGE = "/adminCenter/login.jsp?no_access";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String methodName = "doFilter";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        if (req instanceof HttpServletRequest && resp instanceof HttpServletResponse) {
            HttpServletRequest httpServletReq = (HttpServletRequest)req;
            HttpServletResponse httpServletResp = (HttpServletResponse)resp;
            HttpSession session = httpServletReq.getSession(false);
            String requestURI = httpServletReq.getRequestURI();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{requestURI});
            }
            if (requestURI.equals("/adminCenter/j_security_check") && httpServletReq.getMethod().equals("GET")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Session = " + session), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)"Redirecting to /adminCenter/login.jsp?no_access", (Object[])new Object[0]);
                }
                httpServletResp.sendRedirect(LOGIN_ERROR_PAGE);
                if (session != null) {
                    session.invalidate();
                }
            }
        }
        chain.doFilter(req, resp);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }
}

