/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.rest.v1;

import com.ibm.websphere.jsonsupport.JSON;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.internal.Filter;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.rest.AdminCenterRestHandler;
import com.ibm.ws.ui.internal.rest.CommonJSONRESTHandler;
import com.ibm.ws.ui.internal.rest.exceptions.BadRequestException;
import com.ibm.ws.ui.internal.rest.exceptions.MethodNotSupportedException;
import com.ibm.ws.ui.internal.rest.exceptions.NoSuchResourceException;
import com.ibm.ws.ui.internal.rest.exceptions.RESTException;
import com.ibm.ws.ui.internal.rest.exceptions.UserNotAuthorizedException;
import com.ibm.ws.ui.internal.rest.v1.V1Constants;
import com.ibm.ws.ui.internal.v1.ICatalog;
import com.ibm.ws.ui.internal.v1.ICatalogService;
import com.ibm.ws.ui.internal.v1.ITool;
import com.ibm.ws.ui.internal.v1.pojo.Bookmark;
import com.ibm.ws.ui.internal.v1.pojo.DuplicateException;
import com.ibm.ws.ui.internal.v1.pojo.Message;
import com.ibm.ws.ui.internal.validation.InvalidToolException;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;

public class CatalogAPI
extends CommonJSONRESTHandler
implements V1Constants {
    private static final TraceComponent tc = Tr.register(CatalogAPI.class);
    static final String CHILD_RESOURCE_METADATA = "_metadata";
    static final String CHILD_RESOURCE_FEATURE_TOOLS = "featureTools";
    static final String CHILD_RESOURCE_BOOKMARKS = "bookmarks";
    static final String RESET_CATALOG_CONFIRMATION_PARAM = "resetCatalog";
    private final ICatalogService catalogService;

    public CatalogAPI(ICatalogService catalogService) {
        super("/adminCenter/v1/catalog", true, true);
        this.catalogService = catalogService;
    }

    protected CatalogAPI(ICatalogService catalogService, Filter filter, JSON jsonService) {
        super("/adminCenter/v1/catalog", true, true, filter, jsonService);
        this.catalogService = catalogService;
    }

    @Trivial
    private ICatalog getCatalog() {
        return this.catalogService.getCatalog();
    }

    @Override
    public boolean isKnownChildResource(String child, RESTRequest request) {
        return CHILD_RESOURCE_BOOKMARKS.equals(child) || CHILD_RESOURCE_FEATURE_TOOLS.equals(child) || CHILD_RESOURCE_METADATA.equals(child);
    }

    @Override
    public boolean isKnownGrandchildResource(String child, String grandchild, RESTRequest request) {
        String toolId = grandchild;
        if (CHILD_RESOURCE_BOOKMARKS.equals(child)) {
            return this.getCatalog().getBookmark(toolId) != null;
        }
        if (CHILD_RESOURCE_FEATURE_TOOLS.equals(child)) {
            return this.getCatalog().getFeatureTool(toolId) != null;
        }
        return false;
    }

    @Override
    public Object getBase(RESTRequest request, RESTResponse response) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        return this.applyFilter(request, this.getCatalog());
    }

    @Override
    public Object getChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        if (CHILD_RESOURCE_BOOKMARKS.equals(child)) {
            return this.applyFilter(request, this.getCatalog().getBookmarks());
        }
        if (CHILD_RESOURCE_FEATURE_TOOLS.equals(child)) {
            return this.applyFilter(request, this.getCatalog().getFeatureTools());
        }
        if (CHILD_RESOURCE_METADATA.equals(child)) {
            return this.applyFilter(request, this.getCatalog().get_metadata());
        }
        throw new NoSuchResourceException();
    }

    private Object handleToolResponse(RESTRequest request, String toolId, ITool tool) throws RESTException, NoSuchResourceException {
        if (tool != null) {
            return this.applyFilter(request, tool);
        }
        Message tmsg = new Message(404, RequestNLS.formatMessage(tc, "TOOL_NOT_FOUND", toolId));
        throw new NoSuchResourceException("application/json; charset=UTF-8", tmsg);
    }

    @Override
    public Object getGrandchild(RESTRequest request, RESTResponse response, String child, String grandchild) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        String toolId = grandchild;
        if (CHILD_RESOURCE_BOOKMARKS.equals(child)) {
            return this.handleToolResponse(request, toolId, this.getCatalog().getBookmark(toolId));
        }
        if (CHILD_RESOURCE_FEATURE_TOOLS.equals(child)) {
            return this.handleToolResponse(request, toolId, this.getCatalog().getFeatureTool(toolId));
        }
        throw new NoSuchResourceException();
    }

    @Override
    @FFDCIgnore(value={DuplicateException.class, InvalidToolException.class})
    public AdminCenterRestHandler.POSTResponse postChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        if (CHILD_RESOURCE_BOOKMARKS.equals(child)) {
            Bookmark bookmark = this.readJSONPayload(request, Bookmark.class);
            try {
                Bookmark created = this.getCatalog().addBookmark(bookmark);
                AdminCenterRestHandler.POSTResponse postResponse = new AdminCenterRestHandler.POSTResponse();
                postResponse.createdURL = request.getURL() + "/" + created.getId();
                postResponse.jsonPayload = created;
                return postResponse;
            }
            catch (DuplicateException e) {
                Message payload = new Message(409, e.getMessage());
                throw new RESTException(409, "application/json; charset=UTF-8", payload);
            }
            catch (InvalidToolException e) {
                Message payload = new Message(400, e.getMessage());
                throw new BadRequestException("application/json; charset=UTF-8", payload);
            }
        }
        throw new MethodNotSupportedException();
    }

    @Override
    public Object deleteBase(RESTRequest request, RESTResponse response) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        String resetCatalog = request.getParameter(RESET_CATALOG_CONFIRMATION_PARAM);
        if (Boolean.valueOf(resetCatalog).booleanValue()) {
            this.getCatalog().reset();
            return new Message(200, RequestNLS.formatMessage(tc, "CATALOG_RESET_SUCCESSFUL", new Object[0]));
        }
        Message msg = new Message(400, RequestNLS.formatMessage(tc, "CATALOG_RESET_MUST_BE_CONFIRMED", new Object[0]));
        msg.setDeveloperMessage(RequestNLS.formatMessage(tc, "CATALOG_RESET_MUST_BE_CONFIRMED.developeraction", new Object[0]));
        throw new BadRequestException("application/json; charset=UTF-8", msg);
    }

    @Override
    public Object deleteGrandchild(RESTRequest request, RESTResponse response, String child, String grandchild) throws RESTException {
        if (!this.isAuthorizedDefault(request, response)) {
            throw new UserNotAuthorizedException();
        }
        String toolId = grandchild;
        if (CHILD_RESOURCE_BOOKMARKS.equals(child)) {
            Bookmark deletedTool = this.getCatalog().deleteBookmark(toolId);
            return this.handleToolResponse(request, toolId, deletedTool);
        }
        if (CHILD_RESOURCE_FEATURE_TOOLS.equals(child)) {
            if (this.getCatalog().getFeatureTool(toolId) != null) {
                throw new MethodNotSupportedException();
            }
            throw new NoSuchResourceException();
        }
        throw new MethodNotSupportedException();
    }
}

