/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.execution.datafetcher.CollectionCreator;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Wrapper;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

public abstract class AbstractHelper {
    protected final ClassloadingService classloadingService = ClassloadingService.get();

    protected AbstractHelper() {
    }

    abstract Object afterRecursiveTransform(Object var1, Field var2) throws AbstractDataFetcherException;

    abstract Object singleTransform(Object var1, Field var2) throws AbstractDataFetcherException;

    abstract Object singleMapping(Object var1, Field var2) throws AbstractDataFetcherException;

    Object recursiveTransform(Object inputValue, Field field) throws AbstractDataFetcherException {
        if (inputValue == null) {
            return null;
        }
        if (field.hasWrapper() && field.getWrapper().isArray()) {
            return this.recursiveTransformArray(inputValue, field);
        }
        if (field.hasWrapper() && field.getWrapper().isCollection()) {
            return this.recursiveTransformCollection(inputValue, field);
        }
        if (field.hasWrapper() && field.getWrapper().isOptional()) {
            return this.recursiveTransformOptional(inputValue, field);
        }
        inputValue = this.singleTransform(inputValue, field);
        return this.afterRecursiveTransform(inputValue, field);
    }

    Object recursiveMapping(Object inputValue, Field field) throws AbstractDataFetcherException {
        if (inputValue == null) {
            return null;
        }
        if (field.hasWrapper() && field.getWrapper().isArray()) {
            return this.recursiveMappingArray(inputValue, field);
        }
        if (field.hasWrapper() && field.getWrapper().isCollection()) {
            return this.recursiveMappingCollection(inputValue, field);
        }
        if (field.hasWrapper() && field.getWrapper().isOptional()) {
            return this.recursiveMappingOptional(inputValue, field);
        }
        inputValue = this.singleMapping(inputValue, field);
        return inputValue;
    }

    private Object recursiveTransformArray(Object array, Field field) throws AbstractDataFetcherException {
        if (Classes.isCollection(array)) {
            array = ((Collection)array).toArray();
        }
        Class<?> classInCollection = this.getArrayType(field);
        if (array.getClass().getComponentType().equals(classInCollection)) {
            return array;
        }
        int length = Array.getLength(array);
        Object targetArray = Array.newInstance(classInCollection, length);
        for (int i = 0; i < length; ++i) {
            Field fieldInCollection = this.getFieldInField(field);
            Object element = Array.get(array, i);
            Object targetElement = this.recursiveTransform(element, fieldInCollection);
            Array.set(targetArray, i, targetElement);
        }
        return targetArray;
    }

    private Object recursiveMappingArray(Object array, Field field) throws AbstractDataFetcherException {
        if (Classes.isCollection(array)) {
            array = ((Collection)array).toArray();
        }
        Class<?> classInCollection = this.getArrayType(field);
        if (array.getClass().getComponentType().equals(classInCollection)) {
            return array;
        }
        int length = Array.getLength(array);
        Object targetArray = Array.newInstance(classInCollection, length);
        for (int i = 0; i < length; ++i) {
            Field fieldInCollection = this.getFieldInField(field);
            Object element = Array.get(array, i);
            Object targetElement = this.recursiveMapping(element, fieldInCollection);
            Array.set(targetArray, i, targetElement);
        }
        return targetArray;
    }

    protected Class<?> getArrayType(Field field) {
        String classNameInCollection = field.getReference().getClassName();
        Class<?> classInCollection = this.classloadingService.loadClass(classNameInCollection);
        return classInCollection;
    }

    private Object recursiveTransformCollection(Object argumentValue, Field field) throws AbstractDataFetcherException {
        Collection givenCollection = this.getGivenCollection(argumentValue);
        String collectionClassName = field.getWrapper().getWrapperClassName();
        Collection<?> convertedCollection = CollectionCreator.newCollection(collectionClassName);
        for (Object objectInGivenCollection : givenCollection) {
            Field fieldInCollection = this.getFieldInField(field);
            Object objectInCollection = this.recursiveTransform(objectInGivenCollection, fieldInCollection);
            convertedCollection.add(objectInCollection);
        }
        return convertedCollection;
    }

    private Object recursiveMappingCollection(Object argumentValue, Field field) throws AbstractDataFetcherException {
        Collection givenCollection = this.getGivenCollection(argumentValue);
        String collectionClassName = field.getWrapper().getWrapperClassName();
        Collection<?> convertedCollection = CollectionCreator.newCollection(collectionClassName);
        for (Object objectInGivenCollection : givenCollection) {
            Field fieldInCollection = this.getFieldInField(field);
            Object objectInCollection = this.recursiveMapping(objectInGivenCollection, fieldInCollection);
            convertedCollection.add(objectInCollection);
        }
        return convertedCollection;
    }

    private Optional<Object> recursiveTransformOptional(Object argumentValue, Field field) throws AbstractDataFetcherException {
        if (argumentValue == null || !((Optional)argumentValue).isPresent()) {
            return Optional.empty();
        }
        Optional optional = (Optional)argumentValue;
        Object o = optional.get();
        Field f = this.getFieldInField(field);
        return Optional.of(this.recursiveTransform(o, f));
    }

    private Optional<Object> recursiveMappingOptional(Object argumentValue, Field field) throws AbstractDataFetcherException {
        if (argumentValue == null || !((Optional)argumentValue).isPresent()) {
            return Optional.empty();
        }
        Optional optional = (Optional)argumentValue;
        Object o = optional.get();
        Field f = this.getFieldInField(field);
        return Optional.of(this.recursiveMapping(o, f));
    }

    private Field getFieldInField(Field owner) {
        Wrapper ownerWrapper;
        Field child = new Field(owner.getMethodName(), owner.getPropertyName(), owner.getName(), owner.getDescription(), owner.getReference());
        child.setNotNull(owner.isNotNull());
        child.setTransformation(owner.getTransformation());
        child.setMapping(owner.getMapping());
        child.setDefaultValue(owner.getDefaultValue());
        Wrapper wrapper = owner.getWrapper();
        if (owner.hasWrapper() && (ownerWrapper = owner.getWrapper()).getWrapper() != null) {
            Wrapper childWrapper = ownerWrapper.getWrapper();
            child.setWrapper(childWrapper);
        }
        return child;
    }

    private <T> Collection getGivenCollection(Object argumentValue) {
        if (Classes.isCollection(argumentValue)) {
            return (Collection)argumentValue;
        }
        return Arrays.asList((Object[])argumentValue);
    }
}

