/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal;

import com.ibm.jbatch.container.ws.PartitionReplyMsg;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.jms.internal.BatchJmsMessageHelper;
import com.ibm.ws.jbatch.jms.internal.dispatcher.StartPartitionPayload;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BatchJmsMessage {
    private Message message;
    static final long serialVersionUID = 1432173705268759192L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BatchJmsMessage(Message message) {
        this.message = message;
    }

    public BatchJmsMessage setVersion() throws JMSException {
        this.message.setIntProperty("com_ibm_ws_batch_majorVersion", 1);
        this.message.setIntProperty("com_ibm_ws_batch_internal_minorVersion", 2);
        return this;
    }

    public BatchJmsMessage setJ2eeName(J2EEName j2eeName) throws JMSException {
        this.message.setStringProperty("com_ibm_ws_batch_applicationName", j2eeName.getApplication());
        this.message.setStringProperty("com_ibm_ws_batch_moduleName", j2eeName.getModule());
        this.message.setStringProperty("com_ibm_ws_batch_componentName", j2eeName.getComponent());
        return this;
    }

    public BatchJmsMessage setInstanceId(long jobInstanceId) throws JMSException {
        this.message.setLongProperty("com_ibm_ws_batch_internal_jobInstanceId", jobInstanceId);
        return this;
    }

    public BatchJmsMessage setExecutionId(long executionId) throws JMSException {
        this.message.setLongProperty("com_ibm_ws_batch_internal_jobExecutionId", executionId);
        return this;
    }

    public BatchJmsMessage setOperation(String operation) throws JMSException {
        this.message.setStringProperty("com_ibm_ws_batch_internal_jobOperation", operation);
        return this;
    }

    public BatchJmsMessage setStepName(String stepName) throws JMSException {
        this.message.setStringProperty("com_ibm_ws_batch_stepName", stepName);
        return this;
    }

    public BatchJmsMessage setJobParameters(Properties jobParameters) throws JMSException {
        BatchJmsMessageHelper.setJobParametersToJmsMessageProperties(jobParameters, this.message);
        if (this.message instanceof MapMessage) {
            BatchJmsMessageHelper.setJobParametersToJmsMessageBody(jobParameters, (MapMessage)this.message);
        }
        return this;
    }

    public BatchJmsMessage setSecurityContext(byte[] securityContext) throws JMSException {
        if (!(this.message instanceof MapMessage)) {
            throw new IllegalStateException("Cannot set securityContext for non-MapMessage JMS message: " + this.message);
        }
        ((MapMessage)this.message).setBytes("com_ibm_ws_batch_internal_securityContext", securityContext);
        return this;
    }

    public Message getMessage() {
        return this.message;
    }

    public String getApplicationName() throws JMSException {
        return this.message.getStringProperty("com_ibm_ws_batch_applicationName");
    }

    public String getOperation() throws JMSException {
        String op = this.message.getStringProperty("com_ibm_ws_batch_internal_jobOperation");
        return op == null ? "" : op;
    }

    public String getOperationUnchecked() {
        try {
            return this.getOperation();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.jbatch.jms.internal.BatchJmsMessage", (String)"164", (Object)this, (Object[])new Object[0]);
            return "";
        }
    }

    public long getInstanceId() throws JMSException {
        return this.message.getLongProperty("com_ibm_ws_batch_internal_jobInstanceId");
    }

    public long getInstanceIdUnchecked() {
        try {
            return this.getInstanceId();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.jbatch.jms.internal.BatchJmsMessage", (String)"183", (Object)this, (Object[])new Object[0]);
            return -1L;
        }
    }

    public long getExecutionId() throws JMSException {
        return this.message.getLongProperty("com_ibm_ws_batch_internal_jobExecutionId");
    }

    public byte[] getSecurityContext() throws JMSException {
        if (this.message instanceof MapMessage) {
            return ((MapMessage)this.message).getBytes("com_ibm_ws_batch_internal_securityContext");
        }
        throw new IllegalStateException("Cannot retrieve security context from non-MapMessage message: " + this.message);
    }

    public Properties getJobParameters() throws JMSException {
        if (this.message instanceof MapMessage) {
            return BatchJmsMessageHelper.getJobParametersFromJmsMessage((MapMessage)this.message);
        }
        throw new IllegalStateException("Cannot retrieve job parameters from non-MapMessage message: " + this.message);
    }

    public String toString() {
        return "BatchJmsMessage:" + this.message.toString();
    }

    public int getPartitionNumber() throws JMSException {
        return this.message.getIntProperty("com_ibm_ws_batch_partitionNum");
    }

    public BatchJmsMessage setPartitionNumber(int partitionNum) throws JMSException {
        this.message.setIntProperty("com_ibm_ws_batch_partitionNum", partitionNum);
        return this;
    }

    public BatchJmsMessage setJmsReplyToQueue(Destination replyToQueue) throws JMSException {
        this.message.setJMSReplyTo(replyToQueue);
        return this;
    }

    public BatchJmsMessage setObjectPayload(Serializable payload) throws JMSException {
        ((ObjectMessage)this.message).setObject(payload);
        return this;
    }

    public Serializable getObjectPayload() throws JMSException {
        return ((ObjectMessage)this.message).getObject();
    }

    public BatchJmsMessage setStartPartitionPayload(StartPartitionPayload payload) throws JMSException, IOException {
        this.setObjectPayload((Serializable)this.serializeToBytes(payload));
        return this;
    }

    public StartPartitionPayload getStartPartitionPayload() throws JMSException, IOException, ClassNotFoundException {
        return (StartPartitionPayload)this.deserializeFromBytes((byte[])this.getObjectPayload());
    }

    private byte[] serializeToBytes(Serializable payload) {
        byte[] retVal = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream oos = null;){
                oos = new ObjectOutputStream(baos);
                oos.writeObject(payload);
                retVal = baos.toByteArray();
            }
        }
        catch (IOException baos) {
            FFDCFilter.processException((Throwable)baos, (String)"com.ibm.ws.jbatch.jms.internal.BatchJmsMessage", (String)"305", (Object)this, (Object[])new Object[]{payload});
            throw new IllegalStateException("Cannot serialize the message payload");
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deserializeFromBytes(byte[] bytes) {
        Object retVal = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try (ObjectInputStream ois = null;){
                ois = new ObjectInputStream(bais);
                retVal = ois.readObject();
            }
        }
        catch (ClassNotFoundException bais) {
            FFDCFilter.processException((Throwable)bais, (String)"com.ibm.ws.jbatch.jms.internal.BatchJmsMessage", (String)"328", (Object)this, (Object[])new Object[]{bytes});
            throw new IllegalStateException("Problem while trying to deserialize the payload");
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.jms.internal.BatchJmsMessage", (String)"330", (Object)this, (Object[])new Object[]{bytes});
            throw new IllegalStateException("Problem while trying to deserialize the payload");
        }
        return retVal;
    }

    public Destination getJmsReplyToQueue() throws JMSException {
        return this.message.getJMSReplyTo();
    }

    public BatchJmsMessage setPartitionReplyMsgPayload(PartitionReplyMsg payload) throws JMSException, IOException {
        this.setObjectPayload((Serializable)this.serializeToBytes((Serializable)payload));
        return this;
    }

    public PartitionReplyMsg getPartitionReplyMsgPayload() throws JMSException, IOException, ClassNotFoundException {
        return (PartitionReplyMsg)this.deserializeFromBytes((byte[])this.getObjectPayload());
    }

    public BatchJmsMessage setBatchWorkType(String workType) throws JMSException {
        this.message.setStringProperty("com_ibm_ws_batch_work_type", workType);
        return this;
    }

    public String getBatchWorkType() throws JMSException {
        return this.message.getStringProperty("com_ibm_ws_batch_work_type");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.jms.internal.BatchJmsMessage", BatchJmsMessage.class, (String)"wsbatch", null);
    }
}

