/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jfap.inbound.channel.CommsServerServiceFacade;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsEngineComponentWithEventListener;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.comms.ClientComponentHandshake;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.CompHandshake;
import com.ibm.ws.sib.comms.ConnectionMetaData;
import com.ibm.ws.sib.comms.ConnectionProperties;
import com.ibm.ws.sib.comms.client.ConnectionMetaDataImpl;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.server.IdToSICoreConnectionTable;
import com.ibm.ws.sib.comms.server.ServerJFapCommunicator;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.ServerTransportAcceptListener;
import com.ibm.ws.sib.jfapchannel.ConnectionClosedListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.mfp.ConnectionSchemaSet;
import com.ibm.ws.sib.mfp.impl.CompHandshakeFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Properties;

public class ServerSideConnection
extends ServerJFapCommunicator
implements ClientConnection,
ConnectionClosedListener {
    private static String CLASS_NAME = ServerSideConnection.class.getName();
    private static final TraceComponent tc = SibTr.register(ServerSideConnection.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    public static final String $sccsid = "@(#) 1.63 SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/ServerSideConnection.java, SIB.comms, WASX.SIB, aa1225.01 10/03/25 10:06:19 [7/2/12 05:59:53]";
    private SICoreConnection conn;
    private boolean conversationClosed = false;
    private static final int NOTIFICATION_TYPE_CLIENT_CONNECT = 1;
    private static final int NOTIFICATION_TYPE_CLIENT_DISCONNECT = 2;
    private static final int NOTIFICATION_TYPE_CLIENT_FAILURE = 3;
    private String connectionUserId = null;
    private final SICoreConnection parentConnection;

    public ServerSideConnection(Conversation conversation) {
        this(conversation, null);
    }

    public ServerSideConnection(Conversation conversation, SICoreConnection parent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"<init>", (Object)("conversation=" + conversation + ", parent=" + parent));
        }
        this.setConversation(conversation);
        conversation.addConnectionClosedListener((ConnectionClosedListener)this, ConversationUsageType.JFAP);
        this.parentConnection = parent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"<init>");
        }
    }

    public SICoreConnection getParentConnection() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getParentConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getParentConnection", (Object)("rc=" + this.parentConnection));
        }
        return this.parentConnection;
    }

    public void connect(ConnectionProperties cp, ClientComponentHandshake cch) throws SIResourceException, SIAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"connect");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"connect");
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_ON_SERVER_SICO2050", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".connect"), (String)"3-002-0002", (Object)((Object)this));
        throw e;
    }

    public void setSICoreConnection(SICoreConnection conn) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSICoreConnection");
        }
        if (this.conn != null && this.conn != conn) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("SICONN_ALREADY_SET_SICO2051", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setSICoreConnection"), (String)"3-002-0003", (Object)((Object)this));
            throw e;
        }
        IdToSICoreConnectionTable idToConnTable = ((ServerLinkLevelState)this.getConversation().getLinkLevelAttachment()).getSICoreConnectionTable();
        idToConnTable.add(this.getConversation().getId(), conn);
        this.conn = conn;
        this.emitNotification(1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSICoreConnection");
        }
    }

    public SICoreConnection getSICoreConnection() throws SIConnectionLostException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSICoreConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSICoreConnection");
        }
        return this.conn;
    }

    public byte[] trmHandshakeExchange(byte[] data) throws SIConnectionLostException, SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"trmHandshakeExchange");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"trmHandshakeExchange");
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_ON_SERVER_SICO2052", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".trmHandshakeExchange"), (String)"3-002-0004", (Object)((Object)this));
        throw e;
    }

    public byte[] mfpHandshakeExchange(byte[] data) throws SIConnectionLostException, SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"mfpHandshakeExchange");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"mfpHandshakeExchange");
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_ON_SERVER_SICO2053", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".mfpHandshakeExchange"), (String)"3-002-0005", (Object)((Object)this));
        throw e;
    }

    public void sendMFPSchema(byte[] schemaData) throws SIConnectionLostException, SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendMFPSchema");
        }
        CommsByteBuffer data = this.getCommsByteBuffer();
        data.wrap(schemaData);
        this.jfapSend(data, 230, 12, true, Conversation.ThrottlingPolicy.BLOCK_THREAD);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendMFPSchema");
        }
    }

    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"close");
        }
        this.close(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean reset) {
        block11: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"close", (Object)("reset=" + reset));
            }
            ServerSideConnection serverSideConnection = this;
            synchronized (serverSideConnection) {
                if (!this.conversationClosed) {
                    this.emitNotification(2);
                }
                this.conversationClosed = true;
            }
            if (!reset) {
                ServerTransportAcceptListener.getInstance().removeConversation(this.getConversation());
                try {
                    if (this.getConversation().getHandshakeProperties().getFapLevel() >= 9) {
                        this.getConversation().fastClose();
                    } else {
                        this.getConversation().close();
                    }
                }
                catch (SIConnectionLostException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".close"), (String)"3-002-0001", (Object)((Object)this));
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                    SibTr.debug((TraceComponent)tc, (String)"Unable to close conversation", (Object)((Object)e));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public String getConnectionInfo() {
        return null;
    }

    public ConnectionMetaData getMetaData() {
        return new ConnectionMetaDataImpl(this.getConversation().getMetaData(), this.getConversation().getHandshakeProperties());
    }

    public void connectionClosed(Object connectionReference) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"connectionClosed", (Object)connectionReference);
            }
            ServerTransportAcceptListener.getInstance().removeAllConversations(connectionReference);
            try {
                CompHandshake ch = (CompHandshake)CompHandshakeFactory.getInstance();
                ch.compClose((CommsConnection)this);
            }
            catch (Exception e1) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                SibTr.debug((TraceComponent)tc, (String)"MFP unable to create CompHandshake Singleton", (Object)e1);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"connectionClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"failed");
        }
        ServerSideConnection serverSideConnection = this;
        synchronized (serverSideConnection) {
            if (!this.conversationClosed) {
                this.emitNotification(3);
            }
            this.conversationClosed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"failed");
        }
    }

    public byte[] requestMFPSchemata(byte[] schemaData) throws SIConnectionLostException, SIConnectionDroppedException, SIConnectionUnavailableException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestMFPSchemata", (Object)schemaData);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestMFPSchemata", null);
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("INVALID_METHOD_ON_SERVER_SICO2053", null, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".mfpHandshakeExchange"), (String)"3-002-0007", (Object)((Object)this));
        throw e;
    }

    private JsMessagingEngine findJsMessagingEngineByName(String meName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"findJsMessagingEngineByName", (Object)meName);
        }
        JsMessagingEngine result = null;
        JsAdminService adminService = null;
        Enumeration vEnum = null;
        adminService = CommsServerServiceFacade.getJsAdminService();
        if (adminService != null) {
            vEnum = adminService.listMessagingEngines();
        }
        while (vEnum != null && vEnum.hasMoreElements() && result == null) {
            JsMessagingEngine me = (JsMessagingEngine)vEnum.nextElement();
            if (!me.getName().equals(meName)) continue;
            result = me;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"findJsMessagingEngineByName", result);
        }
        return result;
    }

    private void emitNotification(int notificationType) {
        block13: {
            String meName;
            JsMessagingEngine engine;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"emitNotification", (Object)("" + notificationType));
            }
            if (this.conn != null && (engine = this.findJsMessagingEngineByName(meName = this.conn.getMeName())) != null && engine.isEventNotificationEnabled()) {
                try {
                    Properties properties = new Properties();
                    String notification = null;
                    String nlsText = null;
                    if (this.connectionUserId == null) {
                        this.connectionUserId = this.conn.getResolvedUserid();
                    }
                    properties.put("client.userid", this.connectionUserId);
                    switch (notificationType) {
                        case 1: {
                            notification = "SIB.client.connection.start";
                            properties.put("fap.type", "JFAP");
                            InetAddress inetAddress = this.getConversation().getMetaData().getRemoteAddress();
                            String addressStr = inetAddress == null ? "0.0.0.0" : inetAddress.getHostAddress();
                            nlsText = nls.getFormattedMessage("CLIENT_CONNECTED_SICO8015", new Object[]{this.connectionUserId, addressStr}, null);
                            properties.put("communications.address", addressStr);
                            break;
                        }
                        case 2: {
                            notification = "SIB.client.connection.stop";
                            nlsText = nls.getFormattedMessage("CLIENT_DISCONNECTED_SICO8016", new Object[]{this.connectionUserId}, null);
                            properties.put("stop.reason", "client.shutdown");
                            break;
                        }
                        case 3: {
                            notification = "SIB.client.connection.stop";
                            nlsText = nls.getFormattedMessage("CLIENT_DISCONNECTED_SICO8016", new Object[]{this.connectionUserId}, null);
                            properties.put("stop.reason", "communications.failure");
                            break;
                        }
                        default: {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"unknown notification type");
                            }
                            throw new SIErrorException("Unknown notification type");
                        }
                    }
                    RuntimeEventListener eventListener = ((JsEngineComponentWithEventListener)engine.getMessageProcessor()).getRuntimeEventListener();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Issuing event notification on engine: " + engine + "\nnotification: " + notification + "\nproperties: " + properties));
                    }
                    eventListener.runtimeEventOccurred(engine, notification, nlsText, properties);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".emitNotification"), (String)"3-002-0008", (Object)((Object)this));
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block13;
                    SibTr.exception((Object)((Object)this), (TraceComponent)tc, (Exception)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"emitNotification");
        }
    }

    public void setSchemaSet(ConnectionSchemaSet schemaSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"setSchemaSet", (Object)schemaSet);
        }
        this.getConversation().setSchemaSet(schemaSet);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"setSchemaSet");
        }
    }

    public ConnectionSchemaSet getSchemaSet() throws SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getSchemaSet");
        }
        ConnectionSchemaSet result = this.getConversation().getSchemaSet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getSchemaSet", (Object)result);
        }
        return result;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.63 SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/ServerSideConnection.java, SIB.comms, WASX.SIB, aa1225.01 10/03/25 10:06:19 [7/2/12 05:59:53]");
        }
    }
}

