/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.rest.internal.resources;

import com.ibm.jbatch.container.ws.BatchJobNotLocalException;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSJobRepository;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jbatch.joblog.JobExecutionLog;
import com.ibm.ws.jbatch.joblog.services.IJobLogManagerService;
import com.ibm.ws.jbatch.rest.BatchManager;
import com.ibm.ws.jbatch.rest.internal.BatchNoSuchJobExecutionException;
import com.ibm.ws.jbatch.rest.internal.BatchRequestUtil;
import com.ibm.ws.jbatch.rest.internal.ZipHelper;
import com.ibm.ws.jbatch.rest.internal.resources.RequestException;
import com.ibm.ws.jbatch.rest.internal.resources.RequestHandler;
import com.ibm.ws.jbatch.rest.internal.resources.RequestRouter;
import com.ibm.ws.jbatch.rest.utils.BatchJSONHelper;
import com.ibm.ws.jbatch.rest.utils.JobRestartModel;
import com.ibm.ws.jbatch.rest.utils.StringUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.JobExecution;
import javax.net.ssl.HttpsURLConnection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.root=/batch/jobexecutions", "com.ibm.wsspi.rest.handler.root=/batch/jobexecutions/{jobexecutionid}", "com.ibm.wsspi.rest.handler.root=/batch/jobexecutions/{jobexecutionid}/jobinstance", "com.ibm.wsspi.rest.handler.root=/batch/jobexecutions/{jobexecutionid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/jobinstances/{jobinstanceid}/jobexecutions", "com.ibm.wsspi.rest.handler.root=/batch/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}", "com.ibm.wsspi.rest.handler.root=/batch/jobinstances/{jobinstanceid}/jobexecnum/{jobexecutionnumber}", "com.ibm.wsspi.rest.handler.root=/batch/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobexecutions/{jobexecutionid}", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobexecutions/{jobexecutionid}/jobinstance", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobexecutions/{jobexecutionid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobinstances/{jobinstanceid}/jobexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobinstances/{jobinstanceid}/jobexecnum/{jobexecutionnumber}", "com.ibm.wsspi.rest.handler.root=/batch/v1/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobexecutions/{jobexecutionid}", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobexecutions/{jobexecutionid}/jobinstance", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobexecutions/{jobexecutionid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobinstances/{jobinstanceid}/jobexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobinstances/{jobinstanceid}/jobexecnum/{jobexecutionnumber}", "com.ibm.wsspi.rest.handler.root=/batch/v2/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobexecutions/{jobexecutionid}", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobexecutions/{jobexecutionid}/jobinstance", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobexecutions/{jobexecutionid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobinstances/{jobinstanceid}/jobexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobinstances/{jobinstanceid}/jobexecnum/{jobexecutionnumber}", "com.ibm.wsspi.rest.handler.root=/batch/v3/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobexecutions/{jobexecutionid}", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobexecutions/{jobexecutionid}/jobinstance", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobexecutions/{jobexecutionid}/joblogs", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobinstances/{jobinstanceid}/jobexecutions", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobinstances/{jobinstanceid}/jobexecnum/{jobexecutionnumber}", "com.ibm.wsspi.rest.handler.root=/batch/v4/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionid}/joblogs", "com.ibm.wsspi.rest.handler.custom.security=true"})
public class JobExecutions
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(JobExecutions.class, (String)"wsbatch", (String)"com.ibm.ws.jbatch.rest.resources.RESTMessages");
    private WSJobRepository jobRepository;
    private BatchManager batchManager;
    private IJobLogManagerService jobLogManagerService;
    private RequestRouter requestRouter = new RequestRouter().addHandler(new JobExecutionsHandler().setPath("/batch/jobexecutions")).addHandler(new JobInstanceJobExecutionsHandler().setPath("/batch/jobinstances/*/jobexecutions")).addHandler(new JobExecutionHandler().setPath("/batch/jobexecutions/*")).addHandler(new JobExecutionJobExecNumberHandler().setPath("/batch/jobinstances/*/jobexecutions/*")).addHandler(new JobExecutionJobExecNumberHandler().setPath("/batch/jobinstances/*/jobexecnum/*")).addHandler(new JobInstanceHandler().setPath("/batch/jobexecutions/*/jobinstance")).addHandler(new JobInstanceHandler().setPath("/batch/jobinstances/*/jobexecutions/*/jobinstance")).addHandler(new JobLogsHandler().setPath("/batch/jobexecutions/*/joblogs")).addHandler(new JobLogsHandler().setPath("/batch/jobinstances/*/jobexecutions/*/joblogs")).addHandler(new JobExecutionsHandler().setPath("/batch/v1/jobexecutions")).addHandler(new JobInstanceJobExecutionsHandler().setPath("/batch/v1/jobinstances/*/jobexecutions")).addHandler(new JobExecutionHandler().setPath("/batch/v1/jobexecutions/*")).addHandler(new JobExecutionJobExecNumberHandler().setPath("/batch/v1/jobinstances/*/jobexecutions/*")).addHandler(new JobExecutionJobExecNumberHandler().setPath("/batch/v1/jobinstances/*/jobexecnum/*")).addHandler(new JobInstanceHandler().setPath("/batch/v1/jobexecutions/*/jobinstance")).addHandler(new JobInstanceHandler().setPath("/batch/v1/jobinstances/*/jobexecutions/*/jobinstance")).addHandler(new JobLogsHandler().setPath("/batch/v1/jobexecutions/*/joblogs")).addHandler(new JobLogsHandler().setPath("/batch/v1/jobinstances/*/jobexecutions/*/joblogs")).addHandler(new JobExecutionsHandler().setPath("/batch/v2/jobexecutions")).addHandler(new JobInstanceJobExecutionsHandler().setPath("/batch/v2/jobinstances/*/jobexecutions")).addHandler(new JobExecutionHandler().setPath("/batch/v2/jobexecutions/*")).addHandler(new JobExecutionJobExecNumberHandler().setPath("/batch/v2/jobinstances/*/jobexecutions/*")).addHandler(new JobExecutionJobExecNumberHandler().setPath("/batch/v2/jobinstances/*/jobexecnum/*")).addHandler(new JobInstanceHandler().setPath("/batch/v2/jobexecutions/*/jobinstance")).addHandler(new JobInstanceHandler().setPath("/batch/v2/jobinstances/*/jobexecutions/*/jobinstance")).addHandler(new JobLogsHandler().setPath("/batch/v2/jobexecutions/*/joblogs")).addHandler(new JobLogsHandler().setPath("/batch/v2/jobinstances/*/jobexecutions/*/joblogs")).addHandler(new JobExecutionsHandler().setPath("/batch/v3/jobexecutions")).addHandler(new JobInstanceJobExecutionsHandler().setPath("/batch/v3/jobinstances/*/jobexecutions")).addHandler(new JobExecutionHandler().setPath("/batch/v3/jobexecutions/*")).addHandler(new JobExecutionJobExecNumberHandler().setPath("/batch/v3/jobinstances/*/jobexecutions/*")).addHandler(new JobExecutionJobExecNumberHandler().setPath("/batch/v3/jobinstances/*/jobexecnum/*")).addHandler(new JobInstanceHandler().setPath("/batch/v3/jobexecutions/*/jobinstance")).addHandler(new JobInstanceHandler().setPath("/batch/v3/jobinstances/*/jobexecutions/*/jobinstance")).addHandler(new JobLogsHandler().setPath("/batch/v3/jobexecutions/*/joblogs")).addHandler(new JobLogsHandler().setPath("/batch/v3/jobinstances/*/jobexecutions/*/joblogs")).addHandler(new JobExecutionsHandler().setPath("/batch/v4/jobexecutions")).addHandler(new JobInstanceJobExecutionsHandler().setPath("/batch/v4/jobinstances/*/jobexecutions")).addHandler(new JobExecutionHandler().setPath("/batch/v4/jobexecutions/*")).addHandler(new JobExecutionJobExecNumberHandler().setPath("/batch/v4/jobinstances/*/jobexecutions/*")).addHandler(new JobExecutionJobExecNumberHandler().setPath("/batch/v4/jobinstances/*/jobexecnum/*")).addHandler(new JobInstanceHandler().setPath("/batch/v4/jobexecutions/*/jobinstance")).addHandler(new JobInstanceHandler().setPath("/batch/v4/jobinstances/*/jobexecutions/*/jobinstance")).addHandler(new JobLogsHandler().setPath("/batch/v4/jobexecutions/*/joblogs")).addHandler(new JobLogsHandler().setPath("/batch/v4/jobinstances/*/jobexecutions/*/joblogs"));
    static final long serialVersionUID = 7192400234716190155L;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWSJobRepository(WSJobRepository ref) {
        this.jobRepository = ref;
    }

    protected void unsetWSJobRepository(WSJobRepository ref) {
        if (this.jobRepository == ref) {
            this.jobRepository = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setBatchManager(BatchManager ref) {
        this.batchManager = ref;
    }

    protected void unsetBatchManager(BatchManager ref) {
        if (this.batchManager == ref) {
            this.batchManager = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setIJobLogManagerService(IJobLogManagerService jobLogManagerService) {
        this.jobLogManagerService = jobLogManagerService;
    }

    protected void unsetIJobLogManagerService(IJobLogManagerService jobLogManagerService) {
        if (this.jobLogManagerService == jobLogManagerService) {
            this.jobLogManagerService = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        try {
            BatchRuntime.getJobOperator();
            this.requestRouter.routeRequest(request, response);
        }
        catch (JobSecurityException jobSecurityException) {
            void jse;
            FFDCFilter.processException((Throwable)jobSecurityException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"263", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(401, jse.getMessage());
        }
        catch (BatchNoSuchJobExecutionException jse) {
            void bnsje;
            FFDCFilter.processException((Throwable)((Object)jse), (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"265", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(400, "Job execution " + bnsje.getJobExecutionId() + " not found.");
        }
        catch (Exception bnsje) {
            void e;
            FFDCFilter.processException((Throwable)bnsje, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"267", (Object)this, (Object[])new Object[]{request, response});
            response.sendError(500, e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected long getJobInstanceId(RESTRequest request) throws RequestException {
        String s = request.getPathVariable("jobinstanceid");
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            void nfe;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"541", (Object)this, (Object[])new Object[]{request});
            throw new RequestException(400, "The job instance id (" + s + ") must be a Long integer", (Exception)nfe);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected long getJobExecutionId(RESTRequest request) throws RequestException {
        String s = request.getPathVariable("jobexecutionid");
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            void nfe;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"557", (Object)this, (Object[])new Object[]{request});
            throw new RequestException(400, "The job execution id (" + s + ") must be a Long integer", (Exception)nfe);
        }
    }

    private void getJobInstanceJobExecutions(RESTRequest request, RESTResponse response, long jobInstanceId) throws IOException {
        response.setContentType("application/json; charset=UTF-8");
        BatchRequestUtil.addExtraResponseHeaders(response);
        ArrayList<WSJobExecution> jobExecutionList = new ArrayList<WSJobExecution>();
        HashMap<Long, List<WSStepThreadExecutionAggregate>> jobExecStepExecListMap = new HashMap<Long, List<WSStepThreadExecutionAggregate>>();
        for (WSJobExecution jobExec : this.jobRepository.getJobExecutionsFromInstance(jobInstanceId)) {
            jobExecutionList.add(jobExec);
            jobExecStepExecListMap.put(jobExec.getExecutionId(), this.jobRepository.getStepExecutionAggregatesFromJobExecution(jobExec.getExecutionId()));
        }
        BatchJSONHelper.writeJobExecutionList(jobExecutionList, jobExecStepExecListMap, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
    }

    private void getJobExecutionData(RESTRequest request, RESTResponse response, long jobExecutionId) throws IOException, RequestException {
        String instanceIdString = request.getPathVariable("jobinstanceid");
        Long instanceId = null;
        try {
            if (instanceIdString != null) {
                instanceId = Long.parseLong(instanceIdString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"602", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
            throw new RequestException(400, "The job instance id must be a Long integer.");
        }
        WSJobExecution jobExec = null;
        try {
            jobExec = this.jobRepository.getJobExecution(jobExecutionId);
            if (instanceId != null && !this.execIdMapsToInstanceId(jobExecutionId, instanceId)) {
                throw new RequestException(400, "The job execution id " + jobExecutionId + " does not map to job instance id " + instanceId + ".");
            }
            response.setContentType("application/json; charset=UTF-8");
            BatchRequestUtil.addExtraResponseHeaders(response);
            List stepExecAggregateList = this.jobRepository.getStepExecutionAggregatesFromJobExecution(jobExecutionId);
            BatchJSONHelper.writeJobExecution(jobExec, stepExecAggregateList, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
        }
        catch (NoSuchJobExecutionException stepExecAggregateList) {
            FFDCFilter.processException((Throwable)stepExecAggregateList, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"625", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
            throw new RequestException(400, "Job execution " + jobExecutionId + " not found.");
        }
    }

    private void getJobInstanceData(RESTRequest request, RESTResponse response, long jobExecutionId) throws IOException, RequestException {
        try {
            response.setContentType("application/json; charset=UTF-8");
            BatchRequestUtil.addExtraResponseHeaders(response);
            BatchJSONHelper.writeJobInstance(this.jobRepository.getJobInstanceFromExecution(jobExecutionId), BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
        }
        catch (NoSuchJobExecutionException noSuchJobExecutionException) {
            FFDCFilter.processException((Throwable)noSuchJobExecutionException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"647", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
            throw new RequestException(400, "A job with job execution id " + jobExecutionId + " does not exist.");
        }
    }

    @FFDCIgnore(value={BatchJobNotLocalException.class})
    protected void stopJobExecution(RESTRequest request, RESTResponse response, long jobExecutionId) throws IOException, RequestException {
        try {
            this.batchManager.stopJobExecution(jobExecutionId);
            response.setContentType("application/json; charset=UTF-8");
            BatchRequestUtil.addExtraResponseHeaders(response);
            List stepExecAggregateList = this.jobRepository.getStepExecutionAggregatesFromJobExecution(jobExecutionId);
            BatchJSONHelper.writeJobExecution(this.jobRepository.getJobExecution(jobExecutionId), stepExecAggregateList, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
        }
        catch (JobExecutionNotRunningException stepExecAggregateList) {
            FFDCFilter.processException((Throwable)stepExecAggregateList, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"675", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
            response.sendError(409, "The job execution id " + jobExecutionId + " is not currently running.");
        }
        catch (NoSuchJobExecutionException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"677", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
            response.sendError(400, "A job with job execution id " + jobExecutionId + " does not exist.");
        }
        catch (BatchJobNotLocalException e) {
            BatchRequestUtil.handleNonLocalRequest(BatchRequestUtil.buildStopUrl((JobExecution)e.getJobExecution(), null), "PUT", request, response);
        }
    }

    protected void restartJobExecution(RESTRequest request, RESTResponse response, long jobExecutionId) throws IOException, RequestException {
        Properties jobParams = BatchRequestUtil.getContentLength(request) > 0 ? new JobRestartModel(BatchJSONHelper.readJsonObject(request.getInputStream())).getJobParameters() : null;
        jobParams = "true".equalsIgnoreCase(request.getParameter("reusePreviousParams")) ? BatchJSONHelper.mergeProperties(this.jobRepository.getJobExecution(jobExecutionId).getJobParameters(), jobParams) : jobParams;
        try {
            WSJobInstance jobInstance = this.batchManager.restartJobExecution(jobExecutionId, jobParams);
            response.setContentType("application/json; charset=UTF-8");
            BatchRequestUtil.addExtraResponseHeaders(response);
            BatchJSONHelper.writeJobInstance(jobInstance, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
        }
        catch (NoSuchJobExecutionException jobInstance) {
            FFDCFilter.processException((Throwable)jobInstance, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"717", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
            response.sendError(400, "The job execution id " + jobExecutionId + " does not exist.");
        }
        catch (JobExecutionAlreadyCompleteException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"719", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
            response.sendError(409, "The job execution id " + jobExecutionId + " is already completed.");
        }
        catch (JobExecutionNotMostRecentException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"721", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
            response.sendError(400, "The job execution id " + jobExecutionId + " is not the most recent execution.");
        }
        catch (JobRestartException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"723", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
            response.sendError(409, "The job execution id " + jobExecutionId + " could not be restarted.");
        }
    }

    private boolean execIdMapsToInstanceId(Long execId, Long instanceId) {
        WSJobInstance actualJobInstance = this.jobRepository.getJobInstanceFromExecution(execId.longValue());
        return actualJobInstance.getInstanceId() == instanceId.longValue();
    }

    private void getJobExecutionDataByJobExecNumber(RESTRequest request, RESTResponse response, long jobInstanceId, short jobExecutionNum) throws IOException, RequestException {
        WSJobExecution jobExec = null;
        try {
            jobExec = this.jobRepository.getJobExecutionFromJobExecNum(jobInstanceId, (int)jobExecutionNum);
            response.setContentType("application/json; charset=UTF-8");
            BatchRequestUtil.addExtraResponseHeaders(response);
            List stepExecAggregateList = this.jobRepository.getStepExecutionAggregatesFromJobExecution(jobExec.getExecutionId());
            BatchJSONHelper.writeJobExecution(jobExec, stepExecAggregateList, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
        }
        catch (NoSuchJobExecutionException stepExecAggregateList) {
            FFDCFilter.processException((Throwable)stepExecAggregateList, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"761", (Object)this, (Object[])new Object[]{request, response, jobInstanceId, jobExecutionNum});
            throw new RequestException(400, "Job instance " + jobInstanceId + " and job execution number " + jobExecutionNum + " not found.");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected short getJobExecutionNum(RESTRequest request) throws RequestException {
        String s = request.getPathVariable("jobexecutionnumber");
        try {
            return Short.parseShort(s);
        }
        catch (NumberFormatException numberFormatException) {
            void nfe;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions", (String)"779", (Object)this, (Object[])new Object[]{request});
            throw new RequestException(400, "The job execution number (" + s + ") must be a Short integer", (Exception)nfe);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobExecutionsHandler
    extends RequestHandler {
        static final long serialVersionUID = 8629124312242924497L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobExecutionsHandler() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions$JobExecutionsHandler", JobExecutionsHandler.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobInstanceJobExecutionsHandler
    extends RequestHandler {
        static final long serialVersionUID = -3175765594406027696L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobInstanceJobExecutionsHandler() {
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            JobExecutions.this.getJobInstanceJobExecutions(request, response, JobExecutions.this.getJobInstanceId(request));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions$JobInstanceJobExecutionsHandler", JobInstanceJobExecutionsHandler.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobExecutionHandler
    extends RequestHandler {
        static final long serialVersionUID = -5220271644293679433L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobExecutionHandler() {
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            JobExecutions.this.getJobExecutionData(request, response, JobExecutions.this.getJobExecutionId(request));
        }

        @Override
        public void put(RESTRequest request, RESTResponse response) throws Exception {
            String action = request.getParameter("action");
            if ("stop".equalsIgnoreCase(action)) {
                JobExecutions.this.stopJobExecution(request, response, JobExecutions.this.getJobExecutionId(request));
            } else if ("restart".equalsIgnoreCase(action)) {
                JobExecutions.this.restartJobExecution(request, response, JobExecutions.this.getJobExecutionId(request));
            } else {
                response.sendError(400, "Invalid HTTP query parameters: only action=stop and action=restart are supported.");
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions$JobExecutionHandler", JobExecutionHandler.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobExecutionJobExecNumberHandler
    extends RequestHandler {
        static final long serialVersionUID = -121179899059096287L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobExecutionJobExecNumberHandler() {
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            JobExecutions.this.getJobExecutionDataByJobExecNumber(request, response, JobExecutions.this.getJobInstanceId(request), JobExecutions.this.getJobExecutionNum(request));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions$JobExecutionJobExecNumberHandler", JobExecutionJobExecNumberHandler.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobInstanceHandler
    extends RequestHandler {
        static final long serialVersionUID = 5921008557777430459L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobInstanceHandler() {
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            JobExecutions.this.getJobInstanceData(request, response, JobExecutions.this.getJobExecutionId(request));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions$JobInstanceHandler", JobInstanceHandler.class, (String)"wsbatch", null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class JobLogsHandler
    extends RequestHandler {
        static final long serialVersionUID = -7689048687701781933L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JobLogsHandler() {
        }

        @Override
        public void get(RESTRequest request, RESTResponse response) throws Exception {
            this.getJobLog(request, response, JobExecutions.this.getJobExecutionId(request));
        }

        protected void getJobLog(RESTRequest request, RESTResponse response, long jobExecutionId) throws Exception {
            try {
                JobExecutionLog jobExecutionLog = JobExecutions.this.jobLogManagerService.getJobExecutionLog(jobExecutionId);
                boolean localOnly = "true".equals(request.getParameter("localOnly"));
                if (localOnly || jobExecutionLog.getLocalState() == JobExecutionLog.LogLocalState.EXECUTION_LOCAL) {
                    if (!StringUtils.isEmpty(request.getParameter("part"))) {
                        this.sendJobExecutionLogPart(jobExecutionLog, request, response);
                    } else {
                        this.sendJobExecutionLog(jobExecutionLog, request, response);
                    }
                } else {
                    BatchRequestUtil.handleNonLocalRequest(BatchRequestUtil.buildJoblogsUrl(jobExecutionLog.getJobExecution(), null, request.getQueryString()), "GET", request, response);
                }
            }
            catch (NoSuchJobExecutionException jobExecutionLog) {
                FFDCFilter.processException((Throwable)jobExecutionLog, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions$JobLogsHandler", (String)"373", (Object)this, (Object[])new Object[]{request, response, jobExecutionId});
                throw new RequestException(400, "A job with job execution id " + jobExecutionId + " does not exist.");
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void sendJobExecutionLog(JobExecutionLog jobExecutionLog, RESTRequest request, RESTResponse response) throws IOException {
            if ("zip".equals(request.getParameter("type"))) {
                ZipOutputStream zipOutput = new ZipOutputStream(response.getOutputStream());
                response.setContentType("application/zip");
                response.setResponseHeader("Content-Disposition", "attachment; filename=" + StringUtils.enquote(this.getZipFileName(jobExecutionLog)));
                BatchRequestUtil.addExtraResponseHeaders(response);
                if (jobExecutionLog.getRemotePartitionLogs() != null && !"true".equals(request.getParameter("localOnly"))) {
                    HashSet partitionEndpointURLs = jobExecutionLog.getRemotePartitionEndpointURLs();
                    partitionEndpointURLs.remove(BatchRequestUtil.getUrlRoot(request));
                    for (String url : partitionEndpointURLs) {
                        String joblogUrl = BatchRequestUtil.buildJoblogsUrl(url, jobExecutionLog.getExecutionId()) + "?type=zip&localOnly=true";
                        try {
                            HttpsURLConnection conn = BatchRequestUtil.sendRESTRequest(joblogUrl, "GET", request, null);
                            if (conn == null) continue;
                            ZipInputStream zipStream = new ZipInputStream(conn.getInputStream());
                            ZipHelper.copyZipEntries(zipStream, zipOutput);
                        }
                        catch (Exception conn) {
                            void ex;
                            FFDCFilter.processException((Throwable)conn, (String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions$JobLogsHandler", (String)"413", (Object)this, (Object[])new Object[]{jobExecutionLog, request, response});
                            Tr.debug((TraceComponent)tc, (String)("Exception occurred fetching remote partition logs from " + joblogUrl + ", exception details: " + ex.getClass().getName() + ": " + ex.getLocalizedMessage()), (Object[])new Object[0]);
                        }
                    }
                }
                ZipHelper.zipFilesToStream((List<File>)jobExecutionLog.getJobLogFiles(), jobExecutionLog.getExecLogRootDir(), (OutputStream)zipOutput);
            } else if ("text".equals(request.getParameter("type"))) {
                response.setContentType("text/plain; charset=UTF-8");
                BatchRequestUtil.addExtraResponseHeaders(response);
                ZipHelper.aggregateFilesToStream((List<File>)jobExecutionLog.getJobLogFiles(), jobExecutionLog.getExecLogRootDir(), response.getOutputStream());
                if (jobExecutionLog.getRemotePartitionLogs() != null && !"true".equals(request.getParameter("localOnly"))) {
                    HashSet partitionEndpointURLs = jobExecutionLog.getRemotePartitionEndpointURLs();
                    partitionEndpointURLs.remove(BatchRequestUtil.getUrlRoot(request));
                    for (String url : partitionEndpointURLs) {
                        int len;
                        HttpsURLConnection conn = BatchRequestUtil.sendRESTRequest(BatchRequestUtil.buildJoblogsUrl(url, jobExecutionLog.getExecutionId()) + "?type=text&localOnly=true", "GET", request, null);
                        byte[] buf = new byte[1024];
                        while ((len = conn.getInputStream().read(buf)) != -1) {
                            response.getOutputStream().write(buf, 0, len);
                        }
                    }
                }
            } else {
                response.setContentType("application/json; charset=UTF-8");
                BatchRequestUtil.addExtraResponseHeaders(response);
                BatchJSONHelper.writeJobExecutionLogLinks(jobExecutionLog, BatchRequestUtil.getUrlRoot(request), response.getOutputStream());
            }
        }

        protected void sendJobExecutionLogPart(JobExecutionLog jobExecutionLog, RESTRequest request, RESTResponse response) throws IOException, RequestException {
            String part = request.getParameter("part");
            File jobLogFile = jobExecutionLog.getPartByRelativePath(part);
            if (jobLogFile == null) {
                throw new RequestException(400, "The job log part " + part + " does not exist for job execution " + jobExecutionLog.getExecutionId() + ".");
            }
            if ("zip".equals(request.getParameter("type"))) {
                response.setContentType("application/zip");
                response.setResponseHeader("Content-Disposition", "attachment; filename=" + StringUtils.enquote(this.getZipFileName(jobExecutionLog, request.getParameter("part"))));
                BatchRequestUtil.addExtraResponseHeaders(response);
                ZipHelper.zipFileToStream(jobLogFile, jobExecutionLog.getExecLogRootDir(), response.getOutputStream());
            } else {
                response.setContentType("text/plain; charset=UTF-8");
                BatchRequestUtil.addExtraResponseHeaders(response);
                ZipHelper.copyStream(new FileInputStream(jobLogFile), response.getOutputStream());
            }
        }

        protected String getZipFileName(JobExecutionLog jobExecutionLog) {
            return "joblogs.execution." + jobExecutionLog.getExecutionId() + ".zip";
        }

        protected String getZipFileName(JobExecutionLog jobExecutionLog, String relativePartPath) {
            return "joblogs.execution." + jobExecutionLog.getExecutionId() + "." + relativePartPath.replaceAll("\\\\", ".").replaceAll("/", ".") + ".zip";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.rest.internal.resources.JobExecutions$JobLogsHandler", JobLogsHandler.class, (String)"wsbatch", null);
        }
    }
}

