/*
 * Decompiled with CFR 0.152.
 */
package graphql.com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import graphql.com.google.common.base.Preconditions;
import graphql.com.google.common.collect.AbstractIterator;
import graphql.com.google.common.collect.ElementTypesAreNonnullByDefault;
import jakarta.annotation.CheckForNull;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    protected T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

