/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.domain.model;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import io.narayana.lra.Current;
import io.narayana.lra.RequestBuilder;
import io.narayana.lra.ResponseHolder;
import io.narayana.lra.coordinator.domain.model.LRARecord;
import io.narayana.lra.coordinator.domain.model.LRAStatusHolder;
import io.narayana.lra.coordinator.domain.model.Transaction;
import io.narayana.lra.coordinator.domain.service.LRAService;
import io.narayana.lra.logging.LRALogger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class LRARecord
extends AbstractRecord
implements Comparable<AbstractRecord> {
    private static final String TYPE_NAME = "/StateManager/AbstractRecord/LRARecord";
    private static final String COMPENSATE_REL = "compensate";
    private static final String COMPLETE_REL = "complete";
    private URI lraId;
    private URI parentId;
    private URI recoveryURI;
    private String participantPath;
    private URI completeURI;
    private URI compensateURI;
    private URI statusURI;
    private URI forgetURI;
    private URI afterURI;
    private String responseData;
    private String compensatorData;
    private LRAService lraService;
    private ParticipantStatus status;
    private boolean accepted;
    private Transaction lra;

    public LRARecord() {
    }

    LRARecord(Transaction lra, LRAService lraService, String lraId, String linkURI, String compensatorData) {
        super(new Uid());
        this.lra = lra;
        try {
            if (linkURI.startsWith("<")) {
                Exception[] parseException = new Exception[]{null};
                Arrays.stream(linkURI.split(",")).forEach(linkStr -> {
                    URISyntaxException e = this.parseLink(linkStr);
                    if (e != null) {
                        parseException[0] = e;
                    }
                });
                if (parseException[0] != null) {
                    throw new WebApplicationException(lraId + ": Invalid link URI: " + parseException[0], Response.Status.BAD_REQUEST);
                }
                if (this.compensateURI == null && this.afterURI == null) {
                    throw new WebApplicationException(lraId + ": Invalid link URI: missing compensator", Response.Status.BAD_REQUEST);
                }
            } else {
                this.compensateURI = new URI(String.format("%s/compensate", linkURI));
                this.completeURI = new URI(String.format("%s/complete", linkURI));
                this.statusURI = new URI(String.format("%s", linkURI));
                this.forgetURI = new URI(String.format("%s", linkURI));
            }
            this.lraId = new URI(lraId);
            this.parentId = lraService.getTransaction(this.lraId).getParentId();
            this.status = ParticipantStatus.Active;
            this.lraService = lraService;
            this.participantPath = linkURI;
            this.recoveryURI = null;
            this.compensatorData = compensatorData;
        }
        catch (URISyntaxException e) {
            LRALogger.i18NLogger.error_invalidFormatToCreateLRARecord(lraId, linkURI);
            throw new WebApplicationException(lraId + ": Invalid LRA id: " + e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    public void setLRA(Transaction lra) {
        this.lra = lra;
        this.parentId = lra.getParentId();
    }

    String getParticipantPath() {
        return this.participantPath;
    }

    static String cannonicalForm(String linkStr) throws URISyntaxException {
        if (!linkStr.contains(">;")) {
            return LRARecord.cannonicalURI((URI)new URI(linkStr)).toASCIIString();
        }
        TreeMap<String, String> lm = new TreeMap<String, String>();
        Arrays.stream(linkStr.split(",")).forEach(link -> lm.put(Link.valueOf((String)link).getRel(), (String)link));
        StringBuilder sb = new StringBuilder();
        lm.forEach((k, v) -> LRARecord.appendLink((StringBuilder)sb, (String)v));
        return sb.toString();
    }

    private static StringBuilder appendLink(StringBuilder b, String value) {
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(value);
    }

    static String extractCompensator(URI lraId, String linkStr) throws URISyntaxException {
        for (String lnk : linkStr.split(",")) {
            Link link;
            try {
                link = Link.valueOf((String)lnk);
            }
            catch (Exception e) {
                throw new WebApplicationException(Response.status((int)Response.Status.PRECONDITION_FAILED.getStatusCode()).entity((Object)String.format("Invalid compensator join request: cannot parse link '%s'", linkStr)).build());
            }
            if (!"compensate".equals(link.getRel())) continue;
            return LRARecord.cannonicalForm((String)link.getUri().toString());
        }
        return linkStr;
    }

    private static URI cannonicalURI(URI uri) throws URISyntaxException {
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath().replaceAll("//", "/"), uri.getQuery(), uri.getFragment());
    }

    private URISyntaxException parseLink(String linkStr) {
        Link link = Link.valueOf((String)linkStr);
        String rel = link.getRel();
        try {
            URI uri = LRARecord.cannonicalURI((URI)link.getUri());
            if ("compensate".equals(rel)) {
                this.compensateURI = uri;
            } else if ("complete".equals(rel)) {
                this.completeURI = uri;
            } else if ("status".equals(rel)) {
                this.statusURI = uri;
            } else if ("after".equals(rel)) {
                this.afterURI = uri;
            } else if ("forget".equals(rel)) {
                this.forgetURI = uri;
            } else if ("participant".equals(rel)) {
                this.compensateURI = new URI(uri.toASCIIString() + "/compensate");
                this.completeURI = new URI(uri.toASCIIString() + "/complete");
                this.statusURI = this.forgetURI = uri;
            }
            return null;
        }
        catch (URISyntaxException e) {
            return e;
        }
    }

    public int topLevelPrepare() {
        return 0;
    }

    public int topLevelAbort() {
        return this.doEnd(this.lra.isCancel());
    }

    public int topLevelOnePhaseCommit() {
        return this.topLevelCommit();
    }

    public int topLevelCommit() {
        return this.doEnd(this.lra.isCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doEnd(boolean compensate) {
        assert (this.lraService != null);
        ReentrantLock lock = this.lraService.lockTransaction(this.lraId);
        try {
            int n = this.tryDoEnd(compensate);
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    private int tryDoEnd(boolean compensate) {
        URI endPath;
        if (this.isFinished()) {
            return this.atEnd(this.status == ParticipantStatus.FailedToComplete || this.status == ParticipantStatus.FailedToCompensate ? 8 : 7);
        }
        if (ParticipantStatus.Compensating.equals((Object)this.status)) {
            compensate = true;
        }
        if (this.compensateURI == null) {
            return this.atEnd(7);
        }
        if (compensate) {
            if (this.isCompensated()) {
                return this.atEnd(7);
            }
            endPath = this.compensateURI;
            this.status = ParticipantStatus.Compensating;
        } else {
            if (this.isCompelete() || this.completeURI == null) {
                this.status = ParticipantStatus.Completed;
                return this.atEnd(7);
            }
            endPath = this.completeURI;
            this.status = ParticipantStatus.Completing;
        }
        int httpStatus = -1;
        if (this.accepted) {
            int twoPhaseOutcome = this.retryGetEndStatus(endPath, compensate);
            if (twoPhaseOutcome != -1) {
                return this.atEnd(twoPhaseOutcome);
            }
        } else {
            httpStatus = this.tryLocalEndInvocation(endPath);
        }
        if (httpStatus == -1) {
            try {
                ResponseHolder response = new RequestBuilder(endPath).request().header("Long-Running-Action", this.lraId.toASCIIString()).header("Long-Running-Action-Parent", this.parentId).header("Long-Running-Action-Recovery", this.recoveryURI.toASCIIString()).async(2L, TimeUnit.SECONDS).put();
                httpStatus = response.getStatus();
                boolean bl = this.accepted = httpStatus == Response.Status.ACCEPTED.getStatusCode();
                if (this.accepted && this.statusURI == null) {
                    this.statusURI = response.getLocationHeaderAsURI();
                }
                if (httpStatus == Response.Status.GONE.getStatusCode()) {
                    this.updateStatus(compensate);
                    return this.atEnd(7);
                }
                if (response.hasEntity()) {
                    this.responseData = response.readEntity();
                }
            }
            catch (Exception e) {
                LRALogger.logger.infof("LRARecord.doEnd put %s failed: %s", (Object)endPath, (Object)e.getMessage());
            }
        }
        if (this.responseData != null && httpStatus == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            try {
                return this.atEnd(this.reportFailure(compensate, endPath, ParticipantStatus.valueOf((String)this.responseData).name()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (httpStatus != Response.Status.OK.getStatusCode() && httpStatus != Response.Status.NO_CONTENT.getStatusCode() && !this.accepted) {
            if (LRALogger.logger.isDebugEnabled()) {
                LRALogger.logger.debugf("LRARecord.doEnd put %s failed with status: %d", (Object)endPath, (Object)httpStatus);
            }
            this.status = compensate ? ParticipantStatus.Compensating : ParticipantStatus.Completing;
            this.accepted = true;
        }
        this.updateStatus(compensate);
        return this.atEnd(this.accepted ? 6 : 7);
    }

    boolean isFinished() {
        if (this.compensateURI == null) {
            return this.afterURI != null;
        }
        switch (1.$SwitchMap$org$eclipse$microprofile$lra$annotation$ParticipantStatus[this.status.ordinal()]) {
            case 1: 
            case 2: {
                return this.parentId == null;
            }
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    boolean isFailed() {
        return this.status == ParticipantStatus.FailedToCompensate || this.status == ParticipantStatus.FailedToComplete;
    }

    private boolean afterLRARequest(URI target, String payload) {
        block6: {
            try {
                ResponseHolder response;
                RequestBuilder builder = new RequestBuilder(target).request().header("Long-Running-Action-Recovery", this.recoveryURI.toASCIIString());
                if (target.equals(this.afterURI)) {
                    builder.header("Long-Running-Action-Ended", this.lra.getId().toASCIIString());
                    if (this.lra.getParentId() != null) {
                        builder.header("Long-Running-Action-Parent", this.lra.getParentId().toASCIIString());
                    }
                } else {
                    builder.header("Long-Running-Action", this.lra.getId().toASCIIString());
                }
                builder.async(2L, TimeUnit.SECONDS);
                ResponseHolder responseHolder = response = target.equals(this.forgetURI) ? builder.delete() : builder.put(payload, "text/plain");
                if (response.getStatus() == 200) {
                    return true;
                }
            }
            catch (WebApplicationException e) {
                if (!LRALogger.logger.isInfoEnabled()) break block6;
                LRALogger.logger.infof("Could not notify URI at %s (%s)", (Object)target, (Object)e.getMessage());
            }
        }
        return false;
    }

    private int atEnd(int res) {
        if (this.parentId != null && (this.status == ParticipantStatus.Completed || this.status == ParticipantStatus.FailedToComplete)) {
            if (this.lraService.getLRA(this.parentId).isActive()) {
                return 6;
            }
            return this.runPostLRAActions();
        }
        if (!this.isFinished() || !this.lra.isFinished()) {
            if (this.afterURI != null) {
                return 6;
            }
            return res;
        }
        return this.runPostLRAActions();
    }

    private int runPostLRAActions() {
        if (this.afterURI == null || this.afterLRARequest(this.afterURI, this.lra.getLRAStatus().name())) {
            this.afterURI = null;
            return 7;
        }
        return 6;
    }

    private void updateStatus(boolean compensate) {
        this.status = compensate ? (this.accepted ? ParticipantStatus.Compensating : ParticipantStatus.Compensated) : (this.accepted ? ParticipantStatus.Completing : ParticipantStatus.Completed);
    }

    private int reportFailure(boolean compensate, URI endPath, String failureReason) {
        this.status = compensate ? ParticipantStatus.FailedToCompensate : ParticipantStatus.FailedToComplete;
        LRALogger.logger.warnf("LRARecord: participant %s reported a failure to %s (cause %s)", (Object)endPath.toASCIIString(), (Object)(compensate ? "compensate" : "complete"), (Object)failureReason);
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int retryGetEndStatus(URI endPath, boolean compensate) {
        assert (this.accepted);
        URI nestedLraId = this.extractParentLRA(endPath);
        if (nestedLraId != null && this.lraService != null) {
            Transaction transaction = this.lraService.getTransaction(nestedLraId);
            if (transaction != null) {
                LRAStatus cStatus = transaction.getLRAStatus();
                if (cStatus == null) {
                    LRALogger.logger.warnf("LRARecord.retryGetEndStatus: local LRA %s accepted but has a null status", (Object)endPath);
                    return -1;
                }
                switch (1.$SwitchMap$org$eclipse$microprofile$lra$annotation$LRAStatus[cStatus.ordinal()]) {
                    case 1: 
                    case 2: {
                        return 7;
                    }
                    case 3: 
                    case 4: {
                        return 6;
                    }
                    case 5: 
                    case 6: {
                        return this.reportFailure(compensate, endPath, "unknown");
                    }
                }
                return 6;
            }
        } else if (this.statusURI != null) {
            try {
                ResponseHolder response = new RequestBuilder(this.statusURI).request().header("Long-Running-Action", this.lraId.toASCIIString()).header("Long-Running-Action-Recovery", this.recoveryURI.toASCIIString()).header("Long-Running-Action-Parent", this.parentId).async(2L, TimeUnit.SECONDS).get();
                if (response.getStatus() == Response.Status.GONE.getStatusCode()) {
                    this.status = compensate ? ParticipantStatus.Compensated : ParticipantStatus.Completed;
                    int cStatus = 7;
                    return cStatus;
                }
                if (response.getStatus() == Response.Status.ACCEPTED.getStatusCode() || Response.Status.Family.familyOf((int)response.getStatus()).equals((Object)Response.Status.Family.SERVER_ERROR)) {
                    int cStatus = 6;
                    return cStatus;
                }
                if (response.getStatus() == Response.Status.OK.getStatusCode() && response.getResponseString() != null) {
                    this.status = ParticipantStatus.valueOf((String)response.getResponseString());
                    switch (1.$SwitchMap$org$eclipse$microprofile$lra$annotation$ParticipantStatus[this.status.ordinal()]) {
                        case 1: 
                        case 3: {
                            int cStatus = 7;
                            return cStatus;
                        }
                        case 5: 
                        case 6: {
                            int cStatus = 6;
                            return cStatus;
                        }
                        case 2: 
                        case 4: {
                            LRALogger.logger.warnf("LRARecord.doEnd(compensate %b) get status %s did not finish: %s: WILL NOT RETRY", (Object)compensate, (Object)endPath, (Object)this.status);
                            if (this.forgetURI != null && !this.forget()) {
                                int cStatus = 6;
                                return cStatus;
                            }
                            int cStatus = this.reportFailure(compensate, endPath, "Unknown");
                            return cStatus;
                        }
                    }
                    int cStatus = 6;
                    return cStatus;
                }
            }
            catch (Throwable e) {
                if (LRALogger.logger.isInfoEnabled()) {
                    LRALogger.logger.infof("LRARecord.doEnd status URI %s is invalid (%s)", (Object)this.statusURI, (Object)e.getMessage());
                }
                int n = 6;
                return n;
            }
            finally {
                Current.pop();
            }
        }
        return -1;
    }

    private Future<Response> getAsyncResponse(WebTarget target, String method, AsyncInvoker asyncInvoker, String compensatorData) {
        String queryString = target.getUri().getQuery();
        if (queryString != null) {
            String[] queries;
            for (String pair : queries = queryString.split("&")) {
                String[] qp;
                if (!pair.contains("=") || !(qp = pair.split("="))[0].equals("method")) continue;
                switch (qp[1]) {
                    case "javax.ws.rs.GET": {
                        return asyncInvoker.get();
                    }
                    case "javax.ws.rs.PUT": {
                        return asyncInvoker.put(Entity.entity((Object)compensatorData, (String)"text/plain"));
                    }
                    case "javax.ws.rs.POST": {
                        return asyncInvoker.post(Entity.entity((Object)compensatorData, (String)"text/plain"));
                    }
                    case "javax.ws.rs.DELETE": {
                        return asyncInvoker.delete();
                    }
                }
            }
        }
        switch (method) {
            case "javax.ws.rs.GET": {
                return asyncInvoker.get();
            }
            case "javax.ws.rs.PUT": {
                return asyncInvoker.put(Entity.entity((Object)compensatorData, (String)"text/plain"));
            }
            case "javax.ws.rs.POST": {
                return asyncInvoker.post(Entity.entity((Object)compensatorData, (String)"text/plain"));
            }
            case "javax.ws.rs.DELETE": {
                return asyncInvoker.delete();
            }
        }
        return asyncInvoker.get();
    }

    private URI extractParentLRA(URI endPath) {
        String[] segments;
        int pCnt;
        if (this.lraService != null && (pCnt = (segments = endPath.getPath().split("/")).length) > 1) {
            try {
                String cId = URLDecoder.decode(segments[pCnt - 2], "UTF-8");
                return this.lraService.hasTransaction(cId) ? new URI(cId) : null;
            }
            catch (UnsupportedEncodingException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private int tryLocalEndInvocation(URI endPath) {
        URI cId = this.extractParentLRA(endPath);
        if (cId != null) {
            int httpStatus;
            String[] segments = endPath.getPath().split("/");
            int pCnt = segments.length;
            boolean isCompensate = "compensate".equals(segments[pCnt - 1]);
            boolean isComplete = "complete".equals(segments[pCnt - 1]);
            if (!isCompensate && !isComplete) {
                if (LRALogger.logger.isInfoEnabled()) {
                    LRALogger.logger.infof("LRARecord.doEnd invalid nested participant url %s(should be compensate or complete)", (Object)endPath.toASCIIString());
                }
                httpStatus = Response.Status.BAD_REQUEST.getStatusCode();
            } else {
                LRAStatusHolder inVMStatus = this.lraService.endLRA(cId, isCompensate, true);
                httpStatus = inVMStatus.getHttpStatus();
                try {
                    this.responseData = inVMStatus.getEncodedResponseData();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return httpStatus;
        }
        return -1;
    }

    boolean forget() {
        block7: {
            if (this.forgetURI != null) {
                try {
                    ResponseHolder response = new RequestBuilder(this.forgetURI).request().header("Long-Running-Action", this.lraId).header("Long-Running-Action-Recovery", this.recoveryURI).header("Long-Running-Action-Parent", this.parentId).async(2L, TimeUnit.SECONDS).delete();
                    if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                        boolean bl = true;
                        return bl;
                    }
                    break block7;
                }
                catch (WebApplicationException e) {
                    LRALogger.logger.infof("LRARecord.forget delete %s failed: %s", (Object)this.forgetURI, (Object)e.getMessage());
                    boolean bl = false;
                    return bl;
                }
                finally {
                    Current.pop();
                }
            }
            LRALogger.logger.warnf("LRARecord.forget() LRA: %s: cannot forget %s: missing forget URI, status: %s", (Object)this.lraId, (Object)this.recoveryURI, (Object)this.status);
        }
        return true;
    }

    private boolean isCompelete() {
        return this.status != null && this.status == ParticipantStatus.Completed;
    }

    private boolean isCompensated() {
        return this.status != null && this.status == ParticipantStatus.Compensated;
    }

    public boolean save_state(OutputObjectState os, int t) {
        if (super.save_state(os, t)) {
            try {
                this.packURI(os, this.lraId);
                this.packURI(os, this.compensateURI);
                this.packURI(os, this.recoveryURI);
                this.packURI(os, this.completeURI);
                this.packURI(os, this.afterURI);
                this.packURI(os, this.statusURI);
                this.packURI(os, this.forgetURI);
                this.packStatus(os);
                os.packString(this.participantPath);
                os.packString(this.compensatorData);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public boolean restore_state(InputObjectState os, int t) {
        if (super.restore_state(os, t)) {
            try {
                this.lraId = this.unpackURI(os);
                this.compensateURI = this.unpackURI(os);
                this.recoveryURI = this.unpackURI(os);
                this.completeURI = this.unpackURI(os);
                this.afterURI = this.unpackURI(os);
                this.statusURI = this.unpackURI(os);
                this.forgetURI = this.unpackURI(os);
                this.unpackStatus(os);
                this.participantPath = os.unpackString();
                this.compensatorData = os.unpackString();
                this.accepted = this.status == ParticipantStatus.Completing || this.status == ParticipantStatus.Compensating;
            }
            catch (IOException | URISyntaxException e) {
                return false;
            }
        }
        return true;
    }

    private void packStatus(OutputObjectState os) throws IOException {
        if (this.status == null) {
            os.packBoolean(false);
        } else {
            os.packBoolean(true);
            os.packInt(this.status.ordinal());
        }
    }

    private void unpackStatus(InputObjectState os) throws IOException {
        this.status = os.unpackBoolean() ? ParticipantStatus.values()[os.unpackInt()] : null;
    }

    private void packURI(OutputObjectState os, URI url) throws IOException {
        if (url == null) {
            os.packBoolean(false);
        } else {
            os.packBoolean(true);
            os.packString(url.toASCIIString());
        }
    }

    private URI unpackURI(InputObjectState os) throws IOException, URISyntaxException {
        return os.unpackBoolean() ? new URI(os.unpackString()) : null;
    }

    private static int getTypeId() {
        return 1;
    }

    public int typeIs() {
        return LRARecord.getTypeId();
    }

    public int nestedAbort() {
        return 7;
    }

    public int nestedCommit() {
        return 7;
    }

    public int nestedPrepare() {
        return 0;
    }

    public int nestedOnePhaseCommit() {
        return 8;
    }

    public String type() {
        return "/StateManager/AbstractRecord/LRARecord";
    }

    public boolean doSave() {
        return true;
    }

    public void merge(AbstractRecord a) {
    }

    public void alter(AbstractRecord a) {
    }

    public boolean shouldAdd(AbstractRecord a) {
        return a.typeIs() == this.typeIs();
    }

    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    public Object value() {
        return null;
    }

    public void setValue(Object o) {
    }

    @Override
    public int compareTo(AbstractRecord other) {
        if (this.lessThan(other)) {
            return -1;
        }
        if (this.greaterThan(other)) {
            return 1;
        }
        return 0;
    }

    public URI getRecoveryURI() {
        return this.recoveryURI;
    }

    public String getParticipantURI() {
        return this.participantPath;
    }

    void setRecoveryURI(String recoveryURI) {
        try {
            this.recoveryURI = new URI(recoveryURI);
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException(recoveryURI + ": Invalid recovery id: " + e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    void setRecoveryURI(String recoveryUrlBase, String txId, String coordinatorId) {
        this.setRecoveryURI(recoveryUrlBase + txId + '/' + coordinatorId);
    }

    public String getCompensator() {
        return this.compensateURI != null ? this.compensateURI.toASCIIString() : null;
    }

    void setLRAService(LRAService lraService) {
        this.lraService = lraService;
    }

    public void setLraService(LRAService lraService) {
        this.lraService = lraService;
    }

    public URI getEndNotificationUri() {
        return this.afterURI;
    }

    private String getLRAId(URI lraId) {
        String path = lraId.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }
}

