/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.ExpiryScanner;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.util.Hashtable;

public class ExpiredTransactionScanner
implements ExpiryScanner {
    private String _typeName;
    private String _movedTypeName;
    private RecoveryStore _recoveryStore = StoreManager.getRecoveryStore();
    private Hashtable _scanM = null;
    private Hashtable _scanN = null;

    public ExpiredTransactionScanner(String typeName, String movedTypeName) {
        this._typeName = typeName;
        this._movedTypeName = movedTypeName;
    }

    public void scan() {
        boolean initialScan = false;
        if (this._scanM == null) {
            this._scanM = new Hashtable();
            initialScan = true;
        }
        try {
            InputObjectState uids = new InputObjectState();
            if (this._recoveryStore.allObjUids(this._typeName, uids)) {
                Uid theUid = null;
                boolean endOfUids = false;
                while (!endOfUids) {
                    theUid = UidHelper.unpackFrom((InputBuffer)uids);
                    if (theUid.equals(Uid.nullUid())) {
                        endOfUids = true;
                        continue;
                    }
                    Uid newUid = new Uid(theUid);
                    if (initialScan) {
                        this._scanM.put(newUid, newUid);
                        continue;
                    }
                    if (!this._scanM.contains(newUid)) {
                        if (this._scanN == null) {
                            this._scanN = new Hashtable();
                        }
                        this._scanN.put(newUid, newUid);
                        continue;
                    }
                    tsLogger.i18NLogger.info_recovery_ExpiredTransactionScanner_4(newUid);
                    try {
                        this.moveEntry(newUid);
                    }
                    catch (Exception ex) {
                        tsLogger.i18NLogger.warn_recovery_ExpiredTransactionScanner_2(newUid, (Throwable)ex);
                        this._scanN.put(newUid, newUid);
                    }
                }
                if (this._scanN != null) {
                    this._scanM = this._scanN;
                    this._scanN = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean toBeUsed() {
        return true;
    }

    public boolean moveEntry(Uid newUid) throws ObjectStoreException {
        InputObjectState state = this._recoveryStore.read_committed(newUid, this._typeName);
        boolean res = false;
        if (state != null) {
            boolean moved = this._recoveryStore.write_committed(newUid, this._movedTypeName, new OutputObjectState(state));
            if (!moved) {
                tsLogger.logger.debugf("Removing old transaction status manager item %s", (Object)newUid);
            } else {
                res = this._recoveryStore.remove_committed(newUid, this._typeName);
                tsLogger.i18NLogger.warn_recovery_ExpiredTransactionStatusManagerScanner_6(newUid);
            }
        }
        return res;
    }
}

