/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.slot;

import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.internal.arjuna.objectstore.slot.BackingSlots;
import com.arjuna.ats.internal.arjuna.objectstore.slot.SlotStoreEnvironmentBean;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.CRC32;

public class DiskSlots
implements BackingSlots {
    private SlotStoreEnvironmentBean config;
    private RandomAccessFile[] slots;

    public synchronized void init(SlotStoreEnvironmentBean config) throws IOException {
        if (this.config != null) {
            throw new IllegalStateException("already initialized");
        }
        this.config = config;
        File storeDir = new File(config.getStoreDir());
        if (!storeDir.exists() && !storeDir.mkdirs()) {
            throw new IOException(tsLogger.i18NLogger.get_dir_create_failed(storeDir.getCanonicalPath()));
        }
        this.slots = new RandomAccessFile[config.getNumberOfSlots()];
        for (int i = 0; i < this.slots.length; ++i) {
            File file = new File(storeDir, "slot." + i);
            this.slots[i] = new RandomAccessFile(file, "rw");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int slot, byte[] data, boolean sync) throws IOException {
        RandomAccessFile randomAccessFile;
        RandomAccessFile randomAccessFile2 = randomAccessFile = this.slots[slot];
        synchronized (randomAccessFile2) {
            randomAccessFile.seek(0L);
            randomAccessFile.writeInt(data.length);
            randomAccessFile.write(data);
            randomAccessFile.writeInt(this.checksum(data));
            if (sync) {
                randomAccessFile.getFD().sync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(int slot) throws IOException {
        RandomAccessFile randomAccessFile;
        RandomAccessFile randomAccessFile2 = randomAccessFile = this.slots[slot];
        synchronized (randomAccessFile2) {
            if (randomAccessFile.length() < 8L) {
                return null;
            }
            randomAccessFile.seek(0L);
            int dataLength = randomAccessFile.readInt();
            byte[] data = new byte[dataLength];
            try {
                randomAccessFile.read(data);
                int expectedChecksum = randomAccessFile.readInt();
                if (expectedChecksum == this.checksum(data)) {
                    return data;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(int slot, boolean sync) throws IOException {
        RandomAccessFile randomAccessFile;
        RandomAccessFile randomAccessFile2 = randomAccessFile = this.slots[slot];
        synchronized (randomAccessFile2) {
            this.write(slot, new byte[0], sync);
        }
    }

    private int checksum(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data, 0, data.length);
        int checksum = (int)crc32.getValue();
        return checksum;
    }
}

