/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.tools.osb.mbean.OSEntryBeanMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreItemMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.UidWrapper;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import javax.management.MBeanException;

@Deprecated
public class OSEntryBean
implements OSEntryBeanMBean {
    protected UidWrapper _uidWrapper;
    public static final String REMOVE_OK_1 = "Record successfully removed";
    public static final String REMOVE_NOK_1 = "Remove committed failed for uid ";

    public OSEntryBean() {
        this._uidWrapper = new UidWrapper(Uid.nullUid());
    }

    public OSEntryBean(UidWrapper w) {
        if (w == null) {
            w = new UidWrapper(Uid.nullUid());
        }
        this._uidWrapper = w;
    }

    public void register(String name) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("Registering: " + name));
        }
        JMXServer.getAgent().registerMBean(name, (ObjStoreItemMBean)this);
    }

    public void unregister(String name) {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("Unregistering: " + name));
        }
        JMXServer.getAgent().unregisterMBean(name);
    }

    public void register() {
        this.register(this.getName());
    }

    public void unregister() {
        this.unregister(this.getName());
    }

    public String getName() {
        return this._uidWrapper.getName();
    }

    public String getType() {
        return this._uidWrapper.getType();
    }

    public String type() {
        return this.getType();
    }

    public boolean activate() {
        return false;
    }

    public Uid getUid(AbstractRecord rec) {
        return rec.get_uid();
    }

    public String getId() {
        return this._uidWrapper.getUid().stringForm();
    }

    public Uid getUid() {
        return this._uidWrapper.getUid();
    }

    public StringBuilder toString(String prefix, StringBuilder sb) {
        return sb.append(prefix).append('\t').append(this.getId()).append('\n');
    }

    public String remove() throws MBeanException {
        return this.remove(true);
    }

    public String remove(boolean reprobe) throws MBeanException {
        if (this.doRemove()) {
            if (reprobe) {
                this._uidWrapper.probe();
            }
            return REMOVE_OK_1;
        }
        return REMOVE_NOK_1;
    }

    public boolean doRemove() {
        try {
            if (StoreManager.getRecoveryStore().remove_committed(this.getUid(), this._uidWrapper.getType())) {
                return true;
            }
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debugf("%s %s", (Object)REMOVE_NOK_1, (Object)this.getUid().toString());
            }
            return false;
        }
        catch (ObjectStoreException e) {
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debugf("%s %s - %s", (Object)REMOVE_NOK_1, (Object)this.getUid().toString(), (Object)e.getMessage());
            }
            return false;
        }
    }
}

