/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.specimpl.PathSegmentImpl;

@Provider
@PreMatching
public class AcceptHeaderByFileSuffixFilter
implements ContainerRequestFilter {
    private final Map<String, String> mediaTypeMappings = new HashMap<String, String>();
    private final Map<String, String> languageMappings = new HashMap<String, String>();

    public void setMediaTypeMappings(Map<String, MediaType> mediaTypeMappings) {
        this.mediaTypeMappings.clear();
        for (Map.Entry<String, MediaType> entry : mediaTypeMappings.entrySet()) {
            this.mediaTypeMappings.put(entry.getKey(), entry.getValue().toString());
        }
    }

    public void setLanguageMappings(Map<String, String> languageMappings) {
        this.languageMappings.clear();
        for (Map.Entry<String, String> entry : languageMappings.entrySet()) {
            this.languageMappings.put(entry.getKey(), entry.getValue());
        }
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        int index;
        if (this.mediaTypeMappings.isEmpty() && this.languageMappings.isEmpty()) {
            return;
        }
        URI uri = requestContext.getUriInfo().getRequestUri();
        String rawPath = uri.getRawPath();
        int lastSegment = rawPath.lastIndexOf(47);
        if (lastSegment < 0) {
            lastSegment = 0;
        }
        if ((index = rawPath.indexOf(46, lastSegment)) < 0) {
            return;
        }
        boolean preprocessed = false;
        String extension = rawPath.substring(index + 1);
        String[] extensions = extension.split("\\.");
        StringBuilder rebuilt = new StringBuilder();
        for (String ext : extensions) {
            String match;
            if (this.mediaTypeMappings != null && (match = this.mediaTypeMappings.get(ext)) != null) {
                requestContext.getHeaders().addFirst((Object)"Accept", (Object)match);
                preprocessed = true;
                continue;
            }
            if (this.languageMappings != null && (match = this.languageMappings.get(ext)) != null) {
                requestContext.getHeaders().add((Object)"Accept-Language", (Object)match);
                preprocessed = true;
                continue;
            }
            rebuilt.append(".").append(ext);
        }
        if (!preprocessed) {
            return;
        }
        rawPath = rawPath.substring(0, index) + rebuilt.toString();
        URI newUri = requestContext.getUriInfo().getBaseUriBuilder().replacePath(rawPath).replaceQuery(uri.getRawQuery()).build(new Object[0]);
        requestContext.setRequestUri(newUri);
    }

    private List<PathSegment> process(ContainerRequestContext in) {
        int index;
        String path = in.getUriInfo().getPath(false);
        int lastSegment = path.lastIndexOf(47);
        if (lastSegment < 0) {
            lastSegment = 0;
        }
        if ((index = path.indexOf(46, lastSegment)) < 0) {
            return null;
        }
        boolean preprocessed = false;
        String extension = path.substring(index + 1);
        String[] extensions = extension.split("\\.");
        StringBuilder rebuilt = new StringBuilder(path.substring(0, index));
        for (String ext : extensions) {
            String match;
            if (this.mediaTypeMappings != null && (match = this.mediaTypeMappings.get(ext)) != null) {
                in.getHeaders().addFirst((Object)"Accept", (Object)match);
                preprocessed = true;
                continue;
            }
            if (this.languageMappings != null && (match = this.languageMappings.get(ext)) != null) {
                in.getHeaders().add((Object)"Accept-Language", (Object)match);
                preprocessed = true;
                continue;
            }
            rebuilt.append(".").append(ext);
        }
        List<PathSegment> segments = null;
        if (preprocessed) {
            segments = PathSegmentImpl.parseSegments(rebuilt.toString(), false);
        }
        return segments;
    }
}

