/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.openidconnect.backchannellogout;

import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.ProvidersService;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import io.openliberty.security.common.osgi.SecurityOSGiUtils;
import io.openliberty.security.openidconnect.backchannellogout.BackchannelLogoutRequest;
import io.openliberty.security.openidconnect.backchannellogout.LogoutTokenBuilder;
import io.openliberty.security.openidconnect.backchannellogout.LogoutTokenBuilderException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BackchannelLogoutRequestHelper {
    private static TraceComponent tc = Tr.register(BackchannelLogoutRequestHelper.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    private final PrivilegedAction<ExecutorService> getExecutorServiceAction = new GetExecutorServiceAction();
    private final HttpServletRequest request;
    private final OidcServerConfig oidcServerConfig;
    static final long serialVersionUID = 8312746657132274754L;

    public BackchannelLogoutRequestHelper(HttpServletRequest request, OidcServerConfig oidcServerConfig) {
        this.request = request;
        this.oidcServerConfig = oidcServerConfig;
    }

    /*
     * WARNING - void declaration
     */
    public void sendBackchannelLogoutRequests(String user, String idTokenString) {
        if (!this.shouldSendLogoutRequests(user, idTokenString)) {
            return;
        }
        Map<OidcBaseClient, Set<String>> logoutTokens = null;
        try {
            LogoutTokenBuilder tokenBuilder = new LogoutTokenBuilder(this.request, this.oidcServerConfig);
            logoutTokens = idTokenString == null || idTokenString.isEmpty() ? tokenBuilder.buildLogoutTokensFromUserName(user) : tokenBuilder.buildLogoutTokensFromIdTokenString(idTokenString);
        }
        catch (LogoutTokenBuilderException tokenBuilder) {
            void e;
            FFDCFilter.processException((Throwable)tokenBuilder, (String)"io.openliberty.security.openidconnect.backchannellogout.BackchannelLogoutRequestHelper", (String)"77", (Object)this, (Object[])new Object[]{user, idTokenString});
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_BACKCHANNEL_LOGOUT_REQUEST_ERROR", (Object[])new Object[]{this.oidcServerConfig.getProviderId(), e.getMessage()});
            return;
        }
        this.sendBackchannelLogoutRequestsToClients(logoutTokens);
    }

    boolean shouldSendLogoutRequests(String user, String idTokenString) {
        if ((user == null || user.isEmpty()) && (idTokenString == null || idTokenString.isEmpty())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Neither a user name nor an ID token string was provided, so back-channel logout will not be performed.", (Object[])new Object[0]);
            }
            return false;
        }
        if (!BackchannelLogoutRequestHelper.hasClientWithBackchannelLogoutUri(this.oidcServerConfig)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No client has a back-channel logout uri set up, so back-channel logout will not be performed.", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    public static boolean hasClientWithBackchannelLogoutUri(OidcServerConfig oidcServerConfig) {
        String oauthProviderName = oidcServerConfig.getOauthProviderName();
        OAuth20Provider provider = ProvidersService.getOAuth20Provider((String)oauthProviderName);
        if (provider == null) {
            return false;
        }
        return BackchannelLogoutRequestHelper.hasClientWithBackchannelLogoutUri(provider);
    }

    @FFDCIgnore(value={OidcServerException.class})
    static boolean hasClientWithBackchannelLogoutUri(OAuth20Provider provider) {
        OidcOAuth20ClientProvider clientProvider = provider.getClientProvider();
        if (clientProvider == null) {
            return false;
        }
        try {
            for (OidcBaseClient client : clientProvider.getAll()) {
                String backchannelLogoutUri = client.getBackchannelLogoutUri();
                if (backchannelLogoutUri == null || backchannelLogoutUri.isEmpty()) continue;
                return true;
            }
        }
        catch (OidcServerException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"There was an issue getting all the OIDC OAuth20 clients.", (Object[])new Object[0]);
            }
            return false;
        }
        return false;
    }

    void sendBackchannelLogoutRequestsToClients(Map<OidcBaseClient, Set<String>> clientsAndLogoutTokens) {
        if (clientsAndLogoutTokens == null || clientsAndLogoutTokens.isEmpty()) {
            return;
        }
        List<BackchannelLogoutRequest> requests = this.createLogoutRequests(clientsAndLogoutTokens);
        this.sendAllBackchannelLogoutRequests(requests);
    }

    List<BackchannelLogoutRequest> createLogoutRequests(Map<OidcBaseClient, Set<String>> clientsAndLogoutTokens) {
        ArrayList<BackchannelLogoutRequest> requests = new ArrayList<BackchannelLogoutRequest>();
        for (Map.Entry<OidcBaseClient, Set<String>> entry : clientsAndLogoutTokens.entrySet()) {
            OidcBaseClient client = entry.getKey();
            for (String logoutToken : entry.getValue()) {
                BackchannelLogoutRequest request = new BackchannelLogoutRequest(this.oidcServerConfig, client.getBackchannelLogoutUri(), logoutToken);
                requests.add(request);
            }
        }
        return requests;
    }

    /*
     * WARNING - void declaration
     */
    void sendAllBackchannelLogoutRequests(List<BackchannelLogoutRequest> requests) {
        List<Future<BackchannelLogoutRequest>> futures;
        if (requests == null || requests.isEmpty()) {
            return;
        }
        ExecutorService executorService = this.getExecutorService();
        try {
            futures = executorService.invokeAll(requests, this.oidcServerConfig.getBackchannelLogoutRequestTimeout(), TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.security.openidconnect.backchannellogout.BackchannelLogoutRequestHelper", (String)"159", (Object)this, (Object[])new Object[]{requests});
            Tr.error((TraceComponent)tc, (String)"BACKCHANNEL_LOGOUT_REQUESTS_INVOKE_ALL_FAILED", (Object[])new Object[]{this.oidcServerConfig.getProviderId(), e});
            return;
        }
        this.processLogoutRequestFutures(requests, futures);
    }

    void processLogoutRequestFutures(List<BackchannelLogoutRequest> requests, List<Future<BackchannelLogoutRequest>> futures) {
        if (requests.size() != futures.size()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Original task list (" + requests.size() + ") and futures list (" + futures.size() + ") did not have the same size"), (Object[])new Object[0]);
            }
            return;
        }
        for (int i = 0; i < futures.size(); ++i) {
            this.processLogoutRequestFuture(requests.get(i), futures.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    void processLogoutRequestFuture(BackchannelLogoutRequest originalRequest, Future<BackchannelLogoutRequest> future) {
        try {
            BackchannelLogoutRequest result = future.get();
            HttpResponse response = result.getResponse();
            if (response == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Failed to obtain a response from request to " + originalRequest.getUrl()), (Object[])new Object[0]);
                }
                return;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String responseBody = this.readResponseBody(response);
                JwtClaims logoutTokenClaims = this.getLogoutTokenClaims(result);
                Tr.error((TraceComponent)tc, (String)"BACKCHANNEL_LOGOUT_RESPONSE_NOT_SUCCESSFUL", (Object[])new Object[]{this.oidcServerConfig.getProviderId(), result.getUrl(), logoutTokenClaims, statusCode, responseBody});
            }
        }
        catch (Exception result) {
            void e;
            FFDCFilter.processException((Throwable)result, (String)"io.openliberty.security.openidconnect.backchannellogout.BackchannelLogoutRequestHelper", (String)"195", (Object)this, (Object[])new Object[]{originalRequest, future});
            JwtClaims logoutTokenClaims = this.getLogoutTokenClaims(originalRequest);
            Tr.error((TraceComponent)tc, (String)"BACKCHANNEL_LOGOUT_REQUEST_EXCEPTION", (Object[])new Object[]{this.oidcServerConfig.getProviderId(), originalRequest.getUrl(), logoutTokenClaims, e});
        }
    }

    @FFDCIgnore(value={Exception.class})
    JwtClaims getLogoutTokenClaims(BackchannelLogoutRequest bclRequest) {
        String logoutToken = bclRequest.getLogoutToken();
        try {
            JwtContext jwtContext = JwtParsingUtils.parseJwtWithoutValidation((String)logoutToken);
            return jwtContext.getJwtClaims();
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to parse logout token to obtain claims: " + e), (Object[])new Object[0]);
            }
            return null;
        }
    }

    @FFDCIgnore(value={Exception.class})
    private String readResponseBody(HttpResponse response) {
        String responseBody;
        block2: {
            responseBody = null;
            try {
                HttpEntity responseEntity = response.getEntity();
                responseBody = EntityUtils.toString((HttpEntity)responseEntity);
                EntityUtils.consume((HttpEntity)responseEntity);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Failed to read response body: " + e), (Object[])new Object[0]);
            }
        }
        return responseBody;
    }

    ExecutorService getExecutorService() {
        ExecutorService executorService = System.getSecurityManager() == null ? this.getExecutorServiceFromServiceRegistry() : AccessController.doPrivileged(this.getExecutorServiceAction);
        return executorService;
    }

    private ExecutorService getExecutorServiceFromServiceRegistry() {
        return (ExecutorService)SecurityOSGiUtils.getService(this.getClass(), ExecutorService.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class GetExecutorServiceAction
    implements PrivilegedAction<ExecutorService> {
        static final long serialVersionUID = -3405976828613471073L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private GetExecutorServiceAction() {
        }

        @Override
        public ExecutorService run() {
            return BackchannelLogoutRequestHelper.this.getExecutorServiceFromServiceRegistry();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.security.openidconnect.backchannellogout.BackchannelLogoutRequestHelper$GetExecutorServiceAction", GetExecutorServiceAction.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
        }
    }
}

