/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SipConfigurationFileReader
implements EntityResolver {
    private static final String PROPERTY_ENTRY = "property";
    private static final LogMgr c_logger = Log.get(SipConfigurationFileReader.class);
    private DocumentBuilder m_documentBuilder;

    public SipConfigurationFileReader() throws ParserConfigurationException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipConfigurationFileReader");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.m_documentBuilder = factory.newDocumentBuilder();
        this.m_documentBuilder.setEntityResolver(this);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipConfigurationFileReader");
        }
    }

    public Properties parse(InputStream in) throws SAXException, IOException {
        Properties configuration = new Properties();
        Document doc = this.m_documentBuilder.parse(in);
        NodeList properties = doc.getElementsByTagName(PROPERTY_ENTRY);
        for (int i = 0; i < properties.getLength(); ++i) {
            NodeList childs = properties.item(i).getChildNodes();
            String name = null;
            String value = null;
            for (int j = 0; j < childs.getLength(); ++j) {
                Node node = childs.item(j);
                if (node.getNodeName().equalsIgnoreCase("name")) {
                    name = this.getTextNode(node);
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("value")) continue;
                value = this.getTextNode(node);
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "parse", "New Property, name: " + name + ", value: " + value);
            }
            if (null == name || null == value) continue;
            configuration.put(name, value);
        }
        return configuration;
    }

    private String getTextNode(Node node) {
        String rValue = null;
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child.getNodeType() != 3) continue;
            rValue = child.getNodeValue();
            break;
        }
        return rValue;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buffer = new StringBuffer("publicId: ");
            buffer.append(publicId);
            buffer.append(", systemId: ");
            buffer.append(systemId);
            c_logger.traceDebug(this, "resolveEntity", buffer.toString());
        }
        return null;
    }
}

