/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.appqueue;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.appqueue.NativeMessageDispatchingHandler;
import com.ibm.ws.sip.container.appqueue.QueueLoadListener;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.pmi.TaskDurationMeasurer;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.Queueable;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AppQueueHandler {
    private static final LogMgr c_logger = Log.get(AppQueueHandler.class);
    protected ArrayBlockingQueue _queue;
    private int _id;
    private QueueLoadListener _lstr;
    private AtomicInteger _msgCounter = new AtomicInteger(0);
    private Object LOW_PRIORITY_BLOCKER = new Object();
    private Object NORMAL_PRIORITY_BLOCKER = new Object();
    private int m_msgsProcessedSinceLastStats = 0;
    private long m_lastStatsReportTime = 0L;

    public AppQueueHandler(int waitingQueueSize, int id, QueueLoadListener lstr) {
        this._id = id;
        this._lstr = lstr;
        int queueBurstFactor = PropertiesStore.getInstance().getProperties().getInt("messageQueueBurstFactor");
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "AppQueueHandler", "Message queue burst factor is: " + queueBurstFactor);
        }
        this._queue = new ArrayBlockingQueue(NativeMessageDispatchingHandler.s_maxDispatchMessages * queueBurstFactor, true);
    }

    public boolean dispatchMessage(Queueable msg) {
        return this.dispatchMessage(msg, -1L);
    }

    protected void finishToExecuteRunnable() {
        block5: {
            block4: {
                try {
                    this.reportToFailoverServiceEnded();
                }
                catch (Throwable e2) {
                    if (!c_logger.isErrorEnabled()) break block4;
                    c_logger.error("End of service replicatin failed ", null, e2);
                }
            }
            try {
                this.updatePerfrmance();
                this.msgExecuted();
                this.unblockWaitingThreads();
            }
            catch (Throwable th) {
                if (!c_logger.isTraceDebugEnabled()) break block5;
                c_logger.traceDebug(this, "finishToExecuteRunnable", th.getMessage(), th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateWhenReadyTU() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "invalidateWhenReadyTU");
        }
        try {
            Vector<TransactionUserWrapper> tu = ThreadLocalStorage.getTuForInvalidate();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "invalidateWhenReadyTU", "tu list =" + tu);
            }
            if (tu != null) {
                for (TransactionUserWrapper element : tu) {
                    boolean valid = element.isValid();
                    boolean hasTransactions = element.hasOngoingTransactions();
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "invalidateWhenReadyTU", "check tu =" + element + ", valid=" + valid + ", hasTransactions=" + hasTransactions);
                    }
                    if (!valid || hasTransactions) continue;
                    element.invalidateWhenReady();
                }
            }
        }
        catch (Throwable th) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "invalidateWhenReadyTU", th.getMessage(), th);
            }
        }
        finally {
            ThreadLocalStorage.cleanTuForInvalidate();
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "invalidateWhenReadyTU");
            }
        }
    }

    protected Queueable getRunnableObj() {
        Queueable msg = null;
        try {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getRunnableObj", "waiting for queue to be filled with something.");
            }
            msg = (Queueable)this._queue.take();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getRunnableObj", "Q had:" + (this._queue.size() + 1) + " elements. Dispatching= " + msg);
            }
        }
        catch (InterruptedException ex) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getRunnableObj", " had InterruptedException:" + ex.getLocalizedMessage());
            }
            Thread.currentThread();
            Thread.interrupted();
        }
        return msg;
    }

    public boolean dispatchMessage(Queueable msg, long blockingTimeout) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "dispatchMessage(2)", this._id, this._queue.size());
        }
        if (!this.canMessageBeProcessed(msg, blockingTimeout)) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "dispatchMessage", "can not process message:" + msg + " msg will not be queued.");
            }
            return false;
        }
        if (this._queue.offer(msg)) {
            PerformanceMgr perfMgr;
            this.msgAdded();
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit((Object)this, "dispatchMessage(2)", new Integer[]{this._id, this._queue.size()});
            }
            if ((perfMgr = PerformanceMgr.getInstance()) != null && perfMgr.isTaskDurationProcessingQueuePMIEnabled() && msg != null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "dispatchMessage", "Start measuring new task duration in SIP container queue");
                }
                msg.setSipContainerQueueDuration(new TaskDurationMeasurer());
                msg.getSipContainerQueueDuration().startMeasuring();
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "dispatchMessage", "Update QueueMonitoringModule processing queue statistics - task queued");
            }
            if (perfMgr != null) {
                perfMgr.updateQueueMonitoringTaskQueuedInProcessingQueue();
            }
            return true;
        }
        return false;
    }

    private boolean canMessageBeProcessed(Queueable msg, long blockingTimeout) {
        block9: {
            try {
                int currentState = this.getQueueLoad();
                if (currentState > NativeMessageDispatchingHandler.s_onlyCriricalMessagesGetsIn && msg.priority() <= 50) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "canMessageBeProcessed", "we passed the threshold.");
                    }
                    if (blockingTimeout >= 0L) {
                        this.block(this.NORMAL_PRIORITY_BLOCKER, blockingTimeout);
                        return true;
                    }
                    return false;
                }
                if (currentState > NativeMessageDispatchingHandler.s_rejectLowPriorityMsgs && msg.priority() <= 10) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "canMessageBeProcessed", "we passed low watermark.");
                    }
                    if (blockingTimeout >= 0L) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "canMessageBeProcessed", "Q load:" + currentState + " threshold:" + NativeMessageDispatchingHandler.s_rejectLowPriorityMsgs + " Qid=" + this._id);
                        }
                        this.block(this.LOW_PRIORITY_BLOCKER, blockingTimeout);
                        return true;
                    }
                    return false;
                }
            }
            catch (InterruptedException e2) {
                if (!c_logger.isTraceDebugEnabled()) break block9;
                c_logger.traceDebug(this, "canMessageBeProcessed", "block interrupted", e2);
            }
        }
        return true;
    }

    protected void unblockWaitingThreads() {
        int currentQstate = this.getQueueLoad();
        if (currentQstate < NativeMessageDispatchingHandler.s_maxMsgPerThread) {
            this.unblock(this.NORMAL_PRIORITY_BLOCKER);
        }
        if (currentQstate < NativeMessageDispatchingHandler.s_rejectLowPriorityMsgs) {
            this.unblock(this.LOW_PRIORITY_BLOCKER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblock(Object blocker) {
        Object object = blocker;
        synchronized (object) {
            blocker.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void block(Object blocker, long blockingTimeout) throws InterruptedException {
        Object object = blocker;
        synchronized (object) {
            blocker.wait(blockingTimeout);
        }
    }

    protected abstract void extractAmsgAndExecute();

    private void notifyQueueChanged() {
        this._lstr.queueChanged();
    }

    public int getQueueLoad() {
        return this._msgCounter.get();
    }

    protected void msgExecuted() {
        this._msgCounter.decrementAndGet();
        ++this.m_msgsProcessedSinceLastStats;
        this.notifyQueueChanged();
    }

    protected void msgAdded() {
        this._msgCounter.incrementAndGet();
        this.notifyQueueChanged();
    }

    public int getId() {
        return this._id;
    }

    public void reportToFailoverServiceStart() {
    }

    protected void reportToFailoverServiceEnded() {
    }

    protected void updatePerfrmance() {
        PerformanceMgr perfMgr = PerformanceMgr.getInstance();
        if (perfMgr != null) {
            perfMgr.decrementInvokeCounter();
        }
    }

    public String getInfo() {
        long now = System.currentTimeMillis();
        int secPassed = (int)((now - this.m_lastStatsReportTime) / 1000L);
        int rate = 0;
        if (secPassed > 0) {
            rate = this.m_msgsProcessedSinceLastStats / secPassed;
        }
        this.m_msgsProcessedSinceLastStats = 0;
        this.m_lastStatsReportTime = now;
        StringBuffer msg = new StringBuffer(10);
        msg.append(this.getQueueLoad());
        if (rate > 0) {
            msg.append(',').append(rate).append("m/s");
        }
        return msg.toString();
    }
}

