/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl.chfw;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.ws.sip.channel.resolver.impl.chfw.SipResolverTransport;
import com.ibm.ws.sip.channel.resolver.impl.chfw.SipResolverTransportListener;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.OutboundVirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.udpchannel.UDPContext;
import com.ibm.wsspi.udpchannel.UDPReadCompletedCallback;
import com.ibm.wsspi.udpchannel.UDPReadRequestContext;
import com.ibm.wsspi.udpchannel.UDPWriteCompletedCallback;
import com.ibm.wsspi.udpchannel.UDPWriteRequestContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Vector;

class SipResolverUdpTransport
implements ConnectionReadyCallback,
UDPReadCompletedCallback,
UDPWriteCompletedCallback,
SipResolverTransport {
    private static final LogMgr c_logger = Log.get(SipResolverUdpTransport.class);
    private static ChannelFramework _framework;
    private static final int WRITE_STATE_DISCONNECTED = 0;
    private static final int WRITE_STATE_CONNECTING = 1;
    private static final int WRITE_STATE_IDLE = 2;
    private static final int WRITE_STATE_WRITE_ACTIVE = 3;
    private static final int WRITE_STATE_SHUTDOWN = 4;
    private static final int READ_STATE_READY = 1;
    private static final int READ_STATE_DISCONNECTED = 2;
    private static final int READ_STATE_SHUTDOWN = 3;
    private static final int MAX_WRITE_QUEUE_SIZE = 5000;
    private SipResolverTransportListener _transportListener = null;
    private Vector<InetSocketAddress> _nameServers = null;
    private Iterator<InetSocketAddress> _nameServerIterator = null;
    private int _writeState = 0;
    private int _readState = 2;
    private boolean _shutdown = false;
    private Queue<WsByteBuffer> _requestQueue = new LinkedList<WsByteBuffer>();
    private OutboundVirtualConnection _outboundVirtualContext;
    private UDPReadRequestContext _reader;
    private UDPWriteRequestContext _writer;
    private static boolean _channelInitialized;
    protected InetSocketAddress _currentSocketAddress = null;
    private static String CHAINNAME;
    private boolean reConnectAllowed = true;
    private int _connectionFailedCount = -1;
    private int _transportErrorCount = 0;
    private boolean connectDone = false;
    private int _ConnectFailuresAllowed = 2;
    private int _TransportErrorsAllowed = 3;
    protected int timeoutIdleCount = 0;
    protected int TIMEOUT_IDLE_COUNT_MAX = 3;
    protected boolean writeNeedsResponse = false;
    protected static final int TIMEOUT_TIME = 3000;

    protected SipResolverUdpTransport() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: constructor()");
            c_logger.traceExit(this, "SipResolverUdpTransport: constructor()");
        }
    }

    protected synchronized void initialize(ChannelFramework framework) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: initialize() _channelInitialized:" + _channelInitialized);
        }
        if (!_channelInitialized) {
            block8: {
                try {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverUdpTransport: initialize: getChannelFramewor()");
                    }
                    framework.addChannel(CHAINNAME, framework.lookupFactory("UDPChannel"), null, 10);
                    String[] channelNameList = new String[]{CHAINNAME};
                    framework.addChain(CHAINNAME, FlowType.OUTBOUND, channelNameList);
                    _framework = framework;
                    this._writeState = 0;
                    this._readState = 2;
                    this.reConnectAllowed = true;
                    VirtualConnectionFactory vcf = _framework.getOutboundVCFactory(CHAINNAME);
                    this._outboundVirtualContext = (OutboundVirtualConnection)vcf.createConnection();
                    this._reader = ((UDPContext)this._outboundVirtualContext.getChannelAccessor()).getReadInterface();
                    this._writer = ((UDPContext)this._outboundVirtualContext.getChannelAccessor()).getWriteInterface();
                }
                catch (ChannelException e2) {
                    if (c_logger.isWarnEnabled()) {
                        c_logger.warn("Udp Resolver channel exception during init: " + e2.getMessage());
                        e2.printStackTrace();
                    }
                }
                catch (ChainException e1) {
                    if (!c_logger.isWarnEnabled()) break block8;
                    c_logger.warn("Udp Resolver channel exception during init: " + e1.getMessage());
                }
            }
            _channelInitialized = true;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: initialize()");
        }
    }

    protected SipResolverUdpTransport(Vector<InetSocketAddress> nameServers, SipResolverTransportListener transportListener, CHFWBundle chfwB) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: constructor(Vector, SipResolverTransportListener): entry: id=" + this.hashCode() + " " + chfwB);
        }
        this.initialize(chfwB.getFramework());
        this._nameServers = nameServers;
        this._nameServerIterator = this._nameServers.iterator();
        this._transportListener = transportListener;
        this._ConnectFailuresAllowed = this._nameServers.size() * 2;
        this._TransportErrorsAllowed = this._nameServers.size() * 3;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: contructor: _ConnectFailuresAllowed: " + this._ConnectFailuresAllowed);
            c_logger.traceDebug("SipResolverTcpTransport: contructor: _TransportErrorsAllowed: " + this._TransportErrorsAllowed);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: constructor(Vector, SipResolverTransportListener): entry: ");
        }
    }

    protected synchronized void shutdown() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: shutdown: entry: id=" + this.hashCode());
        }
        this._shutdown = true;
        this._requestQueue.clear();
        this._writeState = 4;
        this._readState = 3;
        if (this._outboundVirtualContext != null) {
            this._outboundVirtualContext.close((Exception)new IOException("SIP Resolver is being shutdown"));
            this._outboundVirtualContext = null;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: shutdown: exit: ");
        }
    }

    private void talkToDNS() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: talkToDNS: entry: id=" + this.hashCode());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: talkToDNS: Find DNS Server in list");
        }
        if (!this._nameServerIterator.hasNext()) {
            this._nameServerIterator = this._nameServers.iterator();
            this._currentSocketAddress = this._nameServerIterator.next();
        } else {
            this._currentSocketAddress = this._nameServerIterator.next();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: talkToDNS: SIP Resolver nameserver target: " + this._currentSocketAddress.getHostName() + ":" + this._currentSocketAddress.getPort());
        }
        if (this.connectDone) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: talkToDNS: connectAsynch called go right to ready()");
            }
            this.ready((VirtualConnection)this._outboundVirtualContext);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: talkToDNS: connectAsynch not called yet, do so now");
            }
            this._outboundVirtualContext.connectAsynch(null, (ConnectionReadyCallback)this);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: talkToDNS: exit: ");
        }
    }

    public void ready(VirtualConnection vc) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: ready: entry: id=" + this.hashCode());
        }
        this.connectDone = true;
        this._writeState = 2;
        this._readState = 1;
        this._connectionFailedCount = 0;
        this.reConnectAllowed = false;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: ready: UDP read request");
        }
        this._reader.read((UDPReadCompletedCallback)this, true);
        this.drainRequestQueue();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: ready: exit: ");
        }
    }

    public void destroy(Exception e2) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: destroy(Exception e)");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: destroy: Socket destroyed " + e2);
        }
        this._readState = 2;
        this._writeState = 0;
        ++this._connectionFailedCount;
        if (this._connectionFailedCount <= this._ConnectFailuresAllowed) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: error: calling transportError - _connectionFailedCount: " + this._connectionFailedCount);
            }
            this._transportListener.transportError(e2, this);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: error: calling transportFailed - _connectionFailedCount: " + this._connectionFailedCount);
            }
            this._connectionFailedCount = 0;
            this._transportErrorCount = 0;
            this._transportListener.transportFailed(e2, this);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: destroy(Exception e)");
        }
    }

    @Override
    public synchronized void writeRequest(WsByteBuffer requestBuffer) throws IOException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: writeRequest: entry id=" + this.hashCode());
        }
        if (this._shutdown) {
            throw new IllegalStateException("SIP UDP Resolver transport is shutdown.");
        }
        switch (this._writeState) {
            case 4: {
                if (!c_logger.isTraceDebugEnabled()) break;
                c_logger.traceDebug("SipResolverUdpTransport:writeRequest: WRITE_STATE_SHUTDOWN");
                break;
            }
            case 2: {
                VirtualConnection vc = null;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport:writeRequest: WRITE_STATE_IDLE");
                }
                this._writer.setBuffer(requestBuffer);
                vc = this._writer.write((SocketAddress)this._currentSocketAddress, (UDPWriteCompletedCallback)this, false);
                if (vc == null) {
                    this._writeState = 3;
                    break;
                }
                this.complete(vc, this._writer);
                break;
            }
            case 3: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport:writeRequest: WRITE_STATE_WRITE_ACTIVE");
                }
                if (this._requestQueue.size() > 5000) {
                    throw new IOException("Maximum write queue size is being exceeded");
                }
                this._requestQueue.add(requestBuffer);
                break;
            }
            case 1: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport:writeRequest: WRITE_STATE_CONNECTING");
                }
                this._requestQueue.add(requestBuffer);
                break;
            }
            case 0: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport:writeRequest: WRITE_STATE_DISCONNECTED");
                }
                this._requestQueue.add(requestBuffer);
                if (!this.reConnectAllowed) break;
                this.talkToDNS();
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: writeRequest: exit: ");
        }
    }

    public void destroyFromTimeout(Exception e2) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: destroyFromTimeout(Exception e)");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: destroyFromTimeout: Socket destroyed " + e2);
        }
        this._readState = 2;
        this._writeState = 0;
        ++this._transportErrorCount;
        if (this._transportErrorCount <= this._TransportErrorsAllowed) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: destroyFromTimeout: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
            }
            this._transportListener.transportError(e2, this);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: destroyFromTimeout: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
            }
            this._transportErrorCount = 0;
            this._transportListener.transportFailed(e2, this);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: destroyFromTimeout(Exception e)");
        }
    }

    @Override
    public void prepareForReConnect() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: prepareForReConnect");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: prepareForReConnect: clear out _requestQueue: # of items: " + this._requestQueue.size());
        }
        this._requestQueue.clear();
        this.reConnectAllowed = true;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: prepareForReConnect");
        }
    }

    public void complete(VirtualConnection vc, UDPReadRequestContext rsc) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: complete(VirtualConnection vc, UDPReadRequestContext rsc) _readState: " + this._readState);
        }
        this._transportErrorCount = 0;
        vc = null;
        this._reader.getUDPBuffer().getBuffer().flip();
        this._transportListener.responseReceived(this._reader.getUDPBuffer().getBuffer());
        if (this._readState != 2) {
            this._readState = 1;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: complete: read message body");
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverUdpTransport: complete: UDP read request");
            }
            vc = this._reader.read((UDPReadCompletedCallback)this, false);
            while (vc != null && !this._shutdown) {
                this._reader.getUDPBuffer().getBuffer().flip();
                this._transportListener.responseReceived(this._reader.getUDPBuffer().getBuffer());
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: complete: read next response");
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: complete: looping  UDP read request");
                }
                vc = this._reader.read((UDPReadCompletedCallback)this, false);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: complete(VirtualConnection vc, UDPReadRequestContext rsc)");
        }
    }

    public void error(VirtualConnection vc, UDPReadRequestContext rrc, IOException ioe) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: error(VirtualConnection vc, UDPReadRequestContext rrc, IOException ioe)");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: Read error: " + ioe);
        }
        if (!this._shutdown) {
            this._readState = 2;
            this._writeState = 0;
            ++this._transportErrorCount;
            if (this._transportErrorCount < this._TransportErrorsAllowed) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: error: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
                }
                this._transportListener.transportError(ioe, this);
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: error: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
                }
                this._transportErrorCount = 0;
                this._transportListener.transportFailed(ioe, this);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: error(VirtualConnection vc, UDPReadRequestContext rrc, IOException ioe)");
        }
    }

    public void complete(VirtualConnection vc, UDPWriteRequestContext wrc) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: complete(VirtualConnection vc, UDPWriteRequestContext wrc)");
        }
        this._transportErrorCount = 0;
        this.drainRequestQueue();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: complete(VirtualConnection vc, UDPWriteRequestContext wrc)");
        }
    }

    public void error(VirtualConnection vc, UDPWriteRequestContext wrc, IOException ioe) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverUdpTransport: error(VirtualConnection vc, UDPWriteRequestContext wrc, IOException ioe)");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverUdpTransport: Write error: " + ioe);
        }
        if (!this._shutdown) {
            this._readState = 2;
            this._writeState = 0;
            ++this._transportErrorCount;
            if (this._transportErrorCount < this._TransportErrorsAllowed) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: error: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
                }
                this._transportListener.transportError(ioe, this);
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport: error: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
                }
                this._transportErrorCount = 0;
                this._transportListener.transportFailed(ioe, this);
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: error(VirtualConnection vc, UDPWriteRequestContext wrc, IOException ioe)");
        }
    }

    private synchronized void drainRequestQueue() {
        block5: {
            WsByteBuffer requestBuffer;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "SipResolverUdpTransport: drainRequestQueue: entry _writeState: " + this._writeState);
            }
            while ((requestBuffer = this._requestQueue.poll()) != null) {
                VirtualConnection vc = null;
                this._writer.setBuffer(requestBuffer);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport:drainRequestQueue: writing new message, length = " + requestBuffer.limit());
                }
                if ((vc = this._writer.write((SocketAddress)this._currentSocketAddress, (UDPWriteCompletedCallback)this, false)) != null) continue;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverUdpTransport:drainRequestQueue: waiting for write to complete");
                }
                this._writeState = 3;
                break block5;
            }
            this._writeState = 2;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverUdpTransport: drainRequestQueue: exit _writeState: " + this._writeState);
        }
    }

    static {
        _channelInitialized = false;
        CHAINNAME = "SipResolver-udp-outbound";
    }
}

