/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.parser.Coder;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import com.ibm.ws.sip.stack.util.AddressUtils;
import java.util.Arrays;
import java.util.HashSet;

public class ParameterQuoter {
    private static final LogMgr s_logger = Log.get(ParameterQuoter.class);
    private final HashSet<String> m_parameters = new HashSet(32);
    private static final String[] DEFAULT_LIST = new String[]{"uri", "response", "username", "realm", "nonce", "cnonce", "opaque", "domain", "qop", "rspauth", "nextnonce", "text", "audio", "automata", "class", "duplex", "data", "control", "mobility", "description", "events", "priority", "methods", "schemes", "application", "video", "language", "type", "isfocus", "actor", "text", "extensions"};
    private static final ParameterQuoter s_instance = new ParameterQuoter();

    public static ParameterQuoter instance() {
        return s_instance;
    }

    private ParameterQuoter() {
        String[] configList;
        this.parseList(DEFAULT_LIST);
        if (ApplicationProperties.getProperties().getObject("sipQuotedParameters") != null && (configList = (String[])ApplicationProperties.getProperties().getObject("sipQuotedParameters")).length > 0) {
            this.parseList(configList);
        }
    }

    private final void parseList(String[] list) {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "parseList", "parsing list " + Arrays.toString(list));
        }
        int items = 0;
        int errors = 0;
        if (list != null) {
            ++items;
            for (String item : list) {
                if (this.parseItem(item)) continue;
                if (s_logger.isTraceFailureEnabled()) {
                    s_logger.traceFailure(this, "parseList", "bad item [" + item + ']');
                }
                ++errors;
            }
        }
        if (errors > 0) {
            if (s_logger.isTraceFailureEnabled()) {
                s_logger.traceFailure(this, "parseList", "complete with [" + errors + "] errors out of [" + items + "] items in list " + Arrays.toString(list));
            }
        } else if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "parseList", "complete with [" + items + "] items");
        }
    }

    private final boolean parseItem(String item) {
        String parameter;
        boolean add;
        int length = item.length();
        int equal = item.indexOf(61);
        if (equal == -1) {
            add = true;
            parameter = item;
        } else {
            if (equal >= length) {
                return false;
            }
            parameter = item.substring(0, equal);
            String equalValue = item.substring(equal + 1, length);
            boolean bl = add = !equalValue.equalsIgnoreCase("off");
        }
        if (add) {
            this.addParameter(parameter);
        } else {
            this.removeParameter(parameter);
        }
        return true;
    }

    private final boolean addParameter(String parameter) {
        return this.m_parameters.add(parameter);
    }

    private final boolean removeParameter(String parameter) {
        return this.m_parameters.remove(parameter);
    }

    public boolean quote(String parameter, String value, boolean escapeParameters) {
        if (this.isFeatureParameter(parameter)) {
            return true;
        }
        if (this.m_parameters.contains(parameter)) {
            return true;
        }
        if (escapeParameters) {
            return false;
        }
        return !Coder.isToken(value) && !AddressUtils.isIpAddress(value);
    }

    private boolean isFeatureParameter(String parameter) {
        int length = parameter.length();
        if (length < 2 || parameter.charAt(0) != '+') {
            return false;
        }
        char c = parameter.charAt(1);
        if (!Coder.isAlpha(c)) {
            return false;
        }
        block3: for (int i = 2; i < length; ++i) {
            c = parameter.charAt(i);
            if (Coder.isAlphanum(c)) continue;
            switch (c) {
                case '!': 
                case '%': 
                case '\'': 
                case '-': 
                case '.': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

