/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.utils.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class UsernameTokenUtil {
    public static final int DEFAULT_ITERATION = 1000;
    private static final Logger LOG;
    static final long serialVersionUID = 2160108036843918145L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private UsernameTokenUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] generateDerivedKey(byte[] password, byte[] salt, int iteration) throws WSSecurityException {
        byte[] pwSalt = new byte[salt.length + password.length];
        System.arraycopy(password, 0, pwSalt, 0, password.length);
        System.arraycopy(salt, 0, pwSalt, password.length, salt.length);
        MessageDigest sha = null;
        try {
            sha = CryptoUtils.isFips140_3EnabledWithBetaGuard() ? MessageDigest.getInstance("SHA256") : MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"org.apache.wss4j.common.util.UsernameTokenUtil", (String)"73", null, (Object[])new Object[]{password, salt, iteration});
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)e, "decoding.general");
        }
        byte[] k = sha.digest(pwSalt);
        int iter = iteration;
        if (iter <= 0) {
            iter = 1000;
        }
        for (int i = 1; i < iter; ++i) {
            k = sha.digest(k);
        }
        return k;
    }

    public static byte[] generateDerivedKey(String password, byte[] salt, int iteration) throws WSSecurityException {
        return UsernameTokenUtil.generateDerivedKey(password.getBytes(StandardCharsets.UTF_8), salt, iteration);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] generateSalt(boolean useForMac) {
        byte[] saltValue = null;
        try {
            saltValue = UsernameTokenUtil.generateNonce(16);
        }
        catch (WSSecurityException wSSecurityException) {
            void ex;
            FFDCFilter.processException((Throwable)((Object)wSSecurityException), (String)"org.apache.wss4j.common.util.UsernameTokenUtil", (String)"126", null, (Object[])new Object[]{useForMac});
            LOG.debug(ex.getMessage(), (Throwable)ex);
            return new byte[0];
        }
        saltValue[0] = useForMac ? 1 : 2;
        return saltValue;
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] generateNonce(int length) throws WSSecurityException {
        try {
            return XMLSecurityConstants.generateBytes((int)length);
        }
        catch (Exception exception) {
            void ex;
            FFDCFilter.processException((Throwable)exception, (String)"org.apache.wss4j.common.util.UsernameTokenUtil", (String)"148", null, (Object[])new Object[]{length});
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)ex, "empty", new Object[]{"Error in generating nonce of length " + length});
        }
    }

    public static String doPasswordDigest(byte[] nonce, String created, String password) throws WSSecurityException {
        return UsernameTokenUtil.doPasswordDigest(nonce, created, password.getBytes(StandardCharsets.UTF_8));
    }

    public static String doPasswordDigest(byte[] nonce, String created, byte[] password) throws WSSecurityException {
        byte[] digestBytes = UsernameTokenUtil.doRawPasswordDigest(nonce, created, password);
        return XMLUtils.encodeToString((byte[])digestBytes);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] doRawPasswordDigest(byte[] nonce, String created, byte[] password) throws WSSecurityException {
        try {
            byte[] b1 = nonce != null ? nonce : new byte[]{};
            byte[] b2 = created != null ? created.getBytes(StandardCharsets.UTF_8) : new byte[]{};
            byte[] b3 = password;
            byte[] b4 = new byte[b1.length + b2.length + b3.length];
            int offset = 0;
            System.arraycopy(b1, 0, b4, offset, b1.length);
            System.arraycopy(b2, 0, b4, offset += b1.length, b2.length);
            System.arraycopy(b3, 0, b4, offset += b2.length, b3.length);
            return KeyUtils.generateDigest(b4);
        }
        catch (Exception b1) {
            void e;
            FFDCFilter.processException((Throwable)b1, (String)"org.apache.wss4j.common.util.UsernameTokenUtil", (String)"180", null, (Object[])new Object[]{nonce, created, password});
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)e, "decoding.general");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getRawPassword(CallbackHandler callbackHandler, String username, String password, String passwordType) throws WSSecurityException {
        if (callbackHandler == null) {
            LOG.debug("CallbackHandler is null");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        WSPasswordCallback pwCb = new WSPasswordCallback(username, password, passwordType, 2);
        try {
            callbackHandler.handle(new Callback[]{pwCb});
        }
        catch (IOException | UnsupportedCallbackException exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"org.apache.wss4j.common.util.UsernameTokenUtil", (String)"202", null, (Object[])new Object[]{callbackHandler, username, password, passwordType});
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, (Exception)e);
        }
        return pwCb.getPassword();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.wss4j.common.util.UsernameTokenUtil", UsernameTokenUtil.class, null, null);
        LOG = LoggerFactory.getLogger(UsernameTokenUtil.class);
    }
}

