/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.CacheEntry;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.AliasEntry;
import com.ibm.ws.cache.InvalidateByIdEvent;
import com.ibm.ws.cache.InvalidateByTemplateEvent;
import com.ibm.ws.cache.InvalidationAuditDaemon;
import com.ibm.ws.cache.RealTimeDaemon;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.intf.ExternalCacheServices;
import com.ibm.ws.cache.intf.ExternalInvalidation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BatchUpdateDaemon
extends RealTimeDaemon {
    private static TraceComponent tc = Tr.register(BatchUpdateDaemon.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private ExternalCacheServices externalCacheServices = null;
    private InvalidationAuditDaemon invalidationAuditDaemon = null;
    private static final ArrayList EMPTY_ARRAYLIST = new ArrayList();
    private final HashMap updates = new HashMap();
    private final HashMap drsBuffer = new HashMap();
    private final int drsCongestionThreshold = 5;

    public BatchUpdateDaemon(int timeBetweenBatches) {
        super(timeBetweenBatches);
    }

    public void setExternalCacheServices(ExternalCacheServices externalCacheServices) {
        this.externalCacheServices = externalCacheServices;
    }

    public void setInvalidationAuditDaemon(InvalidationAuditDaemon invalidationAuditDaemon) {
        this.invalidationAuditDaemon = invalidationAuditDaemon;
    }

    @Override
    public void start() {
        if (this.invalidationAuditDaemon == null) {
            throw new IllegalStateException("invalidationAuditDaemon must be set before start()");
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateByTemplate(String template, boolean waitOnInvalidation, DCache cache) {
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList bul = this.getUpdateList(cache);
            bul.invalidateByTemplateEvents.put(template, new InvalidateByTemplateEvent(template, 5));
        }
        if (waitOnInvalidation) {
            this.wakeUp(0L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheCommand_Clear(boolean waitOnInvalidation, DCache cache) {
        String template = cache.getCacheName();
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList bul = this.getUpdateList(cache);
            bul.invalidateByIdEvents.clear();
            bul.invalidateByTemplateEvents.clear();
            bul.pushCacheEntryEvents.clear();
            bul.pushECFEvents.clear();
            InvalidateByTemplateEvent invalidateByTemplateEvent = new InvalidateByTemplateEvent(template, 5);
            invalidateByTemplateEvent.setCacheCommand_Clear();
            bul.invalidateByTemplateEvents.put(template, invalidateByTemplateEvent);
        }
        if (waitOnInvalidation) {
            this.wakeUp(0L, 0L);
        }
    }

    public void invalidateById(Object id, int causeOfInvalidation, boolean waitOnInvalidation, DCache cache, boolean checkPreInvalidationListener) {
        this.invalidateById(id, causeOfInvalidation, 5, waitOnInvalidation, true, true, cache, checkPreInvalidationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateById(Object id, int causeOfInvalidation, int sourceOfInvalidation, boolean waitOnInvalidation, boolean invokeInternalInvalidateById, boolean invokeDRSRenounce, DCache cache, boolean checkPreInvalidationListener) {
        if (checkPreInvalidationListener && cache.isEnableListener() && cache.getEventSource().getPreInvalidationListenerCount() > 0 && causeOfInvalidation != 2 && causeOfInvalidation != 8 && !cache.getEventSource().shouldInvalidate(id, sourceOfInvalidation, causeOfInvalidation)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("invalidateById() cacheName=" + cache.getCacheName() + " skip invalidation of id=" + id + " because PreInvalidationListener.shouldInvalidate() returns false."), (Object[])new Object[0]);
            }
            return;
        }
        BatchUpdateDaemon batchUpdateDaemon = this;
        synchronized (batchUpdateDaemon) {
            BatchUpdateList bul = this.getUpdateList(cache);
            InvalidateByIdEvent invalEvent = new InvalidateByIdEvent(id, causeOfInvalidation, sourceOfInvalidation, invokeInternalInvalidateById, invokeDRSRenounce, cache.getCacheName());
            invalEvent.setClassLoaderType(cache.getCacheConfig().isUseServerClassLoader());
            bul.invalidateByIdEvents.put(id, invalEvent);
        }
        if (waitOnInvalidation) {
            this.wakeUp(0L, 0L);
        }
    }

    public void invalidateById(Object id, boolean waitOnInvalidation, DCache cache) {
        this.invalidateById(id, 1, waitOnInvalidation, cache, true);
    }

    public synchronized void pushCacheEntry(CacheEntry cacheEntry, DCache cache) {
        BatchUpdateList bul = this.getUpdateList(cache);
        bul.pushCacheEntryEvents.add(cacheEntry);
    }

    public synchronized void pushExternalCacheFragment(ExternalInvalidation externalCacheFragment, DCache cache) {
        BatchUpdateList bul = this.getUpdateList(cache);
        bul.pushECFEvents.add(externalCacheFragment);
    }

    public synchronized void pushAliasEntry(AliasEntry aliasEntry, DCache cache) {
        BatchUpdateList bul = this.getUpdateList(cache);
        bul.aliasEntryEvents.add(aliasEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void wakeUp(long startDaemonTime, long startWakeUpTime) {
        try {
            BatchUpdateList[] currentUpdates;
            BatchUpdateDaemon batchUpdateDaemon = this;
            synchronized (batchUpdateDaemon) {
                int sz = this.updates.size();
                if (sz <= 0) return;
                currentUpdates = new BatchUpdateList[sz];
                this.updates.values().toArray(currentUpdates);
                this.updates.clear();
            }
            ArrayList pushCacheEntryList = new ArrayList();
            int i = 0;
            while (i < currentUpdates.length) {
                BatchUpdateList bul = null;
                try {
                    bul = currentUpdates[i];
                    pushCacheEntryList.addAll(bul.pushCacheEntryEvents);
                    this.cleanUpEventLists(bul.cache, bul.invalidateByIdEvents, bul.invalidateByTemplateEvents, bul.pushCacheEntryEvents, bul.pushECFEvents, bul.aliasEntryEvents);
                    if (bul.invalidateByIdEvents.size() > 0) {
                        this.invalidationAuditDaemon.registerInvalidations(bul.cache.getCacheName(), bul.invalidateByIdEvents.values().iterator());
                    }
                    if (bul.invalidateByTemplateEvents.size() > 0) {
                        this.invalidationAuditDaemon.registerInvalidations(bul.cache.getCacheName(), bul.invalidateByTemplateEvents.values().iterator());
                    }
                    if (bul.pushCacheEntryEvents.size() > 0) {
                        bul.pushCacheEntryEvents = this.invalidationAuditDaemon.filterEntryList(bul.cache.getCacheName(), bul.pushCacheEntryEvents);
                    }
                    if (bul.pushECFEvents.size() > 0) {
                        bul.pushECFEvents = this.invalidationAuditDaemon.filterExternalCacheFragmentList(bul.cache.getCacheName(), bul.pushECFEvents);
                    }
                    if (bul.invalidateByIdEvents.size() > 0 || bul.invalidateByTemplateEvents.size() > 0 || bul.pushCacheEntryEvents.size() > 0) {
                        RemoteServices remoteServices = bul.cache.getRemoteServices();
                        if (remoteServices.isDRSReady() && remoteServices.isDRSCongested()) {
                            HashMap cache = this.drsBuffer;
                            synchronized (cache) {
                                this.addToDRSBuffer(bul);
                                BatchUpdateList bufferList = (BatchUpdateList)this.drsBuffer.get(bul.cache);
                                if (null != bufferList) {
                                    for (CacheEntry ce : bufferList.pushCacheEntryEvents) {
                                        int index = pushCacheEntryList.indexOf(ce);
                                        if (index < 0) continue;
                                        pushCacheEntryList.remove(index);
                                    }
                                }
                            }
                        } else if (remoteServices.isDRSReady() && !remoteServices.isDRSCongested()) {
                            BatchUpdateList drsBufferList = (BatchUpdateList)this.drsBuffer.get(bul.cache);
                            BatchUpdateList mergedList = null;
                            if (drsBufferList != null) {
                                Iterator it;
                                try {
                                    it = this.drsBuffer;
                                    synchronized (it) {
                                        mergedList = this.mergeLists(drsBufferList, bul);
                                        this.drsBuffer.remove(bul.cache);
                                    }
                                    this.cleanUpEventLists(mergedList.cache, mergedList.invalidateByIdEvents, mergedList.invalidateByTemplateEvents, mergedList.pushCacheEntryEvents, mergedList.pushECFEvents, mergedList.aliasEntryEvents);
                                    remoteServices.batchUpdate(mergedList.invalidateByIdEvents, mergedList.invalidateByTemplateEvents, mergedList.pushCacheEntryEvents, mergedList.aliasEntryEvents);
                                }
                                finally {
                                    if (mergedList != null) {
                                        it = mergedList.pushCacheEntryEvents.iterator();
                                        while (it.hasNext()) {
                                            ((CacheEntry)it.next()).finish();
                                        }
                                    }
                                }
                            } else {
                                remoteServices.batchUpdate(bul.invalidateByIdEvents, bul.invalidateByTemplateEvents, bul.pushCacheEntryEvents, bul.aliasEntryEvents);
                            }
                        }
                    }
                    if (bul.invalidateByIdEvents.size() > 0 || bul.invalidateByTemplateEvents.size() > 0) {
                        bul.cache.batchUpdate(bul.invalidateByIdEvents, bul.invalidateByTemplateEvents, EMPTY_ARRAYLIST);
                    }
                    if ((bul.invalidateByIdEvents.size() > 0 || bul.invalidateByTemplateEvents.size() > 0 || bul.pushECFEvents.size() > 0) && this.externalCacheServices != null && (bul.cache.getCacheConfig().isEnableServletSupport() || bul.cache.getCacheConfig().isEnableInterCellInvalidation())) {
                        this.externalCacheServices.batchUpdate(bul.invalidateByIdEvents, bul.invalidateByTemplateEvents, bul.pushECFEvents);
                    }
                }
                finally {
                    Iterator pushCacheEntryIterator = pushCacheEntryList.iterator();
                    while (true) {
                        if (!pushCacheEntryIterator.hasNext()) {
                            pushCacheEntryList.clear();
                        }
                        ((CacheEntry)pushCacheEntryIterator.next()).finish();
                    }
                }
                ++i;
            }
            return;
        }
        finally {
            Map caches = ServerCache.getCacheInstances();
            Iterator i = caches.values().iterator();
            while (true) {
                if (!i.hasNext()) {
                }
                DCache cache = (DCache)i.next();
                cache.refreshCachePerf();
            }
        }
    }

    private void cleanUpEventLists(DCache cache, HashMap invalidateIdEvents, HashMap invalidateTemplateEvents, ArrayList pushEntryEvents, ArrayList pushECFEvents, ArrayList aliasEntryEvents) {
        Object template;
        Iterator<Object> it = invalidateIdEvents.values().iterator();
        while (it.hasNext()) {
            InvalidateByIdEvent invalidateByIdEvent = (InvalidateByIdEvent)it.next();
            Object id = invalidateByIdEvent.getId();
            CacheEntry cacheEntry = cache.getEntryFromMemory(id);
            if (cacheEntry == null || invalidateByIdEvent.getTimeStamp() >= cacheEntry.getTimeStamp() || !invalidateByIdEvent.isInvokeDRSRenounce()) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cleanUpEventLists(): Filtered out InvalidateByIdEvent when cache entry is newer in memory cache. cacheName=" + cache.getCacheName() + " id=" + id), (Object[])new Object[0]);
            }
            it.remove();
        }
        it = pushEntryEvents.iterator();
        while (it.hasNext()) {
            Enumeration e;
            InvalidateByIdEvent invalidateByIdEvent;
            boolean remove = false;
            CacheEntry cacheEntry = (CacheEntry)it.next();
            if (invalidateIdEvents.containsKey(cacheEntry.getIdObject()) && (invalidateByIdEvent = (InvalidateByIdEvent)invalidateIdEvents.get(cacheEntry.getIdObject())).isInvokeDRSRenounce()) {
                remove = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cleanUpEventLists(): Filtered out pushEntryEvents when id is n invalidation list. cacheName=" + cache.getCacheName() + " id=" + cacheEntry.getIdObject()), (Object[])new Object[0]);
                }
            }
            if (!remove) {
                e = cacheEntry.getDataIds();
                while (e.hasMoreElements()) {
                    Object did = e.nextElement();
                    if (!invalidateIdEvents.containsKey(did)) continue;
                    remove = true;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("cleanUpEventLists(): Filtered out pushEntryEvents when dependency id is in invalidation list. cacheName=" + cache.getCacheName() + " id=" + cacheEntry.getIdObject() + " depid=" + did), (Object[])new Object[0]);
                    break;
                }
            }
            if (!remove) {
                e = cacheEntry.getTemplates();
                while (e.hasMoreElements()) {
                    template = e.nextElement();
                    if (!invalidateIdEvents.containsKey(template)) continue;
                    remove = true;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("cleanUpEventLists(): Filtered out pushEntryEvents when template is in invalidation list. cacheName=" + cache.getCacheName() + " id=" + cacheEntry.getIdObject() + " template=" + template), (Object[])new Object[0]);
                    break;
                }
            }
            if (!remove && !cacheEntry.prepareForSerialization()) {
                remove = true;
            }
            if (!remove) continue;
            it.remove();
        }
        it = aliasEntryEvents.iterator();
        while (it.hasNext()) {
            boolean remove = false;
            AliasEntry aliasEntry = (AliasEntry)it.next();
            if (invalidateIdEvents.containsKey(aliasEntry.id)) {
                remove = true;
            } else {
                for (CacheEntry cacheEntry : pushEntryEvents) {
                    if (!cacheEntry.getIdObject().equals(aliasEntry.id) || cacheEntry.getTimeStamp() <= aliasEntry.getTimeStamp()) continue;
                    remove = true;
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("cleanUpEventLists(): Filtered out aliasEntryEvents when cache entry is newer than alias request. cacheName=" + cache.getCacheName() + " id=" + cacheEntry.getIdObject()), (Object[])new Object[0]);
                    break;
                }
            }
            if (!remove) continue;
            it.remove();
        }
        it = pushECFEvents.iterator();
        while (it.hasNext()) {
            boolean remove = false;
            ExternalInvalidation externalCacheFragment = (ExternalInvalidation)it.next();
            Enumeration enumeration = externalCacheFragment.getTemplates();
            while (!remove && enumeration.hasMoreElements()) {
                template = (String)enumeration.nextElement();
                if (!invalidateTemplateEvents.containsKey(template)) continue;
                remove = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("cleanUpEventLists(): Filtered out pushECFEvents when template is in invalidation list. cacheName=" + cache.getCacheName() + " template=" + template), (Object[])new Object[0]);
            }
            enumeration = externalCacheFragment.getInvalidationIds();
            while (!remove && enumeration.hasMoreElements()) {
                String id = (String)enumeration.nextElement();
                if (!invalidateIdEvents.containsKey(id)) continue;
                remove = true;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("cleanUpEventLists(): Filtered out pushECFEvents when invalidation id is in invalidation list. cacheName=" + cache.getCacheName() + " ide=" + id), (Object[])new Object[0]);
            }
            if (!remove) continue;
            it.remove();
        }
    }

    private final BatchUpdateList getUpdateList(DCache cache) {
        BatchUpdateList bul = (BatchUpdateList)this.updates.get(cache);
        if (bul == null) {
            bul = new BatchUpdateList();
            bul.cache = cache;
            if (cache.getCacheConfig().isDefaultCacheProvider()) {
                this.updates.put(cache, bul);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WARNING getUpdateList called for " + cache.getCacheName()), (Object[])new Object[0]);
            }
        }
        return bul;
    }

    private void addToDRSBuffer(BatchUpdateList newList) {
        if (newList != null) {
            BatchUpdateList oldList = (BatchUpdateList)this.drsBuffer.get(newList.cache);
            if (oldList != null) {
                DCache cache = newList.cache;
                BatchUpdateList list = this.mergeLists(oldList, newList);
                int thresholdSize = cache.getCacheConfig().getCacheSize() / 20;
                int size = list.aliasEntryEvents.size() + list.invalidateByIdEvents.size() + list.invalidateByTemplateEvents.size() + list.pushCacheEntryEvents.size();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("list.congestionCount: " + list.congestionCount), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)"drsCongestionThreshold: 5", (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("size: " + size), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("thresholdSize: " + thresholdSize), (Object[])new Object[0]);
                }
                if (list.congestionCount++ > 5 && size > thresholdSize) {
                    Tr.event((TraceComponent)tc, (String)("Disabling replication due to DRS congestion for cache instance: " + list.cache.getCacheName() + ", invalidatedByIdEvents:" + list.invalidateByIdEvents.size() + " invalidateByTemplateEvents:" + list.invalidateByTemplateEvents.size() + " pushCacheEntryEvents:" + list.pushCacheEntryEvents.size() + " aliasEntryEvents:" + list.aliasEntryEvents.size()), (Object[])new Object[0]);
                    list.cache.getCacheConfig().setDrsDisabled(true);
                    this.drsBuffer.remove(list.cache);
                } else {
                    this.drsBuffer.put(list.cache, list);
                }
            } else {
                this.drsBuffer.put(newList.cache, newList);
            }
        }
    }

    private BatchUpdateList mergeLists(BatchUpdateList bufferedList, BatchUpdateList currentList) {
        BatchUpdateList mergedList = new BatchUpdateList();
        mergedList.cache = bufferedList.cache;
        mergedList.congestionCount = bufferedList.congestionCount;
        if (bufferedList.invalidateByIdEvents.size() > 0) {
            mergedList.invalidateByIdEvents.putAll(bufferedList.invalidateByIdEvents);
        }
        if (currentList.invalidateByIdEvents.size() > 0) {
            mergedList.invalidateByIdEvents.putAll(currentList.invalidateByIdEvents);
        }
        bufferedList.invalidateByIdEvents.clear();
        if (bufferedList.invalidateByTemplateEvents.size() > 0) {
            mergedList.invalidateByTemplateEvents.putAll(bufferedList.invalidateByTemplateEvents);
        }
        if (currentList.invalidateByTemplateEvents.size() > 0) {
            mergedList.invalidateByTemplateEvents.putAll(currentList.invalidateByTemplateEvents);
        }
        bufferedList.invalidateByTemplateEvents.clear();
        ArrayList<CacheEntry> toBeRemoved = new ArrayList<CacheEntry>();
        for (CacheEntry ce : currentList.pushCacheEntryEvents) {
            for (CacheEntry drsEntry : bufferedList.pushCacheEntryEvents) {
                if (drsEntry == null || !drsEntry.getIdObject().equals(ce.getIdObject())) continue;
                toBeRemoved.add(drsEntry);
            }
        }
        bufferedList.pushCacheEntryEvents.removeAll(toBeRemoved);
        toBeRemoved.clear();
        mergedList.pushCacheEntryEvents.addAll(bufferedList.pushCacheEntryEvents);
        mergedList.pushCacheEntryEvents.addAll(currentList.pushCacheEntryEvents);
        bufferedList.pushCacheEntryEvents.clear();
        for (AliasEntry ae : currentList.aliasEntryEvents) {
            for (CacheEntry drsEntry : bufferedList.aliasEntryEvents) {
                if (drsEntry == null || !((AliasEntry)drsEntry).id.equals(ae.id)) continue;
                toBeRemoved.add(drsEntry);
            }
        }
        bufferedList.aliasEntryEvents.removeAll(toBeRemoved);
        toBeRemoved.clear();
        mergedList.aliasEntryEvents.addAll(bufferedList.aliasEntryEvents);
        mergedList.aliasEntryEvents.addAll(currentList.aliasEntryEvents);
        bufferedList.aliasEntryEvents.clear();
        return mergedList;
    }

    static class BatchUpdateList {
        public DCache cache;
        public int congestionCount = 0;
        public HashMap invalidateByIdEvents = new HashMap();
        public HashMap invalidateByTemplateEvents = new HashMap();
        public ArrayList pushCacheEntryEvents = new ArrayList();
        public ArrayList pushECFEvents = new ArrayList();
        public ArrayList aliasEntryEvents = new ArrayList();

        BatchUpdateList() {
        }
    }
}

