/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.el.MethodExpression;
import jakarta.faces.application.NavigationCase;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.FlowCallNode;
import jakarta.faces.flow.FlowNode;
import jakarta.faces.flow.MethodCallNode;
import jakarta.faces.flow.Parameter;
import jakarta.faces.flow.ReturnNode;
import jakarta.faces.flow.SwitchNode;
import jakarta.faces.flow.ViewNode;
import jakarta.faces.lifecycle.ClientWindow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.flow.Freezable;

public class FlowImpl
extends Flow
implements Freezable {
    private MethodExpression initializer;
    private MethodExpression finalizer;
    private String startNodeId;
    private String id;
    private String definingDocumentId;
    private Map<String, FlowNode> flowNodeMap = new HashMap<String, FlowNode>();
    private Map<String, Parameter> inboundParametersMap = new HashMap<String, Parameter>();
    private Map<String, FlowCallNode> flowCallsMap = new HashMap<String, FlowCallNode>();
    private List<MethodCallNode> methodCallsList = new ArrayList<MethodCallNode>();
    private Map<String, ReturnNode> returnsMap = new HashMap<String, ReturnNode>();
    private Map<String, SwitchNode> switchesMap = new HashMap<String, SwitchNode>();
    private List<ViewNode> viewsList = new ArrayList<ViewNode>();
    private Map<String, Parameter> unmodifiableInboundParametersMap;
    private Map<String, FlowCallNode> unmodifiableFlowCallsMap;
    private List<MethodCallNode> unmodifiableMethodCallsList;
    private Map<String, ReturnNode> unmodifiableReturnsMap;
    private Map<String, SwitchNode> unmodifiableSwitchesMap;
    private List<ViewNode> unmodifiableViewsList;
    private Map<String, Set<NavigationCase>> navigationCases = new HashMap<String, Set<NavigationCase>>();
    private Map<String, Set<NavigationCase>> unmodifiableNavigationCases;
    private boolean initialized;

    public FlowImpl() {
        this.unmodifiableInboundParametersMap = Collections.unmodifiableMap(this.inboundParametersMap);
        this.unmodifiableFlowCallsMap = Collections.unmodifiableMap(this.flowCallsMap);
        this.unmodifiableMethodCallsList = Collections.unmodifiableList(this.methodCallsList);
        this.unmodifiableReturnsMap = Collections.unmodifiableMap(this.returnsMap);
        this.unmodifiableSwitchesMap = Collections.unmodifiableMap(this.switchesMap);
        this.unmodifiableViewsList = Collections.unmodifiableList(this.viewsList);
        this.unmodifiableNavigationCases = Collections.unmodifiableMap(this.navigationCases);
    }

    @Override
    public void freeze() {
        this.initialized = true;
        for (Map.Entry<String, Parameter> entry : this.inboundParametersMap.entrySet()) {
            if (!(entry.getValue() instanceof Freezable)) continue;
            ((Freezable)entry.getValue()).freeze();
        }
        for (Map.Entry<String, Parameter> entry : this.flowCallsMap.entrySet()) {
            if (!(entry.getValue() instanceof Freezable)) continue;
            ((Freezable)entry.getValue()).freeze();
        }
        for (MethodCallNode methodCallNode : this.methodCallsList) {
            if (!(methodCallNode instanceof Freezable)) continue;
            ((Freezable)methodCallNode).freeze();
        }
        for (Map.Entry<String, Parameter> entry : this.returnsMap.entrySet()) {
            if (!(entry.getValue() instanceof Freezable)) continue;
            ((Freezable)entry.getValue()).freeze();
        }
        for (Map.Entry<String, Parameter> entry : this.switchesMap.entrySet()) {
            if (!(entry.getValue() instanceof Freezable)) continue;
            ((Freezable)entry.getValue()).freeze();
        }
        for (ViewNode viewNode : this.viewsList) {
            if (!(viewNode instanceof Freezable)) continue;
            ((Freezable)viewNode).freeze();
        }
    }

    public String getClientWindowFlowId(ClientWindow curWindow) {
        String id = this.getId();
        String documentId = this.getDefiningDocumentId();
        String windowId = curWindow.getId();
        StringBuilder sb = new StringBuilder(id.length() + 1 + windowId.length());
        sb.append(windowId).append('_').append(documentId).append('_').append(id);
        return sb.toString();
    }

    public String getDefiningDocumentId() {
        return this.definingDocumentId;
    }

    public void setDefiningDocumentId(String definingDocumentId) {
        this.checkInitialized();
        this.definingDocumentId = definingDocumentId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.checkInitialized();
        this.id = id;
    }

    public MethodExpression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(MethodExpression initializer) {
        this.checkInitialized();
        this.initializer = initializer;
    }

    public MethodExpression getFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(MethodExpression finalizer) {
        this.checkInitialized();
        this.finalizer = finalizer;
    }

    public String getStartNodeId() {
        return this.startNodeId;
    }

    public void setStartNodeId(String startNodeId) {
        this.checkInitialized();
        this.startNodeId = startNodeId;
    }

    public Map<String, Parameter> getInboundParameters() {
        return this.unmodifiableInboundParametersMap;
    }

    public void putInboundParameter(String key, Parameter value) {
        this.checkInitialized();
        this.inboundParametersMap.put(key, value);
    }

    public Map<String, FlowCallNode> getFlowCalls() {
        return this.unmodifiableFlowCallsMap;
    }

    public void putFlowCall(String key, FlowCallNode value) {
        this.checkInitialized();
        this.flowCallsMap.put(key, value);
        this.flowNodeMap.put(value.getId(), (FlowNode)value);
    }

    public List<MethodCallNode> getMethodCalls() {
        return this.unmodifiableMethodCallsList;
    }

    public void addMethodCall(MethodCallNode value) {
        this.checkInitialized();
        this.methodCallsList.add(value);
        this.flowNodeMap.put(value.getId(), (FlowNode)value);
    }

    public Map<String, ReturnNode> getReturns() {
        return this.unmodifiableReturnsMap;
    }

    public void putReturn(String key, ReturnNode value) {
        this.checkInitialized();
        this.returnsMap.put(key, value);
        this.flowNodeMap.put(value.getId(), (FlowNode)value);
    }

    public Map<String, SwitchNode> getSwitches() {
        return this.unmodifiableSwitchesMap;
    }

    public void putSwitch(String key, SwitchNode value) {
        this.checkInitialized();
        this.switchesMap.put(key, value);
        this.flowNodeMap.put(value.getId(), (FlowNode)value);
    }

    public List<ViewNode> getViews() {
        return this.unmodifiableViewsList;
    }

    public void addView(ViewNode value) {
        this.checkInitialized();
        this.viewsList.add(value);
        this.flowNodeMap.put(value.getId(), (FlowNode)value);
    }

    public FlowCallNode getFlowCall(Flow targetFlow) {
        FacesContext facesContext = null;
        for (Map.Entry<String, FlowCallNode> entry : this.flowCallsMap.entrySet()) {
            if (facesContext == null) {
                facesContext = FacesContext.getCurrentInstance();
            }
            String calledDocumentId = entry.getValue().getCalledFlowDocumentId(facesContext);
            String calledFlowId = entry.getValue().getCalledFlowId(facesContext);
            if (!targetFlow.getDefiningDocumentId().equals(calledDocumentId) || !targetFlow.getId().equals(calledFlowId)) continue;
            return entry.getValue();
        }
        return null;
    }

    public FlowNode getNode(String nodeId) {
        return this.flowNodeMap.get(nodeId);
    }

    public void addNavigationCases(String fromViewId, Set<NavigationCase> navigationCases) {
        this.checkInitialized();
        Set navigationCaseSet = this.navigationCases.computeIfAbsent(fromViewId, k -> new HashSet());
        navigationCaseSet.addAll(navigationCases);
    }

    public void addNavigationCase(NavigationCase navigationCase) {
        this.checkInitialized();
        Set navigationCaseSet = this.navigationCases.computeIfAbsent(navigationCase.getFromViewId(), k -> new HashSet());
        navigationCaseSet.add(navigationCase);
    }

    public void removeNavigationCase(NavigationCase navigationCase) {
        this.checkInitialized();
        Set<NavigationCase> navigationCaseSet = this.navigationCases.get(navigationCase.getFromViewId());
        if (navigationCaseSet == null) {
            return;
        }
        navigationCaseSet.remove(navigationCase);
    }

    private void checkInitialized() throws IllegalStateException {
        if (this.initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        return this.unmodifiableNavigationCases;
    }
}

