/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.config.CommonConfigUtils;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ConfigUtils {
    private static final TraceComponent tc = Tr.register(ConfigUtils.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.common.internal.resources.OidcCommonMessages");
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef;
    private final CommonConfigUtils commonConfigUtils = new CommonConfigUtils();
    public static final String CFG_KEY_SCOPE_TO_CLAIM_MAP = "scopeToClaimMap";
    public static final String CFG_KEY_CLAIM_TO_UR_MAP = "claimToUserRegistryMap";
    public static final String CFG_KEY_DISCOVERY = "discovery";
    public static final String CFG_VALUES_DELIMITER = ",";
    private static HashMap<String, String[]> defaultDiscoveryProperties = new HashMap();
    private static boolean defaultDiscoveryClaimsParmSupp;
    private static boolean defaultDiscoveryRequestParmSupp;
    private static boolean defaultDiscoveryRequestUriParmSupp;
    private static boolean defaultDiscoveryRequireRequestUriRegistrationSupp;
    public static final String KEY_OIDC_ISSUER_ID = "issuerIdentifier";
    public static final String KEY_OIDC_AUTHORIZATION_EP = "authorizationEndpoint";
    public static final String KEY_OIDC_TOKEN_EP = "tokenEndpoint";
    public static final String KEY_OIDC_JWKS_URI = "jwksURI";
    public static final String KEY_OIDC_RESPONSE_TYPES_SUPP = "responseTypesSupported";
    public static final String KEY_OIDC_SUB_TYPES_SUPP = "subjectTypesSupported";
    public static final String KEY_OIDC_ID_TOKEN_SIGNING_ALG_VAL_SUPP = "idTokenSigningAlgValuesSupported";
    public static final String KEY_OIDC_USERINFO_EP = "userinfoEndpoint";
    public static final String KEY_OIDC_REGISTRATION_EP = "registrationEndpoint";
    public static final String KEY_OIDC_SCOPES_SUPP = "scopesSupported";
    public static final String KEY_OIDC_CLAIMS_SUPP = "claimsSupported";
    public static final String KEY_OIDC_RESP_MODES_SUPP = "responseModesSupported";
    public static final String KEY_OIDC_GRANT_TYPES_SUPP = "grantTypesSupported";
    public static final String KEY_OIDC_TOKEN_EP_AUTH_METHODS_SUPP = "tokenEndpointAuthMethodsSupported";
    public static final String KEY_OIDC_DISPLAY_VAL_SUPP = "displayValuesSupported";
    public static final String KEY_OIDC_CLAIM_TYPES_SUPP = "claimTypesSupported";
    public static final String KEY_OIDC_CLAIM_PARAM_SUPP = "claimsParameterSupported";
    public static final String KEY_OIDC_REQ_PARAM_SUPP = "requestParameterSupported";
    public static final String KEY_OIDC_REQ_URI_PARAM_SUPP = "requestUriParameterSupported";
    public static final String KEY_OIDC_REQUIRE_REQ_URI_REGISTRATION = "requireRequestUriRegistration";
    public static final String KEY_OIDC_CHECK_SESSION_IFRAME = "checkSessionIframe";
    public static final String KEY_OIDC_END_SESSION_EP = "endSessionEndpoint";
    public static final String KEY_OIDC_INTROSPECTION_EP = "introspectionEndpoint";
    public static final String KEY_OIDC_COVERAGE_MAP_EP = "coverageMapEndpoint";
    public static final String KEY_OIDC_PROXY_EP = "proxyEndpoint";
    public static final String KEY_OIDC_BACKING_IDP_URI_PREFIX = "backingIdpUriPrefix";
    private static HashMap<String, String[]> specScopesToClaims;
    private static final HashSet<String> specDefinedScopes;
    private static HashMap<String, String> defaultClaimsToVMMProperties;
    private static final HashSet<String> supportedSpecDefinedClaims;
    static final long serialVersionUID = -7442890485645278227L;

    private static void setDefaultDiscoveryProperties() {
        defaultDiscoveryProperties.put(KEY_OIDC_RESPONSE_TYPES_SUPP, new String[]{"code", "token", "id_token token"});
        defaultDiscoveryProperties.put(KEY_OIDC_SUB_TYPES_SUPP, new String[]{"public"});
        defaultDiscoveryProperties.put(KEY_OIDC_ID_TOKEN_SIGNING_ALG_VAL_SUPP, new String[]{"HS256"});
        defaultDiscoveryProperties.put(KEY_OIDC_SCOPES_SUPP, new String[]{"openid", "general", "profile", "email", "address", "phone"});
        defaultDiscoveryProperties.put(KEY_OIDC_CLAIMS_SUPP, new String[]{"sub", "groupIds", "name", "preferred_username", "picture", "locale", "email", "profile"});
        defaultDiscoveryProperties.put(KEY_OIDC_RESP_MODES_SUPP, new String[]{"query", "fragment", "form_post"});
        defaultDiscoveryProperties.put(KEY_OIDC_GRANT_TYPES_SUPP, new String[]{"authorization_code", "implicit", "refresh_token", "client_credentials", "password", "urn:ietf:params:oauth:grant-type:jwt-bearer"});
        defaultDiscoveryProperties.put(KEY_OIDC_TOKEN_EP_AUTH_METHODS_SUPP, new String[]{"client_secret_post", "client_secret_basic"});
        defaultDiscoveryProperties.put(KEY_OIDC_DISPLAY_VAL_SUPP, new String[]{"page"});
        defaultDiscoveryProperties.put(KEY_OIDC_CLAIM_TYPES_SUPP, new String[]{"normal"});
        defaultDiscoveryClaimsParmSupp = false;
        defaultDiscoveryRequestParmSupp = false;
        defaultDiscoveryRequestUriParmSupp = false;
        defaultDiscoveryRequireRequestUriRegistrationSupp = false;
    }

    public ConfigUtils(AtomicServiceReference<ConfigurationAdmin> configAdminRef) {
        this.configAdminRef = configAdminRef;
    }

    public Properties processDiscoveryProps(Map<String, Object> props, String elementNameRef) {
        if (props.get(elementNameRef) == null || ((String)props.get(elementNameRef)).isEmpty()) {
            Properties properties = new Properties();
            for (String key : defaultDiscoveryProperties.keySet()) {
                properties.put(key, defaultDiscoveryProperties.get(key));
            }
            properties.put(KEY_OIDC_CLAIM_PARAM_SUPP, (Object)defaultDiscoveryClaimsParmSupp);
            properties.put(KEY_OIDC_REQ_PARAM_SUPP, (Object)defaultDiscoveryRequestParmSupp);
            properties.put(KEY_OIDC_REQ_URI_PARAM_SUPP, (Object)defaultDiscoveryRequestUriParmSupp);
            properties.put(KEY_OIDC_REQUIRE_REQ_URI_REGISTRATION, (Object)defaultDiscoveryRequireRequestUriRegistrationSupp);
            return properties;
        }
        return this.processProps(props, elementNameRef);
    }

    public Properties processProps(Map<String, Object> props, String elementNameRef) {
        Properties properties = new Properties();
        String pid = (String)props.get(elementNameRef);
        if (pid == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"pid null", (Object[])new Object[0]);
            }
        } else {
            ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getServiceWithException();
            Configuration config = null;
            try {
                Configuration[] configList = configAdmin.listConfigurations(FilterUtils.createPropertyFilter((String)"service.pid", (String)pid));
                if (configList != null && configList.length > 0) {
                    config = configAdmin.getConfiguration(pid, this.configAdminRef.getReference().getBundle().getLocation());
                }
            }
            catch (Exception configList) {
                FFDCFilter.processException((Throwable)configList, (String)"com.ibm.ws.security.openidconnect.clients.common.ConfigUtils", (String)"208", (Object)this, (Object[])new Object[]{props, elementNameRef});
            }
            if (config != null) {
                Dictionary cProps = config.getProperties();
                Enumeration keys = cProps.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("found key: " + key), (Object[])new Object[0]);
                    }
                    if (key.startsWith(".") || key.startsWith("config.") || key.startsWith("service.") || key.equals("id") || key.startsWith("osgi.ds.")) continue;
                    Object value = cProps.get(key);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("key: " + key + " value: " + value), (Object[])new Object[0]);
                    }
                    value = this.getValue(value);
                    properties.put(key, value);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(elementNameRef + ": " + properties.toString()), (Object[])new Object[0]);
        }
        return properties;
    }

    public Properties processFlatProps(Map<String, Object> props, String elementName) {
        Properties properties;
        block8: {
            block7: {
                Map elementProps;
                properties = new Properties();
                List listOfPropMaps = Nester.nest((String)elementName, props);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("listOfPropMaps: " + listOfPropMaps), (Object[])new Object[0]);
                }
                if (!listOfPropMaps.isEmpty() && (elementProps = (Map)listOfPropMaps.get(0)) != null) {
                    this.getConfigProperties(elementProps, properties, elementName);
                    listOfPropMaps = Nester.nest((String)"property", (Map)elementProps);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("subelement listOfPropMaps: " + listOfPropMaps), (Object[])new Object[0]);
                    }
                    if (!listOfPropMaps.isEmpty()) {
                        HashMap<String, Object> subElementProps = new HashMap<String, Object>();
                        for (Map propMap : listOfPropMaps) {
                            subElementProps.put((String)propMap.get("name"), (String)propMap.get("value"));
                        }
                        this.getConfigProperties(subElementProps, properties, elementName);
                    }
                }
                if (!elementName.equals(CFG_KEY_SCOPE_TO_CLAIM_MAP)) break block7;
                for (String scope : specDefinedScopes) {
                    if (properties.containsKey(scope)) continue;
                    properties.put(scope, specScopesToClaims.get(scope));
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("adding default claims for scope " + scope + " : " + Arrays.toString(specScopesToClaims.get(scope))), (Object[])new Object[0]);
                }
                break block8;
            }
            if (!elementName.equals(CFG_KEY_CLAIM_TO_UR_MAP)) break block8;
            for (String claim : supportedSpecDefinedClaims) {
                if (properties.containsKey(claim)) continue;
                properties.put(claim, defaultClaimsToVMMProperties.get(claim));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("adding default vmm property for claim " + claim + " : " + defaultClaimsToVMMProperties.get(claim)), (Object[])new Object[0]);
            }
        }
        return properties;
    }

    private void getConfigProperties(Map<String, Object> configProps, Properties properties, String elementName) {
        Set<Map.Entry<String, Object>> entries = configProps.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            String key = entry.getKey();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found key: " + key), (Object[])new Object[0]);
            }
            if (key.startsWith(".") || key.startsWith("config.") || key.startsWith("service.") || key.startsWith("property.") || key.equals("id") || key.startsWith("osgi.ds.")) continue;
            String[] value = entry.getValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("key: " + key + " value: " + value), (Object[])new Object[0]);
            }
            if (elementName.equals(CFG_KEY_SCOPE_TO_CLAIM_MAP)) {
                String[] valuesArray = ((String)value).split(CFG_VALUES_DELIMITER);
                for (int i = 0; i < valuesArray.length; ++i) {
                    valuesArray[i] = valuesArray[i].trim();
                }
                value = valuesArray;
            } else {
                value = this.getValue(value);
            }
            properties.put(key, value);
        }
    }

    private Object getValue(Object value) {
        if (value != null) {
            if (value instanceof String) {
                return ((String)value).trim();
            }
            if (value instanceof String[]) {
                return value;
            }
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof Long) {
                return value;
            }
        }
        return value;
    }

    public List<String> readAndSanitizeForwardLoginParameter(Map<String, Object> props, String configId, String configAttributeName) {
        String[] attributeValue = this.commonConfigUtils.getStringArrayConfigAttribute(props, configAttributeName);
        if (attributeValue == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> configuredForwardAuthzParamList = new ArrayList<String>(Arrays.asList(attributeValue));
        return this.removeDisallowedForwardAuthzParametersFromConfiguredList(configuredForwardAuthzParamList, configId, configAttributeName);
    }

    List<String> removeDisallowedForwardAuthzParametersFromConfiguredList(List<String> configuredList, String configId, String configAttributeName) {
        if (configuredList == null) {
            return new ArrayList<String>();
        }
        HashSet<String> configuredDisallowedParameters = new HashSet<String>(configuredList);
        configuredDisallowedParameters.retainAll(this.getDisallowedForwardAuthzParameterNames());
        if (!configuredDisallowedParameters.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"DISALLOWED_FORWARD_AUTHZ_PARAMS_CONFIGURED", (Object[])new Object[]{configId, configuredDisallowedParameters, configAttributeName});
            configuredList.removeAll(configuredDisallowedParameters);
        }
        return configuredList;
    }

    Set<String> getDisallowedForwardAuthzParameterNames() {
        HashSet<String> disallowedParamNames = new HashSet<String>();
        disallowedParamNames.add("redirect_uri");
        disallowedParamNames.add("client_id");
        disallowedParamNames.add("response_type");
        disallowedParamNames.add("nonce");
        disallowedParamNames.add("state");
        disallowedParamNames.add("scope");
        return disallowedParamNames;
    }

    public void populateCustomRequestParameterMap(ConfigurationAdmin configAdmin, HashMap<String, String> paramMapToPopulate, String[] configuredCustomRequestParams, String configAttrName, String configAttrValue) {
        if (configuredCustomRequestParams == null) {
            return;
        }
        for (String configuredParameter : configuredCustomRequestParams) {
            Configuration config;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Configured custom request param [" + configuredParameter + "]"), (Object[])new Object[0]);
            }
            if ((config = this.getConfigurationFromConfigAdmin(configAdmin, configuredParameter)) == null) continue;
            this.addCustomRequestParameterValueToMap(config, paramMapToPopulate, configAttrName, configAttrValue);
        }
    }

    Configuration getConfigurationFromConfigAdmin(ConfigurationAdmin configAdmin, String configParameter) {
        Configuration config = null;
        try {
            config = configAdmin.getConfiguration(configParameter, "");
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.openidconnect.clients.common.ConfigUtils", (String)"431", (Object)this, (Object[])new Object[]{configAdmin, configParameter});
        }
        return config;
    }

    @FFDCIgnore(value={ClassCastException.class})
    void addCustomRequestParameterValueToMap(Configuration config, HashMap<String, String> paramMapToPopulate, String configAttrName, String configAttrValue) {
        Dictionary configProps = config.getProperties();
        if (configProps == null || configAttrName == null || configAttrValue == null) {
            return;
        }
        String paramName = null;
        String paramValue = null;
        try {
            paramName = (String)configProps.get(configAttrName);
            paramValue = (String)configProps.get(configAttrValue);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (paramName != null && paramValue != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding parameter name [" + paramName + "] and value [" + paramValue + "] to map"), (Object[])new Object[0]);
            }
            if (paramMapToPopulate == null) {
                paramMapToPopulate = new HashMap();
            }
            paramMapToPopulate.put(paramName, paramValue);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        specScopesToClaims = new HashMap();
        specDefinedScopes = new HashSet<String>(Arrays.asList("profile", "email", "address", "phone"));
        defaultClaimsToVMMProperties = new HashMap();
        supportedSpecDefinedClaims = new HashSet<String>(Arrays.asList("name", "given_name", "picture", "email", "address", "phone_number"));
        specScopesToClaims.put("profile", new String[]{"name", "family_name", "given_name", "middle_name", "nickname", "preferred_username", "profile", "picture", "website", "gender", "birthdate", "zoneinfo", "locale", "updated_at"});
        specScopesToClaims.put("email", new String[]{"email", "email_verified"});
        specScopesToClaims.put("address", new String[]{"address"});
        specScopesToClaims.put("phone", new String[]{"phone_number", "phone_number_verified"});
        defaultClaimsToVMMProperties.put("name", "displayName");
        defaultClaimsToVMMProperties.put("given_name", "givenName");
        defaultClaimsToVMMProperties.put("picture", "photoURL");
        defaultClaimsToVMMProperties.put("email", "mail");
        defaultClaimsToVMMProperties.put("address", "postalAddress");
        defaultClaimsToVMMProperties.put("phone_number", "telephoneNumber");
        ConfigUtils.setDefaultDiscoveryProperties();
    }
}

