/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.internal.OAuthUtil;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.exception.OAuthProviderException;
import com.ibm.ws.security.oauth20.platform.PlatformServiceFactory;
import com.ibm.ws.security.oauth20.plugins.BaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.OAuth20ProviderUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class ClientUtils {
    private static TraceComponent tc = Tr.register(ClientUtils.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final String CLIENT_XML_FILE = "base.clients.xml";
    public static final int DEFAULT_SECRET_LENGTH = 60;
    public static final HashMap<String, HashMap<String, String>> uriRewrites = new HashMap();
    static final long serialVersionUID = -8122262083760844737L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public ClientUtils() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static String generateClientSecret() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generateClientSecret", (Object)new Object[0]);
        }
        String string = ClientUtils.generateClientSecret(60);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((TraceComponent)tc, (String)"generateClientSecret", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static String generateClientSecret(int length) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"generateClientSecret", (Object)new Object[]{length});
        }
        String string = OAuthUtil.getRandom(length);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((TraceComponent)tc, (String)"generateClientSecret", (Object)string);
        }
        return string;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static void storeClients(Collection<BaseClient> clients) throws OAuthProviderException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeClients");
        }
        String ls = System.getProperty("line.separator");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + ls;
        xml = xml + "<OAuthClientConfiguration>" + ls;
        for (BaseClient client : clients) {
            xml = xml + "  <";
            xml = xml + "client id=\"" + client.getClientId() + "\" ";
            xml = xml + "component=\"" + client.getComponentId() + "\" ";
            xml = xml + "secret=\"" + PasswordUtil.passwordEncode((String)client.getClientSecret()) + "\" ";
            xml = xml + "displayname=\"" + client.getClientName() + "\" ";
            xml = xml + "redirect=\"" + client.getRedirectUris() + "\" ";
            xml = xml + "enabled=\"" + client.isEnabled() + "\">";
            xml = xml + ls + "  </" + "client" + ">" + ls;
        }
        xml = xml + "</OAuthClientConfiguration>" + ls;
        ClientUtils.storeXmlClients(xml);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"storeClients");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static synchronized void storeXmlClients(String xml) throws OAuthProviderException {
        File f;
        File targetDir;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"storeXmlClients");
        }
        if (!(targetDir = new File(OAuth20ProviderUtils.OAuthConfigFileDir)).exists()) {
            targetDir.mkdir();
        }
        if (!(f = new File(targetDir, CLIENT_XML_FILE)).exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.util.ClientUtils", (String)"138", null, (Object[])new Object[]{xml});
                throw new OAuthProviderException((Exception)e);
            }
        }
        if (!f.canWrite()) {
            throw new OAuthProviderException("Cannot write: " + f.getAbsolutePath());
        }
        try {
            BufferedWriter buffer = new BufferedWriter(new FileWriter(f));
            buffer.write(xml);
            buffer.close();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.util.ClientUtils", (String)"151", null, (Object[])new Object[]{xml});
            throw new OAuthProviderException((Exception)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"storeXmlClients");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static synchronized void deleteClientFile() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteClientFile", (Object)new Object[0]);
        }
        File f = new File(OAuth20ProviderUtils.OAuthConfigFileDir, CLIENT_XML_FILE);
        f.delete();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteClientFile");
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static synchronized boolean initRewrites(OAuthComponentConfiguration config) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initRewrites");
        }
        String providerID = config.getUniqueId();
        String[] providerRewrites = config.getConfigPropertyValues("oauth20.client.uri.substitutions");
        boolean hasRewrites = ClientUtils.initRewrites(providerID, providerRewrites);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initRewrites");
        }
        return hasRewrites;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static synchronized boolean initRewrites(String providerID, String[] providerRewrites) {
        boolean hasRewrites;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initRewrites");
        }
        boolean bl = hasRewrites = providerRewrites != null && providerRewrites.length > 0;
        if (hasRewrites) {
            HashMap<String, String> rewriteMap = new HashMap<String, String>();
            String[] stringArray = providerRewrites;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String key;
                String newValue = key = stringArray[i];
                try {
                    newValue = PlatformServiceFactory.getPlatformService().getRewrite(key);
                }
                catch (OAuthProviderException oAuthProviderException) {
                    void e;
                    FFDCFilter.processException((Throwable)oAuthProviderException, (String)"com.ibm.ws.security.oauth20.util.ClientUtils", (String)"196", null, (Object[])new Object[]{providerID, providerRewrites});
                    e.printStackTrace();
                }
                rewriteMap.put(key, newValue);
            }
            uriRewrites.put(providerID, rewriteMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initRewrites");
        }
        return hasRewrites;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static BaseClient uriRewrite(BaseClient client) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uriRewrite");
        }
        BaseClient result = client;
        String providerName = client.getComponentId();
        result.setRedirectUris(ClientUtils.getReWrittenUris(client.getRedirectUris(), providerName));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uriRewrite");
        }
        return result;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public static OidcBaseClient uriRewrite(OidcBaseClient client) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uriRewrite");
        }
        OidcBaseClient result = client;
        String providerName = client.getComponentId();
        result.setRedirectUris(ClientUtils.getReWrittenUris(client.getRedirectUris(), providerName));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uriRewrite");
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private static JsonArray getReWrittenUris(JsonArray originalUris, String providerName) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getReWrittenUris", (Object)new Object[]{originalUris, providerName});
        }
        if (!OidcOAuth20Util.isNullEmpty(originalUris)) {
            JsonArray newRedirectUris = new JsonArray();
            for (int idx = 0; idx < originalUris.size(); ++idx) {
                HashMap<String, String> rewriteMap;
                String uri = originalUris.get(idx).getAsString();
                if (uri.indexOf("${") >= 0 && (rewriteMap = uriRewrites.get(providerName)) != null) {
                    for (String key : rewriteMap.keySet()) {
                        uri = uri.replace(key, rewriteMap.get(key));
                    }
                }
                newRedirectUris.add((JsonElement)new JsonPrimitive(uri));
            }
            JsonArray jsonArray = newRedirectUris;
            if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                jsonArray = jsonArray;
                Tr.exit((TraceComponent)tc, (String)"getReWrittenUris", (Object)jsonArray);
            }
            return jsonArray;
        }
        JsonArray jsonArray = new JsonArray();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            jsonArray = jsonArray;
            Tr.exit((TraceComponent)tc, (String)"getReWrittenUris", (Object)jsonArray);
        }
        return jsonArray;
    }
}

