/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.mediator;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MediatorException;
import com.ibm.oauth.core.api.oauth20.mediator.OAuth20Mediator;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.security.registry.RegistryHelper;
import java.rmi.RemoteException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ResourceOwnerValidationMediator
implements OAuth20Mediator {
    private static TraceComponent tc = Tr.register(ResourceOwnerValidationMediator.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private static final String INVALID = "invalid_resource_owner_credential";
    private UserRegistry reg = null;
    private static final String FLOW_PASSWORD = "password";
    static final long serialVersionUID = -8042854942392365872L;

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void init(OAuthComponentConfiguration config) {
        block5: {
            String methodName = "init";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"init", (Object[])new Object[0]);
            }
            try {
                this.reg = RegistryHelper.getUserRegistry(null);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("init: getUserRegistry returned:" + (this.reg != null ? "not null" : "null")), (Object[])new Object[0]);
                }
            }
            catch (WSSecurityException wSSecurityException) {
                void e;
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.oauth20.mediator.ResourceOwnerValidationMediator", (String)"53", (Object)this, (Object[])new Object[]{config});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Failed to get user registry for resource owner validation", (Object[])new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    @Override
    public void mediateAuthorize(AttributeList attributeList) throws OAuth20MediatorException {
    }

    @Override
    public void mediateAuthorizeException(AttributeList attributeList, OAuthException exception) throws OAuth20MediatorException {
    }

    @Override
    public void mediateResource(AttributeList attributeList) throws OAuth20MediatorException {
    }

    @Override
    public void mediateResourceException(AttributeList attributeList, OAuthException exception) throws OAuth20MediatorException {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void mediateToken(AttributeList attributeList) throws OAuth20MediatorException {
        String methodName = "mediateToken";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mediateToken", (Object[])new Object[0]);
        }
        if (FLOW_PASSWORD.equals(attributeList.getAttributeValueByName("grant_type"))) {
            String username = attributeList.getAttributeValueByName("username");
            String password = attributeList.getAttributeValueByName(FLOW_PASSWORD);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mediateToken: Username and Password is " + username + password), (Object[])new Object[0]);
            }
            try {
                if (this.reg == null) {
                    this.reg = RegistryHelper.getUserRegistry(null);
                    if (this.reg == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"getUserRegistry returned null.", (Object[])new Object[0]);
                        }
                        throw new OAuth20MediatorException(INVALID, new Throwable("getUserRegistry returned null"));
                    }
                }
                this.reg.checkPassword(username, password);
            }
            catch (PasswordCheckFailedException passwordCheckFailedException) {
                void e;
                FFDCFilter.processException((Throwable)passwordCheckFailedException, (String)"com.ibm.ws.security.oauth20.mediator.ResourceOwnerValidationMediator", (String)"116", (Object)this, (Object[])new Object[]{attributeList});
                throw new OAuth20MediatorException(INVALID, (Throwable)e);
            }
            catch (CustomRegistryException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.mediator.ResourceOwnerValidationMediator", (String)"118", (Object)this, (Object[])new Object[]{attributeList});
                throw new OAuth20MediatorException(INVALID, e);
            }
            catch (RemoteException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.mediator.ResourceOwnerValidationMediator", (String)"120", (Object)this, (Object[])new Object[]{attributeList});
                throw new OAuth20MediatorException(INVALID, e);
            }
            catch (WSSecurityException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.mediator.ResourceOwnerValidationMediator", (String)"122", (Object)this, (Object[])new Object[]{attributeList});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to get user registry for resource owner validation", (Object[])new Object[]{e});
                }
                throw new OAuth20MediatorException(INVALID, e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mediateToken");
        }
    }

    @Override
    @ManualTrace
    public void mediateTokenException(AttributeList attributeList, OAuthException exception) throws OAuth20MediatorException {
        String methodName = "mediateTokenException";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mediateTokenException", (Object[])new Object[0]);
        }
        if (FLOW_PASSWORD.equals(attributeList.getAttributeValueByName("grant_type"))) {
            attributeList.setAttribute("access_token", "urn:ibm:names:oauth:response:attribute", new String[0]);
            attributeList.setAttribute("refresh_token", "urn:ibm:names:oauth:response:attribute", new String[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mediateTokenException");
        }
    }
}

