/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20InvalidScopeException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20InvalidScopeException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String[] _requestedScope;
    private String[] _approvedScope;
    private String _reqType;
    private String _clientId;

    public OAuth20InvalidScopeException(String[] requestedScope, String[] approvedScope) {
        super("invalid_scope", "The requested scope: [" + OAuth20InvalidScopeException.arrayToString(requestedScope) + "] exceeds the scope granted by the resource owner: [" + OAuth20InvalidScopeException.arrayToString(approvedScope) + "].", null);
        this._requestedScope = requestedScope;
        this._approvedScope = approvedScope;
    }

    public OAuth20InvalidScopeException(String msgKey, String[] requestedScope, String[] approvedScope) {
        super("invalid_scope", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{OAuth20InvalidScopeException.arrayToString(requestedScope), OAuth20InvalidScopeException.arrayToString(approvedScope)}), null);
        this._msgKey = msgKey;
        this._requestedScope = requestedScope;
        this._approvedScope = approvedScope;
    }

    public OAuth20InvalidScopeException(String msgKey, String[] requestedScope, String[] approvedScope, String clientId) {
        super("invalid_scope", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{OAuth20InvalidScopeException.arrayToString(requestedScope), OAuth20InvalidScopeException.arrayToString(approvedScope), clientId}), null);
        this._msgKey = msgKey;
        this._requestedScope = requestedScope;
        this._approvedScope = approvedScope;
        this._clientId = clientId;
    }

    public OAuth20InvalidScopeException(String msgKey, String requestType) {
        super("invalid_scope", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{requestType}), null);
        this._msgKey = msgKey;
        this._reqType = requestType;
    }

    public OAuth20InvalidScopeException(String msgKey, String requestType, String clientId) {
        super("invalid_scope", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{clientId}), null);
        this._msgKey = msgKey;
        this._reqType = requestType;
        this._clientId = clientId;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        if (this._msgKey.contains("missing.scope")) {
            return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode(this._reqType, locale, encoding));
        }
        if (this._msgKey.contains("missing.registered.scope")) {
            return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode(this._clientId, locale, encoding));
        }
        if (this._msgKey.contains("empty.scope")) {
            return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode(OAuth20InvalidScopeException.arrayToString(this._requestedScope), locale, encoding), WebUtils.encode(OAuth20InvalidScopeException.arrayToString(this._approvedScope), locale, encoding), WebUtils.encode(this._clientId, locale, encoding));
        }
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode(OAuth20InvalidScopeException.arrayToString(this._requestedScope), locale, encoding), WebUtils.encode(OAuth20InvalidScopeException.arrayToString(this._approvedScope), locale, encoding));
    }

    public String[] getRequestedScope() {
        return this._requestedScope;
    }

    public String[] getApprovedScope() {
        return this._approvedScope;
    }

    static String arrayToString(String[] strs) {
        StringBuffer sb = new StringBuffer();
        if (strs != null && strs.length > 0) {
            for (int i = 0; i < strs.length; ++i) {
                sb.append(strs[i]);
                if (i >= strs.length - 1) continue;
                sb.append(",");
            }
        } else {
            return "";
        }
        return sb.toString();
    }
}

