/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.utils;

import io.smallrye.reactive.streams.utils.WrappedSubscription;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class WrappedSubscriber<T>
implements Subscriber<T> {
    private final CompletableFuture<Void> future = new CompletableFuture();
    private final Subscriber<T> source;
    private final AtomicBoolean subscribed = new AtomicBoolean(false);

    public WrappedSubscriber(Subscriber<T> delegate) {
        this.source = delegate;
    }

    public CompletionStage<Void> future() {
        return this.future;
    }

    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription);
        if (this.subscribed.compareAndSet(false, true)) {
            this.source.onSubscribe((Subscription)new WrappedSubscription(subscription, () -> this.future.completeExceptionally(new CancellationException())));
        } else {
            subscription.cancel();
        }
    }

    public void onNext(T item) {
        this.source.onNext(Objects.requireNonNull(item));
    }

    public void onError(Throwable throwable) {
        this.future.completeExceptionally(Objects.requireNonNull(throwable));
        this.source.onError(throwable);
    }

    public void onComplete() {
        this.future.complete(null);
        this.source.onComplete();
    }
}

