/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.xml.ra;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.javaee.dd.common.Description;
import com.ibm.ws.javaee.dd.common.DisplayName;
import com.ibm.ws.javaee.dd.common.Icon;
import com.ibm.ws.javaee.dd.connector.Connector;
import com.ibm.ws.jca.utils.xml.ra.RaAdminObject;
import com.ibm.ws.jca.utils.xml.ra.RaConnectionDefinition;
import com.ibm.ws.jca.utils.xml.ra.RaDescription;
import com.ibm.ws.jca.utils.xml.ra.RaDisplayName;
import com.ibm.ws.jca.utils.xml.ra.RaIcon;
import com.ibm.ws.jca.utils.xml.ra.RaInboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaLicense;
import com.ibm.ws.jca.utils.xml.ra.RaMessageAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaMessageListener;
import com.ibm.ws.jca.utils.xml.ra.RaOutboundResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.RaResourceAdapter;
import com.ibm.ws.jca.utils.xml.ra.v10.Ra10Connector;
import com.ibm.ws.jca.utils.xml.ra.v10.Ra10Icon;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpIbmuiGroups;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaConnector;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@Trivial
@XmlRootElement(name="connector")
@XmlType(name="connectorType", propOrder={"moduleName", "description", "displayName", "icon", "vendorName", "eisType", "resourceAdapterVersion", "license", "resourceAdapter", "requiredWorkContext"})
public class RaConnector
implements Connector {
    private String version;
    private List<RaDescription> description = new LinkedList<RaDescription>();
    private List<RaDisplayName> displayName = new LinkedList<RaDisplayName>();
    private String vendorName;
    private String eisType;
    private String moduleName;
    private String resourceAdapterVersion;
    private RaResourceAdapter resourceAdapter;
    private List<String> requiredWorkContext = new LinkedList<String>();
    @XmlElement(name="icon")
    private final List<RaIcon> icon = new LinkedList<RaIcon>();
    private RaLicense license;
    private Boolean metadataComplete;
    private String id;
    @XmlTransient
    private WlpIbmuiGroups wlp_ibmuiGroups;

    public RaConnector() {
    }

    public RaConnector(Ra10Connector ra10Connector) {
        this();
        this.copyRa10Settings(ra10Connector);
    }

    public void copyRa10Settings(Ra10Connector ra10Connector) {
        if (ra10Connector.getDescription() != null) {
            RaDescription desc = new RaDescription();
            desc.setValue(ra10Connector.getDescription());
            this.description.add(desc);
        }
        RaDisplayName name = new RaDisplayName();
        name.setValue(ra10Connector.getDisplayName());
        this.displayName.add(name);
        Ra10Icon ra10Icon = ra10Connector.getIcon();
        if (ra10Icon != null) {
            RaIcon raIcon = new RaIcon();
            raIcon.copyRa10Settings(ra10Icon);
            this.icon.add(raIcon);
        }
        this.eisType = ra10Connector.getEisType();
        if (ra10Connector.getLicense() != null) {
            this.license = new RaLicense();
            this.license.copyRa10Settings(ra10Connector.getLicense());
        }
        this.resourceAdapter = new RaResourceAdapter();
        this.resourceAdapter.copyRa10Settings(ra10Connector.getResourceAdapter());
        this.version = ra10Connector.getSpecVersion();
        this.vendorName = ra10Connector.getVendorName();
        this.resourceAdapterVersion = ra10Connector.getVersion();
    }

    public WlpIbmuiGroups getWlpIbmuiGroups() {
        return this.wlp_ibmuiGroups;
    }

    @XmlAttribute(name="version", required=true)
    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    @XmlElement(name="description")
    public void setDescription(List<RaDescription> description) {
        this.description = description;
    }

    public List<RaDescription> getDescription() {
        return this.description;
    }

    @XmlElement(name="display-name")
    public void setDisplayName(List<RaDisplayName> displayName) {
        this.displayName = displayName;
    }

    public List<RaDisplayName> getDisplayName() {
        return this.displayName;
    }

    @XmlElement(name="vendor-name")
    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    @XmlElement(name="eis-type")
    public void setEisType(String eisType) {
        this.eisType = eisType;
    }

    public String getEisType() {
        return this.eisType;
    }

    @XmlElement(name="resourceadapter-version")
    public void setResourceAdapterVersion(String resourceAdapterVersion) {
        this.resourceAdapterVersion = resourceAdapterVersion;
    }

    public String getResourceAdapterVersion() {
        return this.resourceAdapterVersion;
    }

    @XmlElement(name="resourceadapter", required=true)
    public void setResourceAdapter(RaResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public RaResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    @XmlElement(name="module-name")
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @XmlElement(name="required-work-context")
    public void setRequiredWorkContext(List<String> requiredWorkContext) {
        this.requiredWorkContext = requiredWorkContext;
    }

    public List<String> getRequiredWorkContext() {
        return this.requiredWorkContext;
    }

    @XmlElement(name="license")
    public void setLicense(RaLicense license) {
        this.license = license;
    }

    public RaLicense getLicense() {
        return this.license;
    }

    public void copyWlpSettings(WlpRaConnector connector) {
        this.wlp_ibmuiGroups = connector.getWlpIbmuiGroups();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RaConnector{display-name='");
        if (this.displayName != null) {
            sb.append(this.displayName);
        }
        sb.append("'}");
        return sb.toString();
    }

    public RaAdminObject getAdminObject(String adminObjectInterface, String adminObjectClass) {
        return this.resourceAdapter.getAdminObject(adminObjectInterface, adminObjectClass);
    }

    public RaConnectionDefinition getConnectionDefinition(String connectionFactoryInterface) {
        RaOutboundResourceAdapter outbound = this.resourceAdapter.getOutboundResourceAdapter();
        if (outbound == null) {
            return null;
        }
        return outbound.getConnectionDefinitionByInterface(connectionFactoryInterface);
    }

    public RaMessageListener getMessageListener(String messageListenerType) {
        RaInboundResourceAdapter inbound = this.resourceAdapter.getInboundResourceAdapter();
        if (inbound == null) {
            return null;
        }
        RaMessageAdapter messageAdapter = inbound.getMessageAdapter();
        if (messageAdapter == null) {
            return null;
        }
        return messageAdapter.getMessageListenerByType(messageListenerType);
    }

    public List<DisplayName> getDisplayNames() {
        ArrayList<DisplayName> names = new ArrayList<DisplayName>();
        for (RaDisplayName name : this.displayName) {
            names.add(name);
        }
        return names;
    }

    public List<Icon> getIcons() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        for (RaIcon raIcon : this.icon) {
            icons.add(raIcon);
        }
        return icons;
    }

    public List<Description> getDescriptions() {
        ArrayList<Description> descs = new ArrayList<Description>();
        for (RaDescription raDesc : this.description) {
            descs.add(raDesc);
        }
        return descs;
    }

    public Boolean getMetadataComplete() {
        if (this.metadataComplete == null) {
            this.metadataComplete = Boolean.FALSE;
        }
        return this.metadataComplete;
    }

    @XmlAttribute(name="metadata-complete")
    public void setMetadataComplete(Boolean metadataComplete) {
        this.metadataComplete = metadataComplete;
    }

    public String getId() {
        return this.id;
    }

    @XmlID
    @XmlAttribute(name="id")
    public void setId(String id) {
        this.id = id;
    }
}

