/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.io.BaseEncoding;
import jakarta.annotation.Nullable;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.common.binding.artifact.SAMLArtifact;
import org.opensaml.saml.common.binding.artifact.SAMLSourceIDArtifact;
import org.opensaml.saml.criterion.ArtifactCriterion;
import org.opensaml.saml.metadata.resolver.impl.EntityIDDigestGenerator;

public class DefaultLocalDynamicSourceKeyGenerator
extends EntityIDDigestGenerator {
    private static final BaseEncoding HEX = BaseEncoding.base16().lowerCase();

    public DefaultLocalDynamicSourceKeyGenerator() {
    }

    public DefaultLocalDynamicSourceKeyGenerator(@Nullable String keyPrefix, @Nullable String keySuffix, @Nullable String valueSeparator) {
        super(null, keyPrefix, keySuffix, valueSeparator);
    }

    @Override
    @Nullable
    public String apply(@Nullable CriteriaSet criteria) {
        SAMLArtifact artifact;
        if (criteria == null) {
            return null;
        }
        if (criteria.contains(EntityIdCriterion.class)) {
            return super.apply(criteria);
        }
        if (criteria.contains(ArtifactCriterion.class) && (artifact = ((ArtifactCriterion)criteria.get(ArtifactCriterion.class)).getArtifact()) instanceof SAMLSourceIDArtifact) {
            return this.buildKey(HEX.encode(((SAMLSourceIDArtifact)artifact).getSourceID()));
        }
        return null;
    }
}

