/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.joblog.internal.impl;

import com.ibm.ejs.ras.Traceable;
import com.ibm.ejs.ras.Untraceable;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.DataFormatHelper;
import com.ibm.websphere.ras.TruncatableThrowable;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jbatch.joblog.internal.impl.JobLogEntryDetail;
import com.ibm.ws.jbatch.joblog.internal.impl.StringUtils;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

@Trivial
public class JobLogFormatter
extends Formatter {
    public static final String banner = "********************************************************************************";
    public static final Object NULL_ID = null;
    public static final String NULL_FORMATTED_MSG = null;
    static final int basicNameLength = 13;
    static final int enhancedNameLength = 60;
    static final int MAX_DATA_LENGTH = 16384;
    static final String nl = System.getProperty("line.separator");
    static final String pad8 = "        ";
    static final String basicPadding = "                                 ";
    static final String advancedPadding = "          ";
    static final String enhancedPadding = "                                                                                                               ";
    static final String nullParamString = "null";
    static final String badParamString = "<malformed parameter>";
    static final String emptyString = "";
    static final String emptyStringReplacement = "\"\"";
    static final String ENTRY = "Entry ";
    static final String EXIT = "Exit ";
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String NAME_FORMAT = "[%-8s] ";
    private static final String N_INFO = String.format("[%-8s] ", Level.INFO.getLocalizedName());
    private static final String N_AUDIT = String.format("[%-8s] ", WsLevel.AUDIT.getLocalizedName());
    private static final String N_EVENT = String.format("[%-8s] ", WsLevel.EVENT.getLocalizedName());
    private static final String N_WARN = String.format("[%-8s] ", Level.WARNING.getLocalizedName());
    private static final String N_ERROR = String.format("[%-8s] ", WsLevel.ERROR.getLocalizedName());
    private static final String N_FATAL = String.format("[%-8s] ", WsLevel.FATAL.getLocalizedName());

    public static final String levelToString(Level level) {
        if (level != null) {
            int l = level.intValue();
            if (l == WsLevel.FATAL.intValue()) {
                return N_FATAL;
            }
            if (l == WsLevel.ERROR.intValue()) {
                return N_ERROR;
            }
            if (l == Level.WARNING.intValue()) {
                return N_WARN;
            }
            if (l == WsLevel.AUDIT.intValue()) {
                return N_AUDIT;
            }
            if (l == Level.INFO.intValue()) {
                return N_INFO;
            }
            if (level == WsLevel.EVENT) {
                return N_EVENT;
            }
        }
        return emptyString;
    }

    @Override
    public String format(LogRecord r) {
        String detail = this.getDetailString(r);
        String text = this.formatMessage(r);
        return this.createFormattedString(r, NULL_ID, text, detail);
    }

    private String getDetailString(LogRecord record) {
        String result = emptyString;
        Object[] logParams = record.getParameters();
        if (logParams != null && logParams.length > 0) {
            for (int i = 0; i < logParams.length; ++i) {
                if (!(logParams[i] instanceof JobLogEntryDetail)) continue;
                result = result.concat(logParams[i].toString());
                record.setParameters(this.removeArg(logParams, i));
            }
        }
        return result;
    }

    @Override
    public String formatMessage(LogRecord logRecord) {
        return this.formatMessage(logRecord, logRecord.getParameters(), true);
    }

    private String formatMessage(LogRecord logRecord, Object[] logParams, boolean useResourceBundle) {
        String txt;
        ResourceBundle rb;
        boolean hasParams = logParams != null && logParams.length > 0;
        String msg = logRecord.getMessage();
        if (useResourceBundle && (rb = logRecord.getResourceBundle()) != null) {
            try {
                msg = rb.getString(msg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (msg != null && hasParams && msg.contains("{0")) {
            Object[] formattedParams = new Object[logParams.length];
            for (int i = 0; i < logParams.length; ++i) {
                formattedParams[i] = logParams[i] instanceof TruncatableThrowable ? DataFormatHelper.throwableToString((Throwable)((TruncatableThrowable)logParams[i])) : (logParams[i] instanceof Throwable ? DataFormatHelper.throwableToString((Throwable)new TruncatableThrowable((Throwable)logParams[i])) : logParams[i]);
            }
            txt = MessageFormat.format(msg, formattedParams);
        } else {
            txt = msg + (hasParams ? " " + this.formatObj(logParams) : emptyString);
        }
        return txt;
    }

    private String createFormattedString(LogRecord logRecord, Object id, String txt, String detail) {
        String method = logRecord.getSourceMethodName();
        String className = StringUtils.firstNonEmpty(logRecord.getSourceClassName(), logRecord.getLoggerName());
        String stackTrace = this.getStackTrace(logRecord);
        StringBuilder sb = new StringBuilder(256);
        sb.append('[').append(DataFormatHelper.formatTime((long)logRecord.getMillis())).append("] ");
        if (detail != null && detail.length() > 0) {
            sb.append("[").append(detail).append("] ");
        }
        if (className != null) {
            sb.append(String.format("%-60.60s   ", className));
        } else {
            sb.append(String.format("%-60.60s   ", " "));
        }
        if (method != null) {
            sb.append(method + " ");
        }
        sb.append(txt);
        if (stackTrace != null) {
            sb.append(nl + basicPadding).append(stackTrace);
        }
        sb.append(nl);
        return sb.toString();
    }

    private String getStackTrace(LogRecord logRecord) {
        Throwable t = logRecord.getThrown();
        if (t != null) {
            return DataFormatHelper.throwableToString((Throwable)t);
        }
        return null;
    }

    public String formatObj(Object objs) {
        String ans;
        block24: {
            String nlPad;
            block20: {
                block21: {
                    StringBuilder sb;
                    block23: {
                        int len;
                        block22: {
                            ans = emptyString;
                            nlPad = nl + basicPadding;
                            String nlPadA = nlPad + " ";
                            if (objs == null) break block20;
                            if (!objs.getClass().isArray()) break block21;
                            sb = new StringBuilder();
                            len = Array.getLength(objs);
                            if (!objs.getClass().getName().equals("[B")) break block22;
                            int COLUMNS = 32;
                            byte[] b = (byte[])objs;
                            int printLen = len > 16384 ? 16384 : len;
                            sb.append(nlPad).append(objs.toString()).append(",len=").append(len);
                            for (int i = 0; i < printLen; ++i) {
                                if (i % 32 == 0) {
                                    sb.append(nlPadA + '|' + DataFormatHelper.padHexString((int)i, (int)4) + '|');
                                }
                                if (i % 4 == 0) {
                                    sb.append(" ");
                                }
                                sb.append(hexChars[b[i] >> 4 & 0xF]);
                                sb.append(hexChars[b[i] & 0xF]);
                            }
                            if (printLen == len) break block23;
                            sb.append(nlPadA).append(" ...");
                            break block23;
                        }
                        if (objs.getClass().getName().equals("[C")) {
                            sb.append((char[])objs);
                        } else {
                            for (int i = 0; i < len; ++i) {
                                String s = this.formatObj(Array.get(objs, i));
                                if (s.startsWith(nl)) {
                                    sb.append(s);
                                } else {
                                    sb.append(nlPad + s);
                                }
                                if (sb.length() <= 16384) continue;
                                sb.append(nlPad + "...");
                                break;
                            }
                        }
                    }
                    ans = sb.toString();
                    break block24;
                }
                if (objs instanceof Untraceable) {
                    ans = nlPad + objs.getClass().getName();
                } else if (objs instanceof Traceable) {
                    try {
                        ans = nlPad + ((Traceable)objs).toTraceString();
                    }
                    catch (Exception e) {
                        ans = "<Exception " + e + " caught while calling toTraceString() on object " + objs.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(objs)) + ">";
                    }
                } else if (objs instanceof TruncatableThrowable) {
                    ans = nlPad + DataFormatHelper.throwableToString((Throwable)((TruncatableThrowable)objs));
                } else if (objs instanceof Throwable) {
                    ans = nlPad + DataFormatHelper.throwableToString((Throwable)new TruncatableThrowable((Throwable)objs));
                } else {
                    try {
                        ans = nlPad + objs.toString();
                    }
                    catch (Exception e) {
                        ans = "<Exception " + e + " caught while calling toString() on object " + objs.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(objs)) + ">";
                    }
                }
                break block24;
            }
            ans = nlPad + nullParamString;
        }
        return ans;
    }

    private Object[] removeArg(Object[] args, int indexToRemove) {
        Object[] result = new Object[args.length - 1];
        int j = 0;
        for (int i = 0; i < args.length; ++i) {
            if (i == indexToRemove) continue;
            result[j] = args[i];
            ++j;
        }
        return result;
    }

    static enum LevelFormat {
        FATAL(WsLevel.FATAL, " F "),
        ERROR(WsLevel.ERROR, " E "),
        WARNING(Level.WARNING, " W "),
        AUDIT(WsLevel.AUDIT, " A "),
        INFO(Level.INFO, " I "),
        CONFIG(Level.CONFIG, " C "),
        DETAIL(WsLevel.DETAIL, " D "),
        EVENT(WsLevel.FINE, " 1 "),
        FINE(Level.FINE, " 1 "),
        FINER(Level.FINER, " 2 "),
        FINEST(Level.FINEST, " 3 ");

        final Level level;
        final int id;
        final String marker;

        private LevelFormat(Level l, String s) {
            this.level = l;
            this.id = l.intValue();
            this.marker = s;
        }

        public static LevelFormat findFormat(Level level) {
            int levelId = level.intValue();
            for (LevelFormat f : LevelFormat.values()) {
                if (level == f.level) {
                    return f;
                }
                if (levelId != f.id) continue;
                return f;
            }
            return null;
        }
    }
}

