/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.OtlpDeclarativeConfigUtil;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;

public class OtlpLogRecordExporterComponentProvider
implements ComponentProvider<LogRecordExporter> {
    @Override
    public Class<LogRecordExporter> getType() {
        return LogRecordExporter.class;
    }

    @Override
    public String getName() {
        return "otlp";
    }

    @Override
    public LogRecordExporter create(DeclarativeConfigProperties config) {
        String protocol = OtlpDeclarativeConfigUtil.getStructuredConfigOtlpProtocol(config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpLogRecordExporterBuilder builder = this.httpBuilder();
            OtlpDeclarativeConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcLogRecordExporterBuilder builder = this.grpcBuilder();
            OtlpDeclarativeConfigUtil.configureOtlpExporterBuilder("logs", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    OtlpHttpLogRecordExporterBuilder httpBuilder() {
        return OtlpHttpLogRecordExporter.builder();
    }

    OtlpGrpcLogRecordExporterBuilder grpcBuilder() {
        return OtlpGrpcLogRecordExporter.builder();
    }
}

