/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaConnectorException;
import com.ibm.ws.microprofile.reactive.messaging.kafka.KafkaInput;
import com.ibm.ws.microprofile.reactive.messaging.kafka.PartitionTracker;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.KafkaAdapterFactory;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.OffsetAndMetadata;
import com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.TopicPartition;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.reactive.messaging.internal.interfaces.RMAsyncProvider;
import io.openliberty.microprofile.reactive.messaging.internal.interfaces.RMContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CommittingPartitionTracker
extends PartitionTracker {
    private static final TraceComponent tc = Tr.register(CommittingPartitionTracker.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
    private final KafkaAdapterFactory factory;
    private final RMAsyncProvider asyncProvider;
    private final KafkaInput<?, ?> kafkaInput;
    private final int maxCommitBatchSize;
    private final Duration maxCommitBatchInterval;
    private final SortedSet<CompletedWork> completedWork = new TreeSet<CompletedWork>();
    private int outstandingUncommittedWork = 0;
    private long committedOffset;
    private Future<?> pendingCommitTask = null;
    static final long serialVersionUID = -2264835601666867063L;

    public CommittingPartitionTracker(TopicPartition topicPartition, KafkaAdapterFactory factory, KafkaInput<?, ?> kafkaInput, long initialCommittedOffset, RMAsyncProvider asyncProvider, int maxCommitBatchSize, Duration maxCommitBatchInterval) {
        super(topicPartition);
        this.factory = factory;
        this.kafkaInput = kafkaInput;
        this.asyncProvider = asyncProvider;
        this.committedOffset = initialCommittedOffset;
        this.maxCommitBatchSize = maxCommitBatchSize;
        this.maxCommitBatchInterval = maxCommitBatchInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public CompletionStage<Void> recordDone(long offset, Optional<Integer> leaderEpoch, RMContext context) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            SortedSet<CompletedWork> sortedSet = this.completedWork;
            synchronized (sortedSet) {
                boolean isNewOffset = offset < this.committedOffset ? false : this.completedWork.add(new CompletedWork(offset, leaderEpoch, result, context));
                if (isNewOffset) {
                    ++this.outstandingUncommittedWork;
                    this.requestCommit();
                } else {
                    result.completeExceptionally(new IllegalStateException("recordDone called more than once for offset " + offset));
                }
            }
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.CommittingPartitionTracker", (String)"135", (Object)this, (Object[])new Object[]{offset, leaderEpoch, context});
            Tr.error((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[]{t});
            result.completeExceptionally(new KafkaConnectorException(Tr.formatMessage((TraceComponent)tc, (String)"internal.kafka.connector.error.CWMRX1000E", (Object[])new Object[0]), (Throwable)t));
        }
        return result;
    }

    private void requestCommit() {
        if (this.maxCommitBatchSize > 0 && this.outstandingUncommittedWork > this.maxCommitBatchSize) {
            if (this.pendingCommitTask != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Cancelling scheduled commit task because we're committing right now", (Object[])new Object[]{this});
                }
                this.pendingCommitTask.cancel(true);
            }
            this.commitCompletedWork();
        } else if (this.pendingCommitTask == null && !this.maxCommitBatchInterval.isZero()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Scheduling deferred commit task", (Object[])new Object[]{this});
            }
            this.pendingCommitTask = this.asyncProvider.getScheduledExecutorService().schedule(this::commitCompletedWork, this.maxCommitBatchInterval.toNanos(), TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitCompletedWork() {
        SortedSet<CompletedWork> sortedSet = this.completedWork;
        synchronized (sortedSet) {
            if (Thread.interrupted()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Commit task running but has been cancelled", (Object[])new Object[]{this});
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Checking for new work to commit, last committed offset is " + this.committedOffset), (Object[])new Object[]{this});
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Current completed work", (Object[])new Object[]{this.completedWork});
            }
            long newCommitOffset = this.committedOffset;
            CompletedWork newestWork = null;
            for (CompletedWork work : this.completedWork) {
                if (work.offset < newCommitOffset) continue;
                if (work.offset != newCommitOffset) break;
                ++newCommitOffset;
                newestWork = work;
            }
            if (newestWork != null) {
                long originalCommitOffset = this.committedOffset;
                long finalCommitOffset = newCommitOffset;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Committing from " + originalCommitOffset + " to " + finalCommitOffset), (Object[])new Object[]{this});
                }
                this.commitUpTo(newestWork).whenCompleteAsync((r, t) -> this.processCommittedWork(originalCommitOffset, finalCommitOffset, (Throwable)t), this.asyncProvider.getExecutorService());
            }
            this.outstandingUncommittedWork = (int)((long)this.outstandingUncommittedWork - (newCommitOffset - this.committedOffset));
            this.pendingCommitTask = null;
            this.committedOffset = newCommitOffset;
        }
    }

    private CompletionStage<Void> commitUpTo(CompletedWork work) {
        OffsetAndMetadata offsetAndMetadata = this.factory.newOffsetAndMetadata(work.offset + 1L, work.leaderEpoch, null);
        return this.kafkaInput.commitOffsets(this, offsetAndMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommittedWork(long originalOffset, long committedOffset, Throwable exception) {
        boolean isRetriable = false;
        if (exception != null && this.factory.getRetryableExceptionClass().isInstance(exception)) {
            isRetriable = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (exception == null) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Commit from " + originalOffset + " to " + committedOffset + " completed successfully"), (Object[])new Object[]{this});
            } else if (isRetriable) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Commit from " + originalOffset + " to " + committedOffset + " failed with retriable exception"), (Object[])new Object[]{this, exception});
            } else {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Commit from " + originalOffset + " to " + committedOffset + " failed with non-retriable exception"), (Object[])new Object[]{this, exception});
            }
        }
        if (isRetriable) {
            SortedSet<CompletedWork> sortedSet = this.completedWork;
            synchronized (sortedSet) {
                if (committedOffset == this.committedOffset) {
                    CompletedWork work;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Retriable exception is for the most recent commit attempt", (Object[])new Object[]{this});
                    }
                    CompletedWork lastWork = null;
                    Iterator iterator = this.completedWork.iterator();
                    while (iterator.hasNext() && (work = (CompletedWork)iterator.next()).offset < committedOffset) {
                        lastWork = work;
                    }
                    if (lastWork != null) {
                        this.commitUpTo(lastWork).whenCompleteAsync((r, t) -> this.processCommittedWork(originalOffset, committedOffset, (Throwable)t), this.asyncProvider.getExecutorService());
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Would retry commit to " + committedOffset + " but completedWork contains nothing before this offset"), (Object[])new Object[0]);
                    }
                }
            }
            return;
        }
        ArrayList<CompletedWork> committedWork = new ArrayList<CompletedWork>();
        Iterator iterator = this.completedWork;
        synchronized (iterator) {
            Iterator i = this.completedWork.iterator();
            while (i.hasNext()) {
                CompletedWork work = (CompletedWork)i.next();
                if (work.offset < originalOffset) continue;
                if (work.offset >= committedOffset) break;
                committedWork.add(work);
                i.remove();
            }
        }
        if (exception == null) {
            for (CompletedWork work : committedWork) {
                work.context.execute(() -> work.completion.complete(null));
            }
        } else {
            for (CompletedWork work : committedWork) {
                work.context.execute(() -> work.completion.completeExceptionally(exception));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SortedSet<CompletedWork> sortedSet = this.completedWork;
        synchronized (sortedSet) {
            try {
                this.kafkaInput.runPendingActions();
                if (!this.completedWork.isEmpty()) {
                    this.commitCompletedWork();
                }
            }
            finally {
                super.close();
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class CompletedWork
    implements Comparable<CompletedWork> {
        private final long offset;
        private final CompletableFuture<Void> completion;
        private final Optional<Integer> leaderEpoch;
        private final RMContext context;
        static final long serialVersionUID = 2819359574727523234L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CompletedWork(long offset, Optional<Integer> leaderEpoch, CompletableFuture<Void> completion, RMContext context) {
            this.offset = offset;
            this.leaderEpoch = leaderEpoch;
            this.completion = completion;
            this.context = context;
        }

        public CompletableFuture<Void> getCompletion() {
            return this.completion;
        }

        public Optional<Integer> getLeaderEpoch() {
            return this.leaderEpoch;
        }

        public RMContext getContext() {
            return this.context;
        }

        @Override
        public int compareTo(CompletedWork o) {
            return Long.compare(this.offset, o.offset);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.reactive.messaging.kafka.CommittingPartitionTracker$CompletedWork", CompletedWork.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
        }
    }
}

